/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work;

import org.cytoscape.work.Task;

public final class FinishStatus {
    final Type type;
    final Task task;
    final Exception exception;
    private static final FinishStatus SUCCEEDED = new FinishStatus(Type.SUCCEEDED, null, null);

    public static FinishStatus getSucceeded() {
        return SUCCEEDED;
    }

    public static FinishStatus newCancelled(Task cancelledTask) {
        return new FinishStatus(Type.CANCELLED, cancelledTask, null);
    }

    public static FinishStatus newFailed(Task failedTask, Exception exception) {
        return new FinishStatus(Type.FAILED, failedTask, exception);
    }

    protected FinishStatus(Type type, Task task, Exception exception) {
        this.type = type;
        this.task = task;
        this.exception = exception;
    }

    public Type getType() {
        return this.type;
    }

    public Task getTask() {
        return this.task;
    }

    public Exception getException() {
        return this.exception;
    }

    public static enum Type {
        SUCCEEDED,
        CANCELLED,
        FAILED;

    }
}

