/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableHandler;
import org.cytoscape.work.TunableHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicTunableHandlerFactory<T extends TunableHandler>
implements TunableHandlerFactory<T> {
    private final Class<T> tunableHandlerClass;
    private final Class<?>[] allowedTypes;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public BasicTunableHandlerFactory(Class<T> tunableHandlerClass, Class<?> ... allowedTypes) {
        this.tunableHandlerClass = tunableHandlerClass;
        this.allowedTypes = allowedTypes;
    }

    @Override
    public final T createTunableHandler(Field field, Object instance, Tunable tunable) {
        if (!this.properType(field.getType())) {
            return null;
        }
        try {
            Constructor<T> con = this.tunableHandlerClass.getConstructor(Field.class, Object.class, Tunable.class);
            return (T)((TunableHandler)con.newInstance(field, instance, tunable));
        }
        catch (Exception e) {
            logger.warn("Failed to construct tunable handler. Missing Field based constructor for class: " + this.tunableHandlerClass.getName(), (Throwable)e);
            return null;
        }
    }

    @Override
    public final T createTunableHandler(Method getter, Method setter, Object instance, Tunable tunable) {
        if (!this.properType(getter.getReturnType())) {
            return null;
        }
        try {
            Constructor<T> con = this.tunableHandlerClass.getConstructor(Method.class, Method.class, Object.class, Tunable.class);
            return (T)((TunableHandler)con.newInstance(getter, setter, instance, tunable));
        }
        catch (Exception e) {
            logger.warn("Failed to construct tunable handler. Missing Method based constructor for class: " + this.tunableHandlerClass.getName(), (Throwable)e);
            return null;
        }
    }

    private boolean properType(Class<?> c) {
        for (Class<?> allowed : this.allowedTypes) {
            if (!allowed.isAssignableFrom(c)) continue;
            return true;
        }
        return false;
    }
}

