/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap;

import java.util.Collections;
import java.util.Set;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualLexiconNode;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.events.VisualPropertyDependencyChangedEvent;

public final class VisualPropertyDependency<T> {
    private final String id;
    private final String displayName;
    private final Set<VisualProperty<T>> vpSet;
    private final VisualProperty<T> parentVisualProperty;
    private boolean enabled;
    private CyEventHelper eventHelper;

    public VisualPropertyDependency(String id, String displayName, Set<VisualProperty<T>> vpSet, VisualLexicon lexicon) {
        this.id = id;
        this.displayName = displayName;
        this.vpSet = vpSet;
        this.enabled = false;
        this.parentVisualProperty = this.getParent(lexicon);
    }

    private VisualProperty<T> getParent(VisualLexicon lexicon) {
        VisualProperty<?> parent = null;
        for (VisualProperty<T> vp : this.vpSet) {
            VisualLexiconNode node = lexicon.getVisualLexiconNode(vp);
            if (parent == null) {
                parent = node.getParent().getVisualProperty();
                continue;
            }
            VisualProperty<?> newParent = node.getParent().getVisualProperty();
            if (newParent == parent) continue;
            throw new IllegalArgumentException("All Visual Properties should points to the same parent: " + newParent.getDisplayName() + ", " + parent.getDisplayName());
        }
        return parent;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getIdString() {
        return this.id;
    }

    public Set<VisualProperty<?>> getVisualProperties() {
        return Collections.unmodifiableSet(this.vpSet);
    }

    public void setDependency(boolean enable) {
        if (enable != this.enabled) {
            this.enabled = enable;
            if (this.eventHelper != null) {
                this.eventHelper.fireEvent(new VisualPropertyDependencyChangedEvent(this));
            }
        }
    }

    public boolean isDependencyEnabled() {
        return this.enabled;
    }

    public VisualProperty<T> getParentVisualProperty() {
        return this.parentVisualProperty;
    }

    public void setEventHelper(CyEventHelper eventHelper) {
        this.eventHelper = eventHelper;
    }

    public String toString() {
        return this.displayName;
    }

    public int hashCode() {
        int prime = 37;
        int result = 23;
        result = 37 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisualPropertyDependency)) {
            return false;
        }
        VisualPropertyDependency other = (VisualPropertyDependency)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

