/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.presentation.property.values;

import java.util.SortedSet;
import java.util.TreeSet;

public enum Position {
    NORTH_WEST("Northwest", "NW"),
    NORTH("North", "N"),
    NORTH_EAST("Northeast", "NE"),
    WEST("West", "W"),
    CENTER("Center", "C"),
    EAST("East", "E"),
    SOUTH_WEST("Southwest", "SW"),
    SOUTH("South", "S"),
    SOUTH_EAST("Southeast", "SE"),
    NONE("None", "NONE");

    private static SortedSet<String> displayNames;
    private final String displayName;
    private final String shortName;

    private Position(String displayName, String shortName) {
        this.displayName = displayName;
        this.shortName = shortName;
    }

    public String getName() {
        return this.displayName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public static Position parse(String value) {
        for (Position p : Position.values()) {
            if (!p.getName().equals(value) && !p.getShortName().equals(value)) continue;
            return p;
        }
        return CENTER;
    }

    public static SortedSet<String> getDisplayNames() {
        if (displayNames == null) {
            displayNames = new TreeSet<String>();
            for (Position p : Position.values()) {
                displayNames.add(p.displayName);
            }
        }
        return displayNames;
    }
}

