/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.presentation.property;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.view.model.AbstractVisualProperty;
import org.cytoscape.view.model.DiscreteRange;
import org.cytoscape.view.presentation.property.values.AbstractVisualPropertyValue;
import org.cytoscape.view.presentation.property.values.LabelBackgroundShape;

public final class LabelBackgroundShapeVisualProperty
extends AbstractVisualProperty<LabelBackgroundShape> {
    public static final LabelBackgroundShape NONE = new LabelBackgroundShapeImpl("None", "NONE");
    public static final LabelBackgroundShape RECTANGLE = new LabelBackgroundShapeImpl("Rectangle", "RECTANGLE");
    public static final LabelBackgroundShape ROUND_RECTANGLE = new LabelBackgroundShapeImpl("Round Rectangle", "ROUND_RECTANGLE");
    private static final DiscreteRange<LabelBackgroundShape> NODE_SHAPE_RANGE;
    private static final Map<String, LabelBackgroundShape> DEFAULT_SHAPES;

    public LabelBackgroundShapeVisualProperty(LabelBackgroundShape defaultValue, String id, String displayName, Class<? extends CyIdentifiable> modelDataType) {
        super(defaultValue, NODE_SHAPE_RANGE, id, displayName, modelDataType);
    }

    @Override
    public String toSerializableString(LabelBackgroundShape value) {
        return value.getSerializableString();
    }

    @Override
    public LabelBackgroundShape parseSerializableString(String value) {
        LabelBackgroundShape shape = null;
        if (value != null) {
            shape = DEFAULT_SHAPES.get(value.toUpperCase());
        }
        if (shape == null) {
            for (LabelBackgroundShape ns : NODE_SHAPE_RANGE.values()) {
                if (!ns.getSerializableString().equalsIgnoreCase(value)) continue;
                shape = ns;
                break;
            }
        }
        return shape;
    }

    public static boolean isDefaultShape(LabelBackgroundShape shape) {
        for (LabelBackgroundShape s : DEFAULT_SHAPES.values()) {
            if (!shape.equals(s)) continue;
            return true;
        }
        return false;
    }

    static {
        DEFAULT_SHAPES = new HashMap<String, LabelBackgroundShape>();
        DEFAULT_SHAPES.put(ROUND_RECTANGLE.getSerializableString().toUpperCase(), ROUND_RECTANGLE);
        DEFAULT_SHAPES.put(RECTANGLE.getSerializableString().toUpperCase(), RECTANGLE);
        DEFAULT_SHAPES.put(NONE.getSerializableString().toUpperCase(), NONE);
        NODE_SHAPE_RANGE = new DiscreteRange<LabelBackgroundShape>(LabelBackgroundShape.class, new HashSet<LabelBackgroundShape>(DEFAULT_SHAPES.values()));
    }

    private static final class LabelBackgroundShapeImpl
    extends AbstractVisualPropertyValue
    implements LabelBackgroundShape {
        public LabelBackgroundShapeImpl(String displayName, String serializableString) {
            super(displayName, serializableString);
        }
    }
}

