/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.presentation.property;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.Map;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.ContinuousRange;
import org.cytoscape.view.model.NullDataType;
import org.cytoscape.view.model.Range;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.Visualizable;
import org.cytoscape.view.presentation.property.AbstractVisualLexicon;
import org.cytoscape.view.presentation.property.ArrowShapeVisualProperty;
import org.cytoscape.view.presentation.property.BooleanVisualProperty;
import org.cytoscape.view.presentation.property.DefaultVisualizableVisualProperty;
import org.cytoscape.view.presentation.property.DoubleVisualProperty;
import org.cytoscape.view.presentation.property.EdgeBendVisualProperty;
import org.cytoscape.view.presentation.property.EdgeStackingVisualProperty;
import org.cytoscape.view.presentation.property.FontVisualProperty;
import org.cytoscape.view.presentation.property.IntegerVisualProperty;
import org.cytoscape.view.presentation.property.LabelBackgroundShapeVisualProperty;
import org.cytoscape.view.presentation.property.LineTypeVisualProperty;
import org.cytoscape.view.presentation.property.NodeShapeVisualProperty;
import org.cytoscape.view.presentation.property.ObjectPositionVisualProperty;
import org.cytoscape.view.presentation.property.PaintVisualProperty;
import org.cytoscape.view.presentation.property.StringVisualProperty;
import org.cytoscape.view.presentation.property.values.ArrowShape;
import org.cytoscape.view.presentation.property.values.BendFactory;
import org.cytoscape.view.presentation.property.values.EdgeStacking;
import org.cytoscape.view.presentation.property.values.LabelBackgroundShape;
import org.cytoscape.view.presentation.property.values.LineType;
import org.cytoscape.view.presentation.property.values.NodeShape;
import org.cytoscape.view.presentation.property.values.ObjectPosition;

public class BasicVisualLexicon
extends AbstractVisualLexicon {
    private static final double DEF_BORDER_WIDTH = 2.0;
    private static final int DEF_FONT_SIZE = 12;
    public static final VisualProperty<Visualizable> NETWORK = new DefaultVisualizableVisualProperty("NETWORK", "Network Visual Property", CyNetwork.class);
    public static final VisualProperty<Visualizable> NODE = new DefaultVisualizableVisualProperty("NODE", "Node Visual Property", CyNode.class);
    public static final VisualProperty<Visualizable> EDGE = new DefaultVisualizableVisualProperty("EDGE", "Edge Visual Property", CyEdge.class);
    public static final VisualProperty<Paint> NODE_PAINT = new PaintVisualProperty(new Color(120, 120, 120), PAINT_RANGE, "NODE_PAINT", "Node Paint", (Class<? extends CyIdentifiable>)CyNode.class);
    public static final VisualProperty<Paint> NODE_FILL_COLOR = new PaintVisualProperty(new Color(200, 0, 0), PAINT_RANGE, "NODE_FILL_COLOR", "Node Fill Color", (Class<? extends CyIdentifiable>)CyNode.class);
    public static final VisualProperty<Paint> NODE_LABEL_COLOR = new PaintVisualProperty(Color.BLACK, PAINT_RANGE, "NODE_LABEL_COLOR", "Node Label Color", (Class<? extends CyIdentifiable>)CyNode.class);
    public static final VisualProperty<LabelBackgroundShape> NODE_LABEL_BACKGROUND_SHAPE = new LabelBackgroundShapeVisualProperty(LabelBackgroundShapeVisualProperty.NONE, "NODE_LABEL_BACKGROUND_SHAPE", "Node Label Background Shape", CyNode.class);
    public static final VisualProperty<Paint> NODE_LABEL_BACKGROUND_COLOR = new PaintVisualProperty(Color.GRAY.brighter(), PAINT_RANGE, "NODE_LABEL_BACKGROUND_COLOR", "Node Label Background Color", (Class<? extends CyIdentifiable>)CyNode.class);
    public static final VisualProperty<Integer> NODE_LABEL_BACKGROUND_TRANSPARENCY = new IntegerVisualProperty(255, (Range<Integer>)new ContinuousRange<Integer>(Integer.class, 0, 255, true, true), "NODE_LABEL_BACKGROUND_TRANSPARENCY", "Node Label Background Transparency", (Class<? extends CyIdentifiable>)CyNode.class);
    public static final VisualProperty<String> NODE_LABEL = new StringVisualProperty("", ARBITRARY_STRING_RANGE, "NODE_LABEL", "Node Label", CyNode.class);
    public static final VisualProperty<Double> NODE_X_LOCATION = new DoubleVisualProperty(0.0, ARBITRARY_DOUBLE_RANGE, "NODE_X_LOCATION", "Node X Location", true, CyNode.class);
    public static final VisualProperty<Double> NODE_Y_LOCATION = new DoubleVisualProperty(0.0, ARBITRARY_DOUBLE_RANGE, "NODE_Y_LOCATION", "Node Y Location", true, CyNode.class);
    public static final VisualProperty<Double> NODE_SIZE = new DoubleVisualProperty(50.0, NONE_ZERO_POSITIVE_DOUBLE_RANGE, "NODE_SIZE", "Node Size", CyNode.class);
    public static final VisualProperty<Double> NODE_WIDTH = new DoubleVisualProperty(60.0, NONE_ZERO_POSITIVE_DOUBLE_RANGE, "NODE_WIDTH", "Node Width", CyNode.class);
    public static final VisualProperty<Double> NODE_HEIGHT = new DoubleVisualProperty(40.0, NONE_ZERO_POSITIVE_DOUBLE_RANGE, "NODE_HEIGHT", "Node Height", CyNode.class);
    public static final VisualProperty<Boolean> NODE_VISIBLE = new BooleanVisualProperty(true, "NODE_VISIBLE", "Node Visible", CyNode.class);
    public static final VisualProperty<Boolean> NODE_SELECTED = new BooleanVisualProperty(false, "NODE_SELECTED", "Node Selected", true, CyNode.class);
    public static final VisualProperty<Boolean> NODE_NESTED_NETWORK_IMAGE_VISIBLE = new BooleanVisualProperty(true, "NODE_NESTED_NETWORK_IMAGE_VISIBLE", "Nested Network Image Visible", CyNode.class);
    public static final VisualProperty<Double> NODE_LABEL_WIDTH = new DoubleVisualProperty(200.0, NONE_ZERO_POSITIVE_DOUBLE_RANGE, "NODE_LABEL_WIDTH", "Node Label Width", CyNode.class);
    public static final VisualProperty<ObjectPosition> NODE_LABEL_POSITION = new ObjectPositionVisualProperty(ObjectPosition.DEFAULT_POSITION, "NODE_LABEL_POSITION", "Node Label Position", CyNode.class);
    public static final VisualProperty<Double> NODE_LABEL_ROTATION = new DoubleVisualProperty(0.0, ANGLE_DOUBLE_RANGE, "NODE_LABEL_ROTATION", "Node Label Rotation", CyNode.class);
    public static final VisualProperty<Paint> NODE_SELECTED_PAINT = new PaintVisualProperty(Color.YELLOW, PAINT_RANGE, "NODE_SELECTED_PAINT", "Node Selected Paint", (Class<? extends CyIdentifiable>)CyNode.class);
    public static final VisualProperty<Paint> NODE_BORDER_PAINT = new PaintVisualProperty(Color.BLACK, PAINT_RANGE, "NODE_BORDER_PAINT", "Node Border Paint", (Class<? extends CyIdentifiable>)CyNode.class);
    public static final VisualProperty<Double> NODE_BORDER_WIDTH = new DoubleVisualProperty(2.0, (Range<Double>)new ContinuousRange<Double>(Double.class, 0.0, Double.POSITIVE_INFINITY, true, true), "NODE_BORDER_WIDTH", "Node Border Width", (Class<? extends CyIdentifiable>)CyNode.class);
    public static final VisualProperty<String> NODE_TOOLTIP = new StringVisualProperty("", ARBITRARY_STRING_RANGE, "NODE_TOOLTIP", "Node Tooltip", CyNode.class);
    public static final VisualProperty<Font> NODE_LABEL_FONT_FACE = new FontVisualProperty(new Font("SansSerif", 0, 12), "NODE_LABEL_FONT_FACE", "Node Label Font Face", CyNode.class);
    public static final VisualProperty<Integer> NODE_LABEL_FONT_SIZE = new IntegerVisualProperty(12, (Range<Integer>)new ContinuousRange<Integer>(Integer.class, 1, Integer.MAX_VALUE, true, true), "NODE_LABEL_FONT_SIZE", "Node Label Font Size", (Class<? extends CyIdentifiable>)CyNode.class);
    public static final VisualProperty<Integer> NODE_TRANSPARENCY = new IntegerVisualProperty(255, (Range<Integer>)new ContinuousRange<Integer>(Integer.class, 0, 255, true, true), "NODE_TRANSPARENCY", "Node Transparency", (Class<? extends CyIdentifiable>)CyNode.class);
    public static final VisualProperty<Integer> NODE_OPACITY = NODE_TRANSPARENCY;
    public static final VisualProperty<Integer> NODE_BORDER_TRANSPARENCY = new IntegerVisualProperty(255, (Range<Integer>)new ContinuousRange<Integer>(Integer.class, 0, 255, true, true), "NODE_BORDER_TRANSPARENCY", "Node Border Transparency", (Class<? extends CyIdentifiable>)CyNode.class);
    public static final VisualProperty<Integer> NODE_LABEL_TRANSPARENCY = new IntegerVisualProperty(255, (Range<Integer>)new ContinuousRange<Integer>(Integer.class, 0, 255, true, true), "NODE_LABEL_TRANSPARENCY", "Node Label Transparency", (Class<? extends CyIdentifiable>)CyNode.class);
    public static final VisualProperty<NodeShape> NODE_SHAPE = new NodeShapeVisualProperty(NodeShapeVisualProperty.ELLIPSE, "NODE_SHAPE", "Node Shape", CyNode.class);
    public static final VisualProperty<LineType> NODE_BORDER_LINE_TYPE = new LineTypeVisualProperty(LineTypeVisualProperty.SOLID, "NODE_BORDER_STROKE", "Node Border Line Type", CyNode.class);
    public static final VisualProperty<Paint> EDGE_PAINT = new PaintVisualProperty(Color.gray, PAINT_RANGE, "EDGE_PAINT", "Edge Paint", (Class<? extends CyIdentifiable>)CyEdge.class);
    public static final VisualProperty<Paint> EDGE_LABEL_COLOR = new PaintVisualProperty(Color.BLACK, PAINT_RANGE, "EDGE_LABEL_COLOR", "Edge Label Color", (Class<? extends CyIdentifiable>)CyEdge.class);
    public static final VisualProperty<LabelBackgroundShape> EDGE_LABEL_BACKGROUND_SHAPE = new LabelBackgroundShapeVisualProperty(LabelBackgroundShapeVisualProperty.NONE, "EDGE_LABEL_BACKGROUND_SHAPE", "Edge Label Background Shape", CyEdge.class);
    public static final VisualProperty<Paint> EDGE_LABEL_BACKGROUND_COLOR = new PaintVisualProperty(Color.GRAY.brighter(), PAINT_RANGE, "EDGE_LABEL_BACKGROUND_COLOR", "Edge Label Background Color", (Class<? extends CyIdentifiable>)CyEdge.class);
    public static final VisualProperty<Integer> EDGE_LABEL_BACKGROUND_TRANSPARENCY = new IntegerVisualProperty(255, (Range<Integer>)new ContinuousRange<Integer>(Integer.class, 0, 255, true, true), "EDGE_LABEL_BACKGROUND_TRANSPARENCY", "Edge Label Background Transparency", (Class<? extends CyIdentifiable>)CyEdge.class);
    public static final VisualProperty<String> EDGE_LABEL = new StringVisualProperty("", ARBITRARY_STRING_RANGE, "EDGE_LABEL", "Edge Label", CyEdge.class);
    public static final VisualProperty<Double> EDGE_WIDTH = new DoubleVisualProperty(1.0, NONE_ZERO_POSITIVE_DOUBLE_RANGE, "EDGE_WIDTH", "Edge Width", CyEdge.class);
    public static final VisualProperty<Boolean> EDGE_VISIBLE = new BooleanVisualProperty(true, "EDGE_VISIBLE", "Edge Visible", CyEdge.class);
    public static final VisualProperty<Boolean> EDGE_SELECTED = new BooleanVisualProperty(false, "EDGE_SELECTED", "Edge Selected", true, CyEdge.class);
    public static final VisualProperty<LineType> EDGE_LINE_TYPE = new LineTypeVisualProperty(LineTypeVisualProperty.SOLID, "EDGE_LINE_TYPE", "Edge Line Type", CyEdge.class);
    public static final VisualProperty<String> EDGE_TOOLTIP = new StringVisualProperty("", ARBITRARY_STRING_RANGE, "EDGE_TOOLTIP", "Edge Tooltip", CyEdge.class);
    public static final VisualProperty<Font> EDGE_LABEL_FONT_FACE = new FontVisualProperty(new Font("SansSerif", 0, 10), "EDGE_LABEL_FONT_FACE", "Edge Label Font Face", CyEdge.class);
    public static final VisualProperty<Integer> EDGE_LABEL_FONT_SIZE = new IntegerVisualProperty(10, (Range<Integer>)new ContinuousRange<Integer>(Integer.class, 1, Integer.MAX_VALUE, true, true), "EDGE_LABEL_FONT_SIZE", "Edge Label Font Size", (Class<? extends CyIdentifiable>)CyEdge.class);
    public static final VisualProperty<Integer> EDGE_LABEL_TRANSPARENCY = new IntegerVisualProperty(255, (Range<Integer>)new ContinuousRange<Integer>(Integer.class, 0, 255, true, true), "EDGE_LABEL_TRANSPARENCY", "Edge Label Transparency", (Class<? extends CyIdentifiable>)CyEdge.class);
    public static final VisualProperty<ObjectPosition> EDGE_LABEL_POSITION = new ObjectPositionVisualProperty(ObjectPosition.DEFAULT_POSITION, "EDGE_LABEL_POSITION", "Edge Label Position", CyEdge.class);
    public static final VisualProperty<Paint> EDGE_SELECTED_PAINT = new PaintVisualProperty(Color.RED, PAINT_RANGE, "EDGE_SELECTED_PAINT", "Edge Color (Selected)", (Class<? extends CyIdentifiable>)CyEdge.class);
    public static final VisualProperty<Paint> EDGE_UNSELECTED_PAINT = new PaintVisualProperty(Color.DARK_GRAY, PAINT_RANGE, "EDGE_UNSELECTED_PAINT", "Edge Color (Unselected)", (Class<? extends CyIdentifiable>)CyEdge.class);
    public static final VisualProperty<Paint> EDGE_STROKE_SELECTED_PAINT = new PaintVisualProperty(Color.RED, PAINT_RANGE, "EDGE_STROKE_SELECTED_PAINT", "Edge Stroke Color (Selected)", (Class<? extends CyIdentifiable>)CyEdge.class);
    public static final VisualProperty<Paint> EDGE_STROKE_UNSELECTED_PAINT = new PaintVisualProperty(Color.DARK_GRAY, PAINT_RANGE, "EDGE_STROKE_UNSELECTED_PAINT", "Edge Stroke Color (Unselected)", (Class<? extends CyIdentifiable>)CyEdge.class);
    public static final VisualProperty<Integer> EDGE_TRANSPARENCY = new IntegerVisualProperty(255, (Range<Integer>)new ContinuousRange<Integer>(Integer.class, 0, 255, true, true), "EDGE_TRANSPARENCY", "Edge Transparency", (Class<? extends CyIdentifiable>)CyEdge.class);
    public static final VisualProperty<ArrowShape> EDGE_SOURCE_ARROW_SHAPE = new ArrowShapeVisualProperty(ArrowShapeVisualProperty.NONE, "EDGE_SOURCE_ARROW_SHAPE", "Edge Source Arrow Shape", CyEdge.class);
    public static final VisualProperty<ArrowShape> EDGE_TARGET_ARROW_SHAPE = new ArrowShapeVisualProperty(ArrowShapeVisualProperty.NONE, "EDGE_TARGET_ARROW_SHAPE", "Edge Target Arrow Shape", CyEdge.class);
    public static final VisualProperty<Double> EDGE_SOURCE_ARROW_SIZE = new DoubleVisualProperty(6.0, NONE_ZERO_POSITIVE_DOUBLE_RANGE, "EDGE_SOURCE_ARROW_SIZE", "Edge Source Arrow Size", CyEdge.class);
    public static final VisualProperty<Double> EDGE_TARGET_ARROW_SIZE = new DoubleVisualProperty(6.0, NONE_ZERO_POSITIVE_DOUBLE_RANGE, "EDGE_TARGET_ARROW_SIZE", "Edge Target Arrow Size", CyEdge.class);
    public static final VisualProperty<Paint> EDGE_SOURCE_ARROW_SELECTED_PAINT = new PaintVisualProperty(Color.YELLOW, PAINT_RANGE, "EDGE_SOURCE_ARROW_SELECTED_PAINT", "Edge Source Arrow Selected Paint", (Class<? extends CyIdentifiable>)CyEdge.class);
    public static final VisualProperty<Paint> EDGE_TARGET_ARROW_SELECTED_PAINT = new PaintVisualProperty(Color.YELLOW, PAINT_RANGE, "EDGE_TARGET_ARROW_SELECTED_PAINT", "Edge Target Arrow Selected Paint", (Class<? extends CyIdentifiable>)CyEdge.class);
    public static final VisualProperty<Paint> EDGE_SOURCE_ARROW_UNSELECTED_PAINT = new PaintVisualProperty(Color.BLACK, PAINT_RANGE, "EDGE_SOURCE_ARROW_UNSELECTED_PAINT", "Edge Source Arrow Unselected Paint", (Class<? extends CyIdentifiable>)CyEdge.class);
    public static final VisualProperty<Paint> EDGE_TARGET_ARROW_UNSELECTED_PAINT = new PaintVisualProperty(Color.BLACK, PAINT_RANGE, "EDGE_TARGET_ARROW_UNSELECTED_PAINT", "Edge Target Arrow Unselected Paint", (Class<? extends CyIdentifiable>)CyEdge.class);
    public static final VisualProperty<Double> EDGE_LABEL_ROTATION = new DoubleVisualProperty(0.0, ANGLE_DOUBLE_RANGE, "EDGE_LABEL_ROTATION", "Edge Label Rotation", CyEdge.class);
    public static final VisualProperty<Boolean> EDGE_LABEL_AUTOROTATE = new BooleanVisualProperty(false, "EDGE_LABEL_AUTOROTATE", "Edge Label Autorotate", CyEdge.class);
    public static final EdgeBendVisualProperty EDGE_BEND = new EdgeBendVisualProperty(EdgeBendVisualProperty.DEFAULT_EDGE_BEND, "EDGE_BEND", "Edge Bend");
    public static final VisualProperty<Double> EDGE_LABEL_WIDTH = new DoubleVisualProperty(200.0, NONE_ZERO_POSITIVE_DOUBLE_RANGE, "EDGE_LABEL_WIDTH", "Edge Label Width", CyEdge.class);
    public static final VisualProperty<EdgeStacking> EDGE_STACKING = new EdgeStackingVisualProperty(EdgeStackingVisualProperty.AUTO_BEND, "EDGE_STACKING", "Edge Stacking", CyEdge.class);
    public static final VisualProperty<Double> EDGE_STACKING_DENSITY = new DoubleVisualProperty(0.5, (Range<Double>)new ContinuousRange<Double>(Double.class, 0.0, 1.0, true, true), "EDGE_STACKING_DENSITY", "Stacking Density", (Class<? extends CyIdentifiable>)CyEdge.class);
    public static final VisualProperty<Double> EDGE_Z_ORDER = new DoubleVisualProperty(0.0, ARBITRARY_DOUBLE_RANGE, "EDGE_Z_ORDER", "Edge Z Order", true, CyEdge.class);
    public static final VisualProperty<Double> NETWORK_SCALE_FACTOR = new DoubleVisualProperty(1.0, NONE_ZERO_POSITIVE_DOUBLE_RANGE, "NETWORK_SCALE_FACTOR", "Network Scale Factor", true, CyNetwork.class);
    public static final VisualProperty<Double> NETWORK_CENTER_X_LOCATION = new DoubleVisualProperty(0.0, ARBITRARY_DOUBLE_RANGE, "NETWORK_CENTER_X_LOCATION", "Network Center X Location", true, CyNetwork.class);
    public static final VisualProperty<Double> NETWORK_CENTER_Y_LOCATION = new DoubleVisualProperty(0.0, ARBITRARY_DOUBLE_RANGE, "NETWORK_CENTER_Y_LOCATION", "Network Center Y Location", true, CyNetwork.class);
    public static final VisualProperty<Double> NETWORK_SIZE = new DoubleVisualProperty(550.0, NONE_ZERO_POSITIVE_DOUBLE_RANGE, "NETWORK_SIZE", "Network Size", true, CyNetwork.class);
    public static final VisualProperty<Double> NETWORK_WIDTH = new DoubleVisualProperty(550.0, NONE_ZERO_POSITIVE_DOUBLE_RANGE, "NETWORK_WIDTH", "Network Width", true, CyNetwork.class);
    public static final VisualProperty<Double> NETWORK_HEIGHT = new DoubleVisualProperty(400.0, NONE_ZERO_POSITIVE_DOUBLE_RANGE, "NETWORK_HEIGHT", "Network Height", true, CyNetwork.class);
    public static final VisualProperty<String> NETWORK_TITLE = new StringVisualProperty("", ARBITRARY_STRING_RANGE, "NETWORK_TITLE", "Network Title", true, CyNetwork.class);
    public static final VisualProperty<Paint> NETWORK_BACKGROUND_PAINT = new PaintVisualProperty(Color.WHITE, PAINT_RANGE, "NETWORK_BACKGROUND_PAINT", "Network Background Paint", (Class<? extends CyIdentifiable>)CyNetwork.class);
    public static final VisualProperty<Double> NODE_Z_LOCATION = new DoubleVisualProperty(0.0, ARBITRARY_DOUBLE_RANGE, "NODE_Z_LOCATION", "Node Z Location", true, CyNode.class);
    public static final VisualProperty<Double> NODE_DEPTH = new DoubleVisualProperty(0.0, NONE_ZERO_POSITIVE_DOUBLE_RANGE, "NODE_DEPTH", "Node Depth", CyNode.class);
    public static final VisualProperty<Double> NETWORK_CENTER_Z_LOCATION = new DoubleVisualProperty(0.0, ARBITRARY_DOUBLE_RANGE, "NETWORK_CENTER_Z_LOCATION", "Network Center Z Location", true, CyNetwork.class);
    public static final VisualProperty<Double> NETWORK_DEPTH = new DoubleVisualProperty(0.0, NONE_ZERO_POSITIVE_DOUBLE_RANGE, "NETWORK_DEPTH", "Network Depth", CyNetwork.class);

    public BasicVisualLexicon(VisualProperty<NullDataType> rootVisualProperty) {
        super(rootVisualProperty);
    }

    @Override
    protected Class<?>[] getTypes() {
        return new Class[]{CyNetwork.class, CyNode.class, CyEdge.class};
    }

    public final void addBendFactory(BendFactory bendFactory, Map<?, ?> props) {
        EDGE_BEND.setBendFactory(bendFactory);
    }

    @Override
    protected void addVisualProperties(VisualProperty<NullDataType> root) {
        this.addVisualProperty(NETWORK, root);
        this.addVisualProperty(NODE, NETWORK);
        this.addVisualProperty(EDGE, NETWORK);
        this.addVisualProperty(NETWORK_SIZE, NETWORK);
        this.addVisualProperty(NETWORK_SCALE_FACTOR, NETWORK);
        this.addVisualProperty(NETWORK_TITLE, NETWORK);
        this.addVisualProperty(NETWORK_BACKGROUND_PAINT, NETWORK);
        this.addVisualProperty(NETWORK_CENTER_X_LOCATION, NETWORK);
        this.addVisualProperty(NETWORK_CENTER_Y_LOCATION, NETWORK);
        this.addVisualProperty(NETWORK_CENTER_Z_LOCATION, NETWORK);
        this.addVisualProperty(NETWORK_WIDTH, NETWORK_SIZE);
        this.addVisualProperty(NETWORK_HEIGHT, NETWORK_SIZE);
        this.addVisualProperty(NETWORK_DEPTH, NETWORK_SIZE);
        this.addVisualProperty(NODE_PAINT, NODE);
        this.addVisualProperty(NODE_SIZE, NODE);
        this.addVisualProperty(NODE_SHAPE, NODE);
        this.addVisualProperty(NODE_VISIBLE, NODE);
        this.addVisualProperty(NODE_SELECTED, NODE);
        this.addVisualProperty(NODE_NESTED_NETWORK_IMAGE_VISIBLE, NODE);
        this.addVisualProperty(NODE_X_LOCATION, NODE);
        this.addVisualProperty(NODE_Y_LOCATION, NODE);
        this.addVisualProperty(NODE_Z_LOCATION, NODE);
        this.addVisualProperty(NODE_LABEL, NODE);
        this.addVisualProperty(NODE_BORDER_WIDTH, NODE);
        this.addVisualProperty(NODE_BORDER_LINE_TYPE, NODE);
        this.addVisualProperty(NODE_TRANSPARENCY, NODE);
        this.addVisualProperty(NODE_BORDER_TRANSPARENCY, NODE);
        this.addVisualProperty(NODE_LABEL_FONT_FACE, NODE);
        this.addVisualProperty(NODE_LABEL_TRANSPARENCY, NODE);
        this.addVisualProperty(NODE_TOOLTIP, NODE);
        this.addVisualProperty(NODE_LABEL_WIDTH, NODE);
        this.addVisualProperty(NODE_LABEL_POSITION, NODE);
        this.addVisualProperty(NODE_LABEL_ROTATION, NODE);
        this.addVisualProperty(NODE_LABEL_BACKGROUND_SHAPE, NODE);
        this.addVisualProperty(NODE_LABEL_BACKGROUND_COLOR, NODE);
        this.addVisualProperty(NODE_LABEL_BACKGROUND_TRANSPARENCY, NODE);
        this.addVisualProperty(EDGE_PAINT, EDGE);
        this.addVisualProperty(EDGE_VISIBLE, EDGE);
        this.addVisualProperty(EDGE_SELECTED, EDGE);
        this.addVisualProperty(EDGE_WIDTH, EDGE);
        this.addVisualProperty(EDGE_LABEL, EDGE);
        this.addVisualProperty(EDGE_LINE_TYPE, EDGE);
        this.addVisualProperty(EDGE_TOOLTIP, EDGE);
        this.addVisualProperty(EDGE_LABEL_FONT_FACE, EDGE);
        this.addVisualProperty(EDGE_LABEL_FONT_SIZE, EDGE);
        this.addVisualProperty(EDGE_LABEL_TRANSPARENCY, EDGE);
        this.addVisualProperty(EDGE_LABEL_POSITION, EDGE);
        this.addVisualProperty(EDGE_TRANSPARENCY, EDGE);
        this.addVisualProperty(EDGE_SOURCE_ARROW_SHAPE, EDGE);
        this.addVisualProperty(EDGE_TARGET_ARROW_SHAPE, EDGE);
        this.addVisualProperty(EDGE_SOURCE_ARROW_SIZE, EDGE);
        this.addVisualProperty(EDGE_TARGET_ARROW_SIZE, EDGE);
        this.addVisualProperty(EDGE_BEND, EDGE);
        this.addVisualProperty(EDGE_LABEL_WIDTH, EDGE);
        this.addVisualProperty(EDGE_STACKING, EDGE);
        this.addVisualProperty(EDGE_STACKING_DENSITY, EDGE);
        this.addVisualProperty(EDGE_Z_ORDER, EDGE);
        this.addVisualProperty(EDGE_LABEL_ROTATION, EDGE);
        this.addVisualProperty(EDGE_LABEL_AUTOROTATE, EDGE);
        this.addVisualProperty(EDGE_LABEL_BACKGROUND_SHAPE, EDGE);
        this.addVisualProperty(EDGE_LABEL_BACKGROUND_COLOR, EDGE);
        this.addVisualProperty(EDGE_LABEL_BACKGROUND_TRANSPARENCY, EDGE);
        this.addVisualProperty(NODE_FILL_COLOR, NODE_PAINT);
        this.addVisualProperty(NODE_SELECTED_PAINT, NODE_PAINT);
        this.addVisualProperty(NODE_BORDER_PAINT, NODE_PAINT);
        this.addVisualProperty(NODE_LABEL_COLOR, NODE_PAINT);
        this.addVisualProperty(NODE_LABEL_FONT_SIZE, NODE);
        this.addVisualProperty(NODE_WIDTH, NODE_SIZE);
        this.addVisualProperty(NODE_HEIGHT, NODE_SIZE);
        this.addVisualProperty(NODE_DEPTH, NODE_SIZE);
        this.addVisualProperty(EDGE_LABEL_COLOR, EDGE_PAINT);
        this.addVisualProperty(EDGE_SELECTED_PAINT, EDGE_PAINT);
        this.addVisualProperty(EDGE_UNSELECTED_PAINT, EDGE_PAINT);
        this.addVisualProperty(EDGE_STROKE_SELECTED_PAINT, EDGE_SELECTED_PAINT);
        this.addVisualProperty(EDGE_STROKE_UNSELECTED_PAINT, EDGE_UNSELECTED_PAINT);
        this.addVisualProperty(EDGE_SOURCE_ARROW_SELECTED_PAINT, EDGE_SELECTED_PAINT);
        this.addVisualProperty(EDGE_TARGET_ARROW_SELECTED_PAINT, EDGE_SELECTED_PAINT);
        this.addVisualProperty(EDGE_SOURCE_ARROW_UNSELECTED_PAINT, EDGE_UNSELECTED_PAINT);
        this.addVisualProperty(EDGE_TARGET_ARROW_UNSELECTED_PAINT, EDGE_UNSELECTED_PAINT);
        this.createLookupMap();
    }

    private void createLookupMap() {
        this.addIdentifierMapping(CyNetwork.class, "color", NETWORK_BACKGROUND_PAINT);
        this.addIdentifierMapping(CyNetwork.class, "GRAPH_VIEW_CENTER_X", NETWORK_CENTER_X_LOCATION);
        this.addIdentifierMapping(CyNetwork.class, "GRAPH_VIEW_CENTER_Y", NETWORK_CENTER_Y_LOCATION);
        this.addIdentifierMapping(CyNetwork.class, "GRAPH_VIEW_ZOOM", NETWORK_SCALE_FACTOR);
        this.addIdentifierMapping(CyNetwork.class, "label", NETWORK_TITLE);
        this.addIdentifierMapping(CyNode.class, "fill", NODE_FILL_COLOR);
        this.addIdentifierMapping(CyNode.class, "x", NODE_X_LOCATION);
        this.addIdentifierMapping(CyNode.class, "y", NODE_Y_LOCATION);
        this.addIdentifierMapping(CyNode.class, "z", NODE_Z_LOCATION);
        this.addIdentifierMapping(CyNode.class, "w", NODE_WIDTH);
        this.addIdentifierMapping(CyNode.class, "h", NODE_HEIGHT);
        this.addIdentifierMapping(CyNode.class, "size", NODE_SIZE);
        this.addIdentifierMapping(CyNode.class, "type", NODE_SHAPE);
        this.addIdentifierMapping(CyNode.class, "outline", NODE_BORDER_PAINT);
        this.addIdentifierMapping(CyNode.class, "width", NODE_BORDER_WIDTH);
        this.addIdentifierMapping(CyNode.class, "borderLineType", NODE_BORDER_LINE_TYPE);
        this.addIdentifierMapping(CyNode.class, "nodeLabelFont", NODE_LABEL_FONT_FACE);
        this.addIdentifierMapping(CyNode.class, "nodeTransparency", NODE_TRANSPARENCY);
        this.addIdentifierMapping(CyNode.class, "nodeLabelTransparency", NODE_LABEL_TRANSPARENCY);
        this.addIdentifierMapping(CyNode.class, "nodeBorderTransparency", NODE_BORDER_TRANSPARENCY);
        this.addIdentifierMapping(CyNode.class, "nodeLabelPosition", NODE_LABEL_POSITION);
        this.addIdentifierMapping(CyNode.class, "nodeLabelRotation", NODE_LABEL_ROTATION);
        this.addIdentifierMapping(CyEdge.class, "width", EDGE_WIDTH);
        this.addIdentifierMapping(CyEdge.class, "fill", EDGE_STROKE_UNSELECTED_PAINT);
        this.addIdentifierMapping(CyEdge.class, "edgeLineType", EDGE_LINE_TYPE);
        this.addIdentifierMapping(CyEdge.class, "edgeLabelFont", EDGE_LABEL_FONT_FACE);
        this.addIdentifierMapping(CyEdge.class, "sourceArrowColor", EDGE_SOURCE_ARROW_UNSELECTED_PAINT);
        this.addIdentifierMapping(CyEdge.class, "targetArrowColor", EDGE_TARGET_ARROW_UNSELECTED_PAINT);
        this.addIdentifierMapping(CyEdge.class, "edgeSourceArrowColor", EDGE_SOURCE_ARROW_UNSELECTED_PAINT);
        this.addIdentifierMapping(CyEdge.class, "edgeTargetArrowColor", EDGE_TARGET_ARROW_UNSELECTED_PAINT);
        this.addIdentifierMapping(CyEdge.class, "edgeLabelRotation", EDGE_LABEL_ROTATION);
        this.addIdentifierMapping(CyEdge.class, "edgeLabelAutorotate", EDGE_LABEL_AUTOROTATE);
        this.addIdentifierMapping(CyNetwork.class, "backgroundColor", NETWORK_BACKGROUND_PAINT);
        this.addIdentifierMapping(CyNode.class, "nodeFillColor", NODE_FILL_COLOR);
        this.addIdentifierMapping(CyNode.class, "nodeSelectionColor", NODE_SELECTED_PAINT);
        this.addIdentifierMapping(CyNode.class, "nodeSize", NODE_SIZE);
        this.addIdentifierMapping(CyNode.class, "nodeWidth", NODE_WIDTH);
        this.addIdentifierMapping(CyNode.class, "nodeHight", NODE_HEIGHT);
        this.addIdentifierMapping(CyNode.class, "nodeHeight", NODE_HEIGHT);
        this.addIdentifierMapping(CyNode.class, "nodeOpacity", NODE_TRANSPARENCY);
        this.addIdentifierMapping(CyNode.class, "nodeBorderColor", NODE_BORDER_PAINT);
        this.addIdentifierMapping(CyNode.class, "nodeLineWidth", NODE_BORDER_WIDTH);
        this.addIdentifierMapping(CyNode.class, "nodeLineStyle", NODE_BORDER_LINE_TYPE);
        this.addIdentifierMapping(CyNode.class, "nodeBorderOpacity", NODE_BORDER_TRANSPARENCY);
        this.addIdentifierMapping(CyNode.class, "nodeShape", NODE_SHAPE);
        this.addIdentifierMapping(CyNode.class, "nodeFont", NODE_LABEL_FONT_FACE);
        this.addIdentifierMapping(CyNode.class, "nodeFontSize", NODE_LABEL_FONT_SIZE);
        this.addIdentifierMapping(CyNode.class, "nodeShowNestedNetwork", NODE_NESTED_NETWORK_IMAGE_VISIBLE);
        this.addIdentifierMapping(CyNode.class, "nodeLabel", NODE_LABEL);
        this.addIdentifierMapping(CyNode.class, "nodeLabelColor", NODE_LABEL_COLOR);
        this.addIdentifierMapping(CyNode.class, "nodeLabelBackgroundShape", NODE_LABEL_BACKGROUND_SHAPE);
        this.addIdentifierMapping(CyNode.class, "nodeLabelBackgroundColor", NODE_LABEL_BACKGROUND_COLOR);
        this.addIdentifierMapping(CyNode.class, "nodeLabelBackgroundTransparency", NODE_LABEL_BACKGROUND_TRANSPARENCY);
        this.addIdentifierMapping(CyNode.class, "nodeLabelWidth", NODE_LABEL_WIDTH);
        this.addIdentifierMapping(CyNode.class, "nodeLabelOpacity", NODE_LABEL_TRANSPARENCY);
        this.addIdentifierMapping(CyNode.class, "nodeToolTip", NODE_TOOLTIP);
        this.addIdentifierMapping(CyEdge.class, "edgeLineWidth", EDGE_WIDTH);
        this.addIdentifierMapping(CyEdge.class, "edgeColor", EDGE_STROKE_UNSELECTED_PAINT);
        this.addIdentifierMapping(CyEdge.class, "edgeSelectionColor", EDGE_STROKE_SELECTED_PAINT);
        this.addIdentifierMapping(CyEdge.class, "edgeLineStyle", EDGE_LINE_TYPE);
        this.addIdentifierMapping(CyEdge.class, "edgeOpacity", EDGE_TRANSPARENCY);
        this.addIdentifierMapping(CyEdge.class, "sourceArrow", EDGE_SOURCE_ARROW_SHAPE);
        this.addIdentifierMapping(CyEdge.class, "targetArrow", EDGE_TARGET_ARROW_SHAPE);
        this.addIdentifierMapping(CyEdge.class, "edgeSourceArrowShape", EDGE_SOURCE_ARROW_SHAPE);
        this.addIdentifierMapping(CyEdge.class, "edgeTargetArrowShape", EDGE_TARGET_ARROW_SHAPE);
        this.addIdentifierMapping(CyEdge.class, "edgeBend", EDGE_BEND);
        this.addIdentifierMapping(CyEdge.class, "edgeLabel", EDGE_LABEL);
        this.addIdentifierMapping(CyEdge.class, "edgeFont", EDGE_LABEL_FONT_FACE);
        this.addIdentifierMapping(CyEdge.class, "edgeLabelColor", EDGE_LABEL_COLOR);
        this.addIdentifierMapping(CyNode.class, "edgeLabelBackgroundShape", EDGE_LABEL_BACKGROUND_SHAPE);
        this.addIdentifierMapping(CyNode.class, "edgeLabelBackgroundColor", EDGE_LABEL_BACKGROUND_COLOR);
        this.addIdentifierMapping(CyNode.class, "edgeLabelBackgroundTransparency", EDGE_LABEL_BACKGROUND_TRANSPARENCY);
        this.addIdentifierMapping(CyEdge.class, "edgeLabelOpacity", EDGE_LABEL_TRANSPARENCY);
        this.addIdentifierMapping(CyEdge.class, "edgeFontSize", EDGE_LABEL_FONT_SIZE);
        this.addIdentifierMapping(CyEdge.class, "edgeLabelWidth", EDGE_LABEL_WIDTH);
        this.addIdentifierMapping(CyEdge.class, "edgeLabelPosition", EDGE_LABEL_POSITION);
        this.addIdentifierMapping(CyEdge.class, "edgeToolTip", EDGE_TOOLTIP);
        this.addIdentifierMapping(CyEdge.class, "edgeHandleList", EDGE_BEND);
    }
}

