/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model.events;

import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;

public final class ViewChangeRecord<T> {
    private final View<T> view;
    private final VisualProperty<?> vp;
    private final Object value;
    private final boolean lockedValue;

    public ViewChangeRecord(View<T> view, VisualProperty<?> vp, Object value) {
        this(view, vp, value, false);
    }

    public ViewChangeRecord(View<T> view, VisualProperty<?> vp, Object value, boolean lockedValue) {
        if (view == null || vp == null) {
            throw new NullPointerException("View and/or VisualProperty may not be null");
        }
        this.view = view;
        this.vp = vp;
        this.value = value;
        this.lockedValue = lockedValue;
    }

    public View<T> getView() {
        return this.view;
    }

    public VisualProperty<?> getVisualProperty() {
        return this.vp;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isLockedValue() {
        return this.lockedValue;
    }
}

