/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import org.cytoscape.view.model.VisualProperty;

public final class VisualLexiconNode
implements Comparable<VisualLexiconNode> {
    private final VisualProperty<?> vp;
    private final VisualLexiconNode parent;
    private final Collection<VisualLexiconNode> children;

    public VisualLexiconNode(VisualProperty<?> vp, VisualLexiconNode parent) {
        if (vp == null) {
            throw new NullPointerException("Visual Property cannot be null.");
        }
        this.vp = vp;
        this.parent = parent;
        this.children = new LinkedHashSet<VisualLexiconNode>();
        if (parent != null) {
            parent.getChildren().add(this);
        }
    }

    public VisualProperty<?> getVisualProperty() {
        return this.vp;
    }

    public VisualLexiconNode getParent() {
        return this.parent;
    }

    public Collection<VisualLexiconNode> getChildren() {
        return this.children;
    }

    @Override
    public int compareTo(VisualLexiconNode other) {
        String n1 = this.getVisualProperty().getDisplayName();
        String n2 = other.getVisualProperty().getDisplayName();
        return n1.compareTo(n2);
    }

    public void visitDescendants(Consumer<VisualLexiconNode> visitor) {
        visitor.accept(this);
        for (VisualLexiconNode child : this.getChildren()) {
            child.visitDescendants(visitor);
        }
    }
}

