/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model;

import org.cytoscape.view.model.Range;

public class ContinuousRange<T>
implements Range<T> {
    private final Class<T> type;
    private final T min;
    private final T max;
    private final Boolean includeMin;
    private final Boolean includeMax;

    public ContinuousRange(Class<T> type, T min, T max, Boolean includeMin, Boolean includeMax) {
        this.type = type;
        this.min = min;
        this.max = max;
        this.includeMin = includeMin;
        this.includeMax = includeMax;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public boolean isDiscrete() {
        return false;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public boolean includeMin() {
        return this.includeMin;
    }

    public boolean includeMax() {
        return this.includeMax;
    }

    @Override
    public boolean inRange(T value) {
        if (value instanceof Number && this.min instanceof Number && this.max instanceof Number) {
            return this.validateNumber((Number)value, (Number)this.min, (Number)this.max);
        }
        return true;
    }

    private boolean validateNumber(Number value, Number minNumber, Number maxNumber) {
        double testValue = value.doubleValue();
        double doubleMin = minNumber.doubleValue();
        double doubleMax = maxNumber.doubleValue();
        if (this.includeMax.booleanValue() && this.includeMin.booleanValue()) {
            return doubleMin <= testValue && doubleMax >= testValue;
        }
        if (!this.includeMax.booleanValue() && !this.includeMin.booleanValue()) {
            return doubleMin < testValue && doubleMax > testValue;
        }
        if (!this.includeMax.booleanValue() && this.includeMin.booleanValue()) {
            return doubleMin <= testValue && doubleMax > testValue;
        }
        return doubleMin < testValue && doubleMax >= testValue;
    }
}

