/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.view.layout.EdgeWeighter;
import org.cytoscape.view.layout.LayoutPartition;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;

public final class PartitionUtil {
    private static final int m_NODE_HAS_NOT_BEEN_SEEN = 0;
    private static final int m_NODE_HAS_BEEN_SEEN = 1;

    private PartitionUtil() {
    }

    public static List<LayoutPartition> partition(CyNetworkView networkView, boolean selectedOnly, EdgeWeighter edgeWeighter) {
        if (selectedOnly) {
            return PartitionUtil.partition(networkView, CyTableUtil.getNodesInState((CyNetwork)networkView.getModel(), "selected", true), edgeWeighter);
        }
        return PartitionUtil.partition(networkView, ((CyNetwork)networkView.getModel()).getNodeList(), edgeWeighter);
    }

    public static List<LayoutPartition> partition(CyNetworkView networkView, Collection<CyNode> nodeSet, EdgeWeighter edgeWeighter) {
        ArrayList<LayoutPartition> partitions = new ArrayList<LayoutPartition>();
        CyNetwork network = (CyNetwork)networkView.getModel();
        HashMap<CyNode, Integer> nodesSeenMap = new HashMap<CyNode, Integer>();
        HashMap<CyEdge, Integer> edgesSeenMap = new HashMap<CyEdge, Integer>();
        HashMap<CyNode, View<CyNode>> nodesToViews = new HashMap<CyNode, View<CyNode>>();
        int partitionNumber = 1;
        for (View<CyNode> nv : networkView.getNodeViews()) {
            nodesSeenMap.put(nv.getModel(), 0);
            nodesToViews.put(nv.getModel(), nv);
        }
        for (CyEdge edge : network.getEdgeList()) {
            edgesSeenMap.put(edge, 0);
        }
        for (CyNode node : nodeSet) {
            if ((Integer)nodesSeenMap.get(node) == 1) continue;
            LayoutPartition part = new LayoutPartition(network.getNodeCount(), network.getEdgeCount());
            part.setPartitionNumber(partitionNumber++);
            part.setEdgeWeighter(edgeWeighter);
            nodesSeenMap.put(node, 1);
            PartitionUtil.traverse(network, networkView, nodesToViews, node, part, nodesSeenMap, edgesSeenMap);
            part.trimToSize();
            part.fixEdges();
            partitions.add(part);
        }
        Collections.sort(partitions, new Comparator<LayoutPartition>(){

            @Override
            public int compare(LayoutPartition p1, LayoutPartition p2) {
                return p2.size() - p1.size();
            }

            public boolean equals(LayoutPartition obj) {
                return false;
            }
        });
        return partitions;
    }

    private static void traverse(CyNetwork network, CyNetworkView networkView, Map<CyNode, View<CyNode>> nodesToViews, CyNode startNode, LayoutPartition partition, Map<CyNode, Integer> nodesSeenMap, Map<CyEdge, Integer> edgesSeenMap) {
        LinkedList<CyNode> nodeStack = new LinkedList<CyNode>();
        nodeStack.add(startNode);
        while (!nodeStack.isEmpty()) {
            CyNode currentNode = (CyNode)nodeStack.pop();
            View<CyNode> nv = nodesToViews.get(currentNode);
            partition.addNode(network, nv, false);
            List<CyEdge> edgeList = network.getAdjacentEdgeList(currentNode, CyEdge.Type.ANY);
            LinkedList<CyNode> connectedNodes = new LinkedList<CyNode>();
            for (CyEdge incidentEdge : edgeList) {
                if (edgesSeenMap.get(incidentEdge) == 1) continue;
                edgesSeenMap.put(incidentEdge, 1);
                partition.addEdge(incidentEdge, network.getRow(incidentEdge));
                CyNode otherNode = incidentEdge.getSource() == currentNode ? incidentEdge.getTarget() : incidentEdge.getSource();
                if (nodesSeenMap.get(otherNode) != 0) continue;
                nodesSeenMap.put(otherNode, 1);
                connectedNodes.add(0, otherNode);
            }
            connectedNodes.forEach(nodeStack::push);
        }
    }
}

