/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.UIManager;

public class TextIcon
implements Icon {
    private final Color TRANSPARENT_COLOR = new Color(255, 255, 255, 0);
    private final String[] texts;
    private final Font[] fonts;
    private final Color[] colors;
    private final int width;
    private final int height;
    private Set<Integer> disabledLayers = new HashSet<Integer>();

    public TextIcon(String text, Font font, Color color, int width, int height) {
        this.texts = new String[]{text};
        this.fonts = new Font[]{font};
        this.colors = new Color[]{color};
        this.width = width;
        this.height = height;
    }

    public TextIcon(String text, Font font, int width, int height) {
        this(text, font, null, width, height);
    }

    public TextIcon(String[] texts, Font font, Color[] colors, int width, int height) {
        this(texts, new Font[]{font}, colors, width, height);
    }

    public TextIcon(String[] texts, Font font, int width, int height) {
        this(texts, new Font[]{font}, null, width, height);
    }

    public TextIcon(String[] texts, Font font, Color[] colors, int width, int height, Integer ... disabledLayers) {
        this(texts, new Font[]{font}, colors, width, height, disabledLayers);
    }

    public TextIcon(String[] texts, Font[] fonts, Color[] colors, int width, int height) {
        this(texts, fonts, colors, width, height, (Integer[])null);
    }

    public TextIcon(String[] texts, Font[] fonts, int width, int height) {
        this(texts, fonts, null, width, height, (Integer[])null);
    }

    public TextIcon(String[] texts, Font[] fonts, Color[] colors, int width, int height, Integer ... disabledLayers) {
        this.texts = texts;
        this.fonts = fonts;
        this.colors = colors;
        this.width = width;
        this.height = height;
        if (disabledLayers != null) {
            this.disabledLayers.addAll(Arrays.asList(disabledLayers));
        }
    }

    public TextIcon(TextIcon icon, int width, int height) {
        this((String[])icon.texts.clone(), TextIcon.scaleFonts(icon.fonts, icon.width, width, icon.height, height), icon.colors != null ? (Color[])icon.colors.clone() : null, width, height);
        if (icon.disabledLayers != null) {
            this.disabledLayers.addAll(icon.disabledLayers);
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int scale = 2;
        BufferedImage img = this.createImage(c, scale);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHints(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR));
        g2d.scale(1.0 / (double)scale, 1.0 / (double)scale);
        g2d.translate(x, y);
        g2d.drawImage((Image)img, x, y, c);
        g2d.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    private BufferedImage createImage(Component c, int scale) {
        int w = this.width * scale;
        int h = this.height * scale;
        BufferedImage img = new BufferedImage(w, h * scale, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        g2d.setPaint(this.TRANSPARENT_COLOR);
        g2d.fillRect(0, 0, w, h);
        if (this.texts != null && this.fonts != null) {
            Font f = null;
            Color fg = null;
            for (int i = 0; i < this.texts.length; ++i) {
                if (c != null && !c.isEnabled() && this.disabledLayers.contains(i)) continue;
                String txt = this.texts[i];
                if (this.fonts.length > i) {
                    f = this.fonts[i];
                } else if (this.fonts.length > 0) {
                    f = this.fonts[0];
                }
                if (txt == null || f == null) continue;
                f = f.deriveFont(f.getSize2D() * (float)scale);
                if (this.colors != null && this.colors.length > i) {
                    fg = this.colors[i];
                }
                if (fg == null) {
                    Color color = fg = c != null ? c.getForeground() : UIManager.getColor("Label.foreground");
                }
                if (c instanceof AbstractButton) {
                    if (!c.isEnabled()) {
                        fg = UIManager.getColor("Label.disabledForeground");
                    } else if (((AbstractButton)c).getModel().isPressed()) {
                        fg = fg.darker();
                    }
                }
                g2d.setPaint(fg);
                g2d.setFont(f);
                this.drawText(txt, f, g2d, 0, 0, scale);
            }
        }
        return img;
    }

    private void drawText(String text, Font font, Graphics g, int x, int y, int scale) {
        FontMetrics fm = g.getFontMetrics(font);
        Rectangle2D rect = fm.getStringBounds(text, g);
        LineMetrics lm = fm.getLineMetrics(text, g);
        int textHeight = (int)lm.getHeight();
        int textWidth = (int)rect.getWidth();
        int w = this.width * scale;
        int h = this.height * scale;
        int xx = x + Math.round((float)(w - textWidth) / 2.0f);
        int yy = y + Math.round((float)(h - textHeight) / 2.0f + lm.getAscent());
        g.drawString(text, xx, yy);
    }

    private static Font[] scaleFonts(Font[] fonts, float width1, float width2, float height1, float height2) {
        Font[] newFonts = new Font[fonts.length];
        float s1 = width2 / width1;
        float s2 = height2 / height1;
        float s = Math.min(s1, s2);
        for (int i = 0; i < fonts.length; ++i) {
            Font nf;
            Font f = fonts[i];
            newFonts[i] = nf = f.deriveFont((float)f.getSize() * s);
        }
        return newFonts;
    }
}

