/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.cytoscape.util.swing.GravityTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PopupMenuGravityTracker
implements GravityTracker {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final JPopupMenu menu;
    private final Map<Component, Double> componentGravity;

    public PopupMenuGravityTracker(JPopupMenu menu) {
        this.menu = menu;
        this.componentGravity = new HashMap<Component, Double>();
    }

    @Override
    public JPopupMenu getMenu() {
        return this.menu;
    }

    @Override
    public void addMenuItem(JMenuItem newMenuItem, double gravity) {
        int index = this.getInsertLocation(newMenuItem.getText(), gravity);
        this.menu.insert(newMenuItem, index);
        this.componentGravity.put(newMenuItem, gravity);
        logger.debug("Inserted menu item: " + newMenuItem + " with gravity: " + gravity);
    }

    @Override
    public void addMenu(JMenu newSubmenu, double gravity) {
        int index = this.getInsertLocation(newSubmenu.getText(), gravity);
        this.menu.insert(newSubmenu, index);
        this.componentGravity.put(newSubmenu, gravity);
        logger.debug("Inserted menu: " + newSubmenu + " with gravity: " + gravity);
    }

    @Override
    public void addMenuSeparator(double gravity) {
        int index = this.getInsertLocation("-", gravity);
        this.menu.insert(new JSeparator(), index);
        Component separator = this.menu.getComponent(index);
        this.componentGravity.put(separator, gravity);
        logger.debug("Inserted menu separator with gravity: " + gravity);
    }

    @Override
    public void removeComponent(Component component) {
        if (this.componentGravity.remove(component) != null) {
            this.menu.remove(this.menu.getComponentIndex(component));
        }
    }

    private int getInsertLocation(String text, double gravity) {
        int count = this.menu.getComponentCount();
        if (gravity == -1.0) {
            for (int i = 0; i < count; ++i) {
                JMenuItem menuItem;
                JMenu subMenu;
                Component item = this.menu.getComponent(i);
                Double itemGrav = this.componentGravity.getOrDefault(item, -1.0);
                if (itemGrav != -1.0 || !(item instanceof JMenu ? text.compareToIgnoreCase((subMenu = (JMenu)item).getText()) < 0 : item instanceof JMenuItem && text.compareToIgnoreCase((menuItem = (JMenuItem)item).getText()) < 0)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < count; ++i) {
                Component item = this.menu.getComponent(i);
                Double itemGrav = this.componentGravity.getOrDefault(item, -1.0);
                if (itemGrav == -1.0) {
                    return i;
                }
                if (itemGrav == null || !(gravity < itemGrav)) continue;
                return i;
            }
        }
        return count;
    }
}

