/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing;

import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.cytoscape.util.swing.GravityTracker;
import org.cytoscape.util.swing.MenuGravityTracker;
import org.cytoscape.util.swing.PopupMenuGravityTracker;

public final class JMenuTracker {
    private final Map<String, MenuGravityTracker> menuMap;
    private final JMenuBar rootMenuBar;
    private final PopupMenuGravityTracker rootPopupGravityTracker;

    public JMenuTracker(JPopupMenu rootPopupMenu) {
        if (rootPopupMenu == null) {
            throw new NullPointerException("root popupmenu for menus is null.");
        }
        this.rootPopupGravityTracker = new PopupMenuGravityTracker(rootPopupMenu);
        this.rootMenuBar = null;
        this.menuMap = new HashMap<String, MenuGravityTracker>();
    }

    public JMenuTracker(JMenuBar rootMenuBar) {
        if (rootMenuBar == null) {
            throw new NullPointerException("root menubar for menus is null.");
        }
        this.rootPopupGravityTracker = null;
        this.rootMenuBar = rootMenuBar;
        this.menuMap = new HashMap<String, MenuGravityTracker>();
    }

    public GravityTracker getGravityTracker(String menuString) {
        if (menuString == null) {
            throw new NullPointerException("menu string is null");
        }
        if (menuString.isEmpty()) {
            throw new IllegalArgumentException("menu string has zero length");
        }
        if (menuString.equals(".") && this.rootPopupGravityTracker != null) {
            return this.rootPopupGravityTracker;
        }
        List<MenuNameAndGravity> namesAndGravities = JMenuTracker.parseMenuString(menuString);
        MenuGravityTracker parentGravityTracker = null;
        MenuGravityTracker gravityTracker = null;
        String menu_key = null;
        for (MenuNameAndGravity nameAndGravity : namesAndGravities) {
            String menu_token = nameAndGravity.getMenuName();
            gravityTracker = this.menuMap.get(menu_key = menu_key == null ? menu_token : menu_key + "." + menu_token);
            if (gravityTracker == null) {
                final JMenu menu = new JMenu(menu_token);
                menu.addMenuListener(new MenuListener(){

                    @Override
                    public void menuSelected(MenuEvent e) {
                        int itemCount = menu.getItemCount();
                        for (int i = 0; i < itemCount; ++i) {
                            JMenuItem item = menu.getItem(i);
                            if (item == null || item.getAction() == null) continue;
                            item.setEnabled(item.getAction().isEnabled());
                        }
                    }

                    @Override
                    public void menuDeselected(MenuEvent e) {
                    }

                    @Override
                    public void menuCanceled(MenuEvent e) {
                    }
                });
                if (parentGravityTracker != null) {
                    parentGravityTracker.addMenu(menu, nameAndGravity.getGravity());
                } else if (this.rootMenuBar != null && this.rootPopupGravityTracker == null) {
                    this.rootMenuBar.add(menu);
                } else if (this.rootMenuBar == null && this.rootPopupGravityTracker != null) {
                    this.rootPopupGravityTracker.addMenu(menu, nameAndGravity.getGravity());
                } else {
                    throw new IllegalStateException("we have no root popup menu or menu bar.");
                }
                gravityTracker = new MenuGravityTracker(menu);
                this.menuMap.put(menu_key, gravityTracker);
            }
            parentGravityTracker = gravityTracker;
        }
        return gravityTracker;
    }

    public void removeGravityTracker(String menuName) {
        JMenu menu;
        Container parent;
        MenuGravityTracker tracker = this.menuMap.remove(menuName);
        if (tracker != null && (parent = (menu = tracker.getMenu()).getParent()) != null) {
            parent.remove(menu);
        }
    }

    static List<MenuNameAndGravity> parseMenuString(String menuString) {
        ArrayList<MenuNameAndGravity> namesAndGravities = new ArrayList<MenuNameAndGravity>();
        ParseState state = ParseState.LOOKING_FOR_OPENING_BRACKET;
        StringBuilder menuName = new StringBuilder();
        StringBuilder gravityAsString = null;
        block7: for (int i = 0; i < menuString.length(); ++i) {
            char ch = menuString.charAt(i);
            switch (state) {
                case LOOKING_FOR_OPENING_BRACKET: {
                    if (ch == '.') {
                        if (menuName.length() == 0) {
                            throw new IllegalArgumentException("zero-length menu name found.");
                        }
                        namesAndGravities.add(new MenuNameAndGravity(menuName.toString(), -1.0));
                        menuName = new StringBuilder();
                        continue block7;
                    }
                    if (ch == '[') {
                        gravityAsString = new StringBuilder();
                        state = ParseState.LOOKING_FOR_CLOSING_BRACKET;
                        continue block7;
                    }
                    menuName.append(ch);
                    continue block7;
                }
                case LOOKING_FOR_CLOSING_BRACKET: {
                    double gravity;
                    if (ch != ']') {
                        gravityAsString.append(ch);
                        continue block7;
                    }
                    try {
                        gravity = Double.parseDouble(gravityAsString.toString());
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("bad \"gravity\" in menu string. (" + menuString + ")");
                    }
                    namesAndGravities.add(new MenuNameAndGravity(menuName.toString(), gravity));
                    menuName = new StringBuilder();
                    state = ParseState.LOOKING_FOR_PERIOD;
                    continue block7;
                }
                case LOOKING_FOR_PERIOD: {
                    if (ch != '.') {
                        throw new IllegalArgumentException("period expected in menu string. (" + menuString + ")");
                    }
                    state = ParseState.LOOKING_FOR_OPENING_BRACKET;
                }
            }
        }
        if (state == ParseState.LOOKING_FOR_OPENING_BRACKET) {
            namesAndGravities.add(new MenuNameAndGravity(menuName.toString(), -1.0));
        } else if (state != ParseState.LOOKING_FOR_PERIOD) {
            throw new IllegalArgumentException("incomplete \"gravity\" specification in menu string (" + menuName + "). (" + menuString + ")");
        }
        return namesAndGravities;
    }

    static final class MenuNameAndGravity {
        private final String menuName;
        private final double gravity;

        MenuNameAndGravity(String menuName, double gravity) {
            this.menuName = menuName;
            this.gravity = gravity;
        }

        String getMenuName() {
            return this.menuName;
        }

        double getGravity() {
            return this.gravity;
        }
    }

    static enum ParseState {
        LOOKING_FOR_OPENING_BRACKET,
        LOOKING_FOR_CLOSING_BRACKET,
        LOOKING_FOR_PERIOD;

    }
}

