/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing;

import java.io.File;
import java.util.Arrays;
import javax.swing.filechooser.FileFilter;

public final class FileChooserFilter
extends FileFilter {
    private final String description;
    private final String[] extensions;

    public FileChooserFilter(String description, String extension) {
        this(description, new String[]{extension});
    }

    public FileChooserFilter(String description, String[] extensions) {
        if (extensions == null) {
            throw new IllegalArgumentException("extensions should not be null.");
        }
        this.description = description;
        this.extensions = Arrays.copyOf(extensions, extensions.length);
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String fileName = file.getName().toLowerCase();
        if (this.extensions != null) {
            for (int i = 0; i < this.extensions.length; ++i) {
                if (!fileName.endsWith(this.extensions[i])) continue;
                return true;
            }
        } else {
            throw new IllegalArgumentException("No fileType specified");
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object other) {
        if (!(other instanceof FileChooserFilter)) {
            return false;
        }
        FileChooserFilter otherFilter = (FileChooserFilter)other;
        if (!otherFilter.description.equals(this.description)) {
            return false;
        }
        if (otherFilter.extensions.length != this.extensions.length) {
            return false;
        }
        Arrays.sort(otherFilter.extensions);
        Arrays.sort(this.extensions);
        for (int i = 0; i < this.extensions.length; ++i) {
            if (this.extensions[i].equals(otherFilter.extensions[i])) continue;
            return false;
        }
        return true;
    }
}

