/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public final class ColumnResizer {
    private static final int DEFLMAX_WIDTH = 280;

    private ColumnResizer() {
    }

    public static void adjustColumnPreferredWidths(JTable table) {
        ColumnResizer.adjustColumnPreferredWidths(table, true);
    }

    public static void adjustColumnPreferredWidths(JTable table, boolean checkAllRows) {
        int columnCount = table.getColumnModel().getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            ColumnResizer.adjustColumnPreferredWidth(table, col, checkAllRows);
        }
    }

    public static void adjustColumnPreferredWidth(JTable table, int col) {
        ColumnResizer.adjustColumnPreferredWidth(table, col, true);
    }

    public static void adjustColumnPreferredWidth(JTable table, int col, boolean checkAllRows) {
        TableColumn column;
        TableCellRenderer headerRenderer;
        int newWidth = 0;
        if (checkAllRows) {
            for (int row = 0; row < table.getRowCount(); ++row) {
                TableCellRenderer rend = table.getCellRenderer(row, col);
                Object value = table.getValueAt(row, col);
                Component comp = rend.getTableCellRendererComponent(table, value, false, false, row, col);
                newWidth = Math.max(comp.getPreferredSize().width, newWidth);
            }
        }
        if ((headerRenderer = (column = table.getColumnModel().getColumn(col)).getHeaderRenderer()) == null) {
            headerRenderer = table.getTableHeader().getDefaultRenderer();
        }
        Object headerValue = column.getHeaderValue();
        Component headerComp = headerRenderer.getTableCellRendererComponent(table, headerValue, false, false, 0, col);
        newWidth = Math.max(newWidth, headerComp.getPreferredSize().width);
        newWidth = Math.min(newWidth, 280);
        column.setPreferredWidth(newWidth += 20);
        column.setWidth(newWidth);
    }
}

