/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JButton;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.CyColorChooser;
import org.cytoscape.util.swing.CyColorPaletteChooser;
import org.cytoscape.util.swing.CyColorPaletteChooserFactory;
import org.cytoscape.util.swing.LookAndFeelUtil;

public final class ColorButton
extends JButton {
    private static final long serialVersionUID = -580523607515901450L;
    private Color color;
    private Color borderColor;
    private Palette palette;

    public ColorButton(Color color) {
        super(" ");
        this.init(color);
        this.addActionListener(evt -> {
            Color c = CyColorChooser.showDialog(this, "Colors", this.color);
            this.setColor(c);
        });
    }

    public ColorButton(CyServiceRegistrar serviceRegistrar, Palette palette, PaletteType type, Color color, boolean paletteOnly) {
        super(" ");
        this.init(color);
        this.setPalette(palette);
        this.addActionListener(evt -> {
            Color c;
            int size = 8;
            if (palette != null) {
                size = palette.size();
            }
            CyColorPaletteChooserFactory chooserFactory = serviceRegistrar.getService(CyColorPaletteChooserFactory.class);
            CyColorPaletteChooser chooser = chooserFactory.getColorPaletteChooser(type, paletteOnly);
            String title = "Colors";
            if (paletteOnly) {
                title = "Palettes";
            }
            if ((c = chooser.showDialog(this, title, palette, this.color, size)) != null) {
                this.setColor(c);
            }
        });
    }

    private void init(Color color) {
        if (LookAndFeelUtil.isAquaLAF()) {
            this.putClientProperty("JButton.buttonType", "gradient");
        }
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(0);
        this.borderColor = ColorButton.getContrastingColor(this.getBackground());
        this.setIcon(new ColorIcon());
        this.setColor(color);
    }

    public void setColor(Color color) {
        Color oldColor = this.color;
        this.color = color;
        this.repaint();
        this.firePropertyChange("color", oldColor, color);
    }

    public void setPalette(Palette palette) {
        Palette oldPalette = this.palette;
        this.palette = palette;
        this.repaint();
        this.firePropertyChange("palette", oldPalette, palette);
    }

    public Color getColor() {
        return this.color;
    }

    public Palette getPalette() {
        return this.palette;
    }

    private static Color getContrastingColor(Color color) {
        int d = 0;
        double a = 1.0 - (0.299 * (double)color.getRed() + 0.587 * (double)color.getGreen() + 0.114 * (double)color.getBlue()) / 255.0;
        d = a < 0.5 ? 0 : 255;
        return new Color(d, d, d);
    }

    private class ColorIcon
    implements Icon {
        private ColorIcon() {
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public int getIconWidth() {
            return 44;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            g.setColor(ColorButton.this.color);
            g.fillRect(x, y, w, h);
            g.setColor(ColorButton.this.borderColor);
            g.drawRect(x, y, w, h);
        }
    }
}

