/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CheckBoxJList
extends JList
implements ListSelectionListener {
    private static final long serialVersionUID = 120233987581935L;
    public static final String LIST_UPDATED = "LIST_UPDATED";
    private int lastIndex;
    private int firstIndex;
    private final Set<Integer> selectionCache = new HashSet<Integer>();

    public CheckBoxJList() {
        this.setCellRenderer(new CheckBoxListCellRenderer());
        this.addListSelectionListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CheckBoxJList.this.processClick();
            }
        });
    }

    protected void processClick() {
        if (this.selectionCache.size() == 1 && (this.getSelectedIndex() == this.firstIndex || this.getSelectedIndex() == this.lastIndex)) {
            this.fireSelectionValueChanged(0, 0, false);
        }
    }

    public void setSelectedItems(List<String> selected) {
        ListSelectionListener[] listeners;
        for (ListSelectionListener l : listeners = this.getListSelectionListeners()) {
            this.removeListSelectionListener(l);
        }
        this.getSelectionModel().clearSelection();
        this.selectionCache.clear();
        int size = this.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            if (!selected.contains(this.getModel().getElementAt(i))) continue;
            this.getSelectionModel().addSelectionInterval(i, i);
            this.selectionCache.add(i);
        }
        for (ListSelectionListener l : listeners) {
            this.addListSelectionListener(l);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (!lse.getValueIsAdjusting()) {
            this.firstIndex = lse.getFirstIndex();
            this.lastIndex = lse.getLastIndex();
            this.removeListSelectionListener(this);
            HashSet<Integer> newSelections = new HashSet<Integer>();
            int size = this.getModel().getSize();
            ListSelectionModel select = this.getSelectionModel();
            for (int i = 0; i < size; ++i) {
                if (!select.isSelectedIndex(i)) continue;
                newSelections.add(i);
            }
            for (Integer index : this.selectionCache) {
                select.addSelectionInterval(index, index);
            }
            for (Integer index : newSelections) {
                if (this.selectionCache.contains(index)) {
                    select.removeSelectionInterval(index, index);
                    continue;
                }
                select.addSelectionInterval(index, index);
            }
            this.selectionCache.clear();
            for (int i = 0; i < size; ++i) {
                if (!select.isSelectedIndex(i)) continue;
                this.selectionCache.add(i);
            }
            this.addListSelectionListener(this);
            this.firePropertyChange(LIST_UPDATED, null, null);
        }
    }

    private static final class CheckBoxListCellRenderer
    extends JComponent
    implements ListCellRenderer {
        private static final long serialVersionUID = 120233987573888L;
        private final DefaultListCellRenderer defaultComp;
        private final JCheckBox checkbox;
        private final BorderLayout layout = new BorderLayout();

        CheckBoxListCellRenderer() {
            this.setLayout(this.layout);
            this.defaultComp = new DefaultListCellRenderer();
            this.checkbox = new JCheckBox();
            this.add((Component)this.checkbox, "West");
            this.add((Component)this.defaultComp, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.defaultComp.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.checkbox.setSelected(isSelected);
            if (isSelected) {
                font = list.getFont().deriveFont(1);
                this.checkbox.setFont(font);
                this.defaultComp.setFont(font);
            } else {
                font = list.getFont().deriveFont(0);
                this.checkbox.setFont(font);
                this.defaultComp.setFont(font);
            }
            this.checkbox.setForeground(list.getForeground());
            this.defaultComp.setForeground(list.getForeground());
            Component[] comps = this.getComponents();
            int length = comps.length;
            for (int i = 0; i < length; ++i) {
                comps[i].setBackground(list.getBackground());
            }
            return this;
        }
    }
}

