/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cytoscape.event.AbstractCyPayloadEvent;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.RowsSetListener;

public final class RowsSetEvent
extends AbstractCyPayloadEvent<CyTable, RowSetRecord> {
    private Map<String, Collection<RowSetRecord>> columnNameToRecordMap;

    public RowsSetEvent(CyTable source, Collection<RowSetRecord> rows) {
        super(source, RowsSetListener.class, rows);
    }

    public boolean containsColumn(String colName) {
        return this.getMap().containsKey(colName);
    }

    public Collection<RowSetRecord> getColumnRecords(String colName) {
        Collection<RowSetRecord> col = this.getMap().get(colName);
        if (col == null) {
            return Collections.emptyList();
        }
        return col;
    }

    public Set<String> getColumns() {
        return Collections.unmodifiableSet(this.getMap().keySet());
    }

    private synchronized Map<String, Collection<RowSetRecord>> getMap() {
        if (this.columnNameToRecordMap == null) {
            this.columnNameToRecordMap = new HashMap<String, Collection<RowSetRecord>>();
            for (RowSetRecord record : this.getPayloadCollection()) {
                String columnName = record.getColumn();
                if (!this.columnNameToRecordMap.containsKey(columnName)) {
                    this.columnNameToRecordMap.put(columnName, new ArrayList());
                }
                this.columnNameToRecordMap.get(columnName).add(record);
            }
        }
        return this.columnNameToRecordMap;
    }
}

