/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.events;

import org.cytoscape.event.AbstractCyEvent;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;

class AbstractColumnEvent
extends AbstractCyEvent<CyTable> {
    private final String columnName;
    private final Long suid;

    AbstractColumnEvent(CyTable source, Class<?> listenerClass, String columnName) {
        this(source, listenerClass, columnName, null);
    }

    AbstractColumnEvent(CyTable source, Class<?> listenerClass, String columnName, Long suid) {
        super(source, listenerClass);
        if (columnName == null) {
            throw new NullPointerException("columnName can't be null");
        }
        this.columnName = columnName;
        this.suid = suid;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getNamespace() {
        return CyColumn.splitColumnName(this.columnName)[0];
    }

    public String getNameOnly() {
        return CyColumn.splitColumnName(this.columnName)[1];
    }

    public Long getSUID() {
        return this.suid;
    }
}

