/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;

public class CyTableUtil {
    private CyTableUtil() {
    }

    public static List<CyNode> getNodesInState(CyNetwork net, String columnName, boolean state) {
        if (net == null) {
            throw new NullPointerException("network is null");
        }
        Collection<Long> suids = net.getDefaultNodeTable().getMatchingKeys(columnName, state, Long.class);
        ArrayList<CyNode> ret = new ArrayList<CyNode>(suids.size());
        for (Long suid : suids) {
            CyNode node = net.getNode(suid);
            if (node == null) continue;
            ret.add(node);
        }
        return ret;
    }

    public static List<CyNode> getSelectedNodes(CyNetwork network) {
        return CyTableUtil.getNodesInState(network, "selected", true);
    }

    public static List<CyEdge> getEdgesInState(CyNetwork net, String columnName, boolean state) {
        if (net == null) {
            throw new NullPointerException("network is null");
        }
        Collection<Long> suids = net.getDefaultEdgeTable().getMatchingKeys(columnName, state, Long.class);
        ArrayList<CyEdge> ret = new ArrayList<CyEdge>(suids.size());
        for (Long suid : suids) {
            CyEdge edge = net.getEdge(suid);
            if (edge == null) continue;
            ret.add(edge);
        }
        return ret;
    }

    public static List<CyEdge> getSelectedEdges(CyNetwork network) {
        return CyTableUtil.getEdgesInState(network, "selected", true);
    }

    public static Set<String> getColumnNames(CyTable table) {
        HashSet<String> names = new HashSet<String>();
        for (CyColumn column : table.getColumns()) {
            names.add(column.getName());
        }
        return names;
    }
}

