/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.SavePolicy;

public interface CyTable
extends CyIdentifiable {
    public boolean isPublic();

    public void setPublic(boolean var1);

    public Mutability getMutability();

    public String getTitle();

    public void setTitle(String var1);

    public CyColumn getPrimaryKey();

    public CyColumn getColumn(String var1);

    default public CyColumn getColumn(String namespace, String name) {
        return this.getColumn(CyColumn.joinColumnName(namespace, name));
    }

    public Collection<CyColumn> getColumns();

    default public Collection<CyColumn> getColumns(String namespace) {
        return this.getColumns().stream().filter(col -> Objects.equals(col.getNamespace(), namespace)).collect(Collectors.toList());
    }

    default public Collection<String> getNamespaces() {
        return this.getColumns().stream().map(CyColumn::getNamespace).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public void deleteColumn(String var1);

    default public void deleteColumn(String namespace, String columnName) {
        this.deleteColumn(CyColumn.joinColumnName(namespace, columnName));
    }

    public <T> void createColumn(String var1, Class<? extends T> var2, boolean var3);

    default public <T> void createColumn(String namespace, String columnName, Class<? extends T> type, boolean isImmutable) {
        this.createColumn(CyColumn.joinColumnName(namespace, columnName), type, isImmutable);
    }

    public <T> void createColumn(String var1, Class<? extends T> var2, boolean var3, T var4);

    default public <T> void createColumn(String namespace, String columnName, Class<? extends T> type, boolean isImmutable, T defaultValue) {
        this.createColumn(CyColumn.joinColumnName(namespace, columnName), type, isImmutable, defaultValue);
    }

    public <T> void createListColumn(String var1, Class<T> var2, boolean var3);

    default public <T> void createListColumn(String namespace, String columnName, Class<T> listElementType, boolean isImmutable) {
        this.createListColumn(CyColumn.joinColumnName(namespace, columnName), listElementType, isImmutable);
    }

    public <T> void createListColumn(String var1, Class<T> var2, boolean var3, List<T> var4);

    default public <T> void createListColumn(String namespace, String columnName, Class<T> listElementType, boolean isImmutable, List<T> defaultValue) {
        this.createListColumn(CyColumn.joinColumnName(namespace, columnName), listElementType, isImmutable);
    }

    public CyRow getRow(Object var1);

    public boolean rowExists(Object var1);

    public boolean deleteRows(Collection<?> var1);

    public List<CyRow> getAllRows();

    public String getLastInternalError();

    public Collection<CyRow> getMatchingRows(String var1, Object var2);

    default public Collection<CyRow> getMatchingRows(String namespace, String columnName, Object value) {
        return this.getMatchingRows(CyColumn.joinColumnName(namespace, columnName), value);
    }

    public <T> Collection<T> getMatchingKeys(String var1, Object var2, Class<T> var3);

    default public <T> Collection<T> getMatchingKeys(String namespace, String columnName, Object value, Class<T> type) {
        return this.getMatchingKeys(CyColumn.joinColumnName(namespace, columnName), value, type);
    }

    public int countMatchingRows(String var1, Object var2);

    default public int countMatchingRows(String namespace, String columnName, Object value) {
        return this.countMatchingRows(CyColumn.joinColumnName(namespace, columnName), value);
    }

    public int getRowCount();

    public String addVirtualColumn(String var1, String var2, CyTable var3, String var4, boolean var5);

    public void addVirtualColumns(CyTable var1, String var2, boolean var3);

    public SavePolicy getSavePolicy();

    public void setSavePolicy(SavePolicy var1);

    public void swap(CyTable var1);

    public static enum Mutability {
        MUTABLE("mutable"),
        PERMANENTLY_IMMUTABLE("permanently immutable"),
        IMMUTABLE_DUE_TO_VIRT_COLUMN_REFERENCES("immutable due to virtual column references");

        private String humanReadableRepresentation;

        private Mutability(String humanReadableRepresentation) {
            this.humanReadableRepresentation = humanReadableRepresentation;
        }

        public final String toString() {
            return this.humanReadableRepresentation;
        }
    }
}

