/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.jobs;

public class CyJobStatus {
    protected Status status;
    protected String message;

    public CyJobStatus(Status status, String message) {
        this.status = status;
        this.message = message;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        Object str = this.status.getName();
        if (this.message != null) {
            str = (String)str + ": " + this.message;
        }
        return str;
    }

    public boolean isDone() {
        return this.status.equals((Object)Status.CANCELED) || this.status.equals((Object)Status.ERROR) || this.status.equals((Object)Status.FAILED) || this.status.equals((Object)Status.FINISHED) || this.status.equals((Object)Status.TERMINATED);
    }

    public static enum Status {
        CANCELED("Canceled by the user or operator"),
        ERROR("Finished with errors or warnings"),
        FAILED("Failed"),
        FINISHED("Successfully finished"),
        PURGED("Job purged (no longer exists)"),
        RUNNING("Running"),
        QUEUED("In queue"),
        SUBMITTED("Submitted"),
        TERMINATED("Terminated"),
        UNKNOWN("Status unknown due to communications failure");

        private final String name;

        private Status(String n2) {
            this.name = n2;
        }

        public String getName() {
            return this.name;
        }
    }
}

