/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DebounceTimer {
    public static final int DEFAULT_DELAY_MILLISECONDS = 120;
    private static final Object DEFAULT_KEY = new Object();
    private final Map<Object, ScheduledFuture<?>> store = Collections.synchronizedMap(new HashMap());
    private final ScheduledThreadPoolExecutor executor;
    private final int delay;

    public DebounceTimer() {
        this(120);
    }

    public DebounceTimer(int delayMilliseconds) {
        this.delay = delayMilliseconds;
        this.executor = new ScheduledThreadPoolExecutor(1, runnable -> {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setName(DebounceTimer.class.getSimpleName() + "_" + thread.getName());
            return thread;
        });
    }

    public synchronized void debounce(Runnable runnable) {
        this.debounce(DEFAULT_KEY, runnable);
    }

    public synchronized void debounce(Object key, Runnable runnable) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(runnable);
        ScheduledFuture<?> future = this.store.get(key);
        if (future != null) {
            future.cancel(false);
        }
        Runnable r = () -> {
            this.store.remove(key);
            runnable.run();
        };
        future = this.executor.schedule(r, (long)this.delay, TimeUnit.MILLISECONDS);
        this.store.put(key, future);
    }

    public synchronized void shutdown() {
        this.executor.shutdown();
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }
}

