/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.application.swing;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.cytoscape.application.swing.CyColumnPresentation;
import org.cytoscape.application.swing.CyColumnPresentationManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class CyColumnSelector
extends JPanel {
    private static final int SELECTED_COL_IDX = 0;
    private static final int NAME_COL_IDX = 1;
    private static final int TYPE_COL_IDX = 2;
    private static final int SHARED_COL_IDX = 3;
    private static final String[] headerNames = new String[]{"", "Column Name", "Type", ""};
    private static final Border CELL_BORDER = BorderFactory.createEmptyBorder();
    private static final String CYTOSCAPE_CARD = "::";
    private final IconManager iconManager;
    private final CyColumnPresentationManager columnPresentationManager;
    private final SortedMap<String, List<CyColumn>> namespaces;
    private final Set<String> selectedColumnNames;

    public CyColumnSelector(IconManager iconManager, CyColumnPresentationManager columnPresentationManager) {
        this.iconManager = Objects.requireNonNull(iconManager);
        this.columnPresentationManager = Objects.requireNonNull(columnPresentationManager);
        Collator collator = Collator.getInstance(Locale.getDefault());
        this.namespaces = new TreeMap(Comparator.nullsFirst(collator::compare));
        this.selectedColumnNames = new HashSet<String>();
    }

    public void update(Collection<CyColumn> columns, Collection<String> selectedColumnNames) {
        this.namespaces.clear();
        this.selectedColumnNames.clear();
        for (CyColumn column : columns) {
            this.namespaces.computeIfAbsent(column.getNamespace(), k -> new ArrayList()).add(column);
        }
        if (selectedColumnNames != null) {
            this.selectedColumnNames.addAll(selectedColumnNames);
        }
        Comparator<CyColumn> nameComparator = Comparator.comparing(CyColumn::getNameOnly, Collator.getInstance(Locale.getDefault()));
        for (List<CyColumn> namespaceColumns : this.namespaces.values()) {
            namespaceColumns.sort(nameComparator);
        }
        this.init();
    }

    public Set<String> getSelectedColumnNames() {
        return new HashSet<String>(this.selectedColumnNames);
    }

    private void init() {
        this.removeAll();
        this.createContents();
    }

    private void createContents() {
        JPanel cardPanel = this.createCardPanel();
        if (this.namespaces.size() == 1) {
            this.setLayout(new BorderLayout());
            this.add((Component)cardPanel, "Center");
        } else {
            JPanel namespaceListPanel = this.createNamespaceListPanel(cardPanel);
            namespaceListPanel.setPreferredSize(new Dimension(180, namespaceListPanel.getPreferredSize().height));
            JSplitPane splitPane = new JSplitPane(1, namespaceListPanel, cardPanel);
            splitPane.setBorder(BorderFactory.createEmptyBorder());
            this.setLayout(new BorderLayout());
            this.add((Component)splitPane, "Center");
        }
    }

    private JPanel createCardPanel() {
        JPanel cardPanel = new JPanel(new CardLayout());
        for (String namespace : this.namespaces.keySet()) {
            List columns = (List)this.namespaces.get(namespace);
            MutipleSelectColumnTable columnTable = new MutipleSelectColumnTable(columns);
            cardPanel.add(namespace == null ? CYTOSCAPE_CARD : namespace, columnTable);
        }
        return cardPanel;
    }

    private JPanel createNamespaceListPanel(JPanel cardPanel) {
        DefaultListModel listModel = new DefaultListModel();
        this.namespaces.keySet().forEach(listModel::addElement);
        JList<Object> namespaceList = new JList<Object>(listModel);
        namespaceList.setSelectionMode(0);
        namespaceList.setCellRenderer(new NamespaceListRenderer());
        namespaceList.setSelectedIndex(0);
        JScrollPane scrollPane = CyColumnSelector.createScrollPane(namespaceList);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        namespaceList.addListSelectionListener(evt -> {
            String namespace = (String)namespaceList.getSelectedValue();
            CardLayout cardLayout = (CardLayout)cardPanel.getLayout();
            cardLayout.show(cardPanel, namespace == null ? CYTOSCAPE_CARD : namespace);
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    private static JScrollPane createScrollPane(Component view) {
        JScrollPane tableScrollPane = new JScrollPane();
        tableScrollPane.setPreferredSize(new Dimension(300, 180));
        tableScrollPane.setViewportView(view);
        Color bg = UIManager.getColor("Table.background");
        tableScrollPane.setBackground(bg);
        tableScrollPane.getViewport().setBackground(bg);
        return tableScrollPane;
    }

    private class MutipleSelectColumnTable
    extends JPanel {
        private final List<CyColumn> columns = new ArrayList<CyColumn>();
        private JTable table;
        private JScrollPane tableScrollPane;
        private JButton selectAllButton;
        private JButton selectNoneButton;
        private List<Integer> previousSelectedRows;

        public MutipleSelectColumnTable(List<CyColumn> columns) {
            this.init();
            this.update(columns);
        }

        public void update(Collection<CyColumn> columns) {
            this.columns.clear();
            if (columns != null) {
                for (CyColumn c : columns) {
                    this.columns.add(c);
                }
            }
            this.updateTable();
            this.updateSelectionButtons();
        }

        private void init() {
            this.setBackground(this.getTableScrollPane().getBackground());
            LookAndFeelUtil.makeSmall(this.getSelectAllButton(), this.getSelectNoneButton());
            LookAndFeelUtil.equalizeSize(this.getSelectAllButton(), this.getSelectNoneButton());
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getTableScrollPane(), -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.getSelectAllButton(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getSelectNoneButton(), -2, -1, -2).addContainerGap()));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getTableScrollPane(), -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getSelectAllButton(), -2, -1, -2).addComponent(this.getSelectNoneButton(), -2, -1, -2)));
        }

        private void updateTable() {
            Object[][] data = new Object[this.columns.size()][headerNames.length];
            int i = 0;
            for (CyColumn c : this.columns) {
                data[i][0] = CyColumnSelector.this.selectedColumnNames.contains(c.getName());
                data[i][1] = c.getName();
                data[i][2] = c;
                data[i][3] = c.getVirtualColumnInfo().isVirtual();
                ++i;
            }
            DefaultTableModel model = new DefaultTableModel(data, headerNames){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            this.getTable().setModel(model);
            TableColumnModel columnModel = this.getTable().getColumnModel();
            columnModel.getColumn(0).setMaxWidth(22);
            columnModel.getColumn(2).setMaxWidth(44);
            columnModel.getColumn(3).setMaxWidth(22);
            columnModel.getColumn(0).setResizable(false);
            columnModel.getColumn(2).setResizable(false);
            columnModel.getColumn(3).setResizable(false);
        }

        private void updateSelectionButtons() {
            int rowCount = this.table.getRowCount();
            boolean hasUnselected = false;
            boolean hasSelected = false;
            for (int i = 0; i < rowCount; ++i) {
                boolean selected = (Boolean)this.table.getModel().getValueAt(i, 0);
                if (!hasUnselected) {
                    boolean bl = hasUnselected = !selected;
                }
                if (!hasSelected) {
                    hasSelected = selected;
                }
                if (hasUnselected && hasSelected) break;
            }
            this.getSelectAllButton().setEnabled(hasUnselected);
            this.getSelectNoneButton().setEnabled(hasSelected);
        }

        private JTable getTable() {
            if (this.table == null) {
                final DefaultSelectorTableCellRenderer defRenderer = new DefaultSelectorTableCellRenderer();
                final CheckBoxTableCellRenderer checkBoxRenderer = new CheckBoxTableCellRenderer();
                this.table = new JTable(new DefaultTableModel(headerNames, 0)){

                    @Override
                    public TableCellRenderer getCellRenderer(int row, int column) {
                        if (column == 0) {
                            return checkBoxRenderer;
                        }
                        return defRenderer;
                    }
                };
                this.table.setTableHeader(null);
                this.table.setShowGrid(false);
                this.table.getSelectionModel().addListSelectionListener(evt -> {
                    if (!evt.getValueIsAdjusting() && this.table.getSelectedRowCount() > 0) {
                        this.previousSelectedRows = Arrays.stream(this.table.getSelectedRows()).boxed().collect(Collectors.toList());
                    }
                });
                this.table.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        boolean isMac = LookAndFeelUtil.isMac();
                        if (isMac && e.isMetaDown() || !isMac && e.isControlDown() || e.isShiftDown()) {
                            return;
                        }
                        int row = MutipleSelectColumnTable.this.table.rowAtPoint(e.getPoint());
                        if (MutipleSelectColumnTable.this.previousSelectedRows != null && MutipleSelectColumnTable.this.previousSelectedRows.contains(row)) {
                            for (int i : MutipleSelectColumnTable.this.previousSelectedRows) {
                                MutipleSelectColumnTable.this.table.addRowSelectionInterval(i, i);
                            }
                        }
                        MutipleSelectColumnTable.this.toggleSelection(row);
                        MutipleSelectColumnTable.this.updateSelectionButtons();
                    }
                });
            }
            return this.table;
        }

        private JScrollPane getTableScrollPane() {
            if (this.tableScrollPane == null) {
                this.tableScrollPane = CyColumnSelector.createScrollPane(this.getTable());
                this.tableScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Separator.foreground")));
            }
            return this.tableScrollPane;
        }

        private JButton getSelectAllButton() {
            if (this.selectAllButton == null) {
                this.selectAllButton = new JButton("Select All");
                this.selectAllButton.addActionListener(evt -> this.setSelectedToAllRows(true));
                if (LookAndFeelUtil.isAquaLAF()) {
                    this.selectAllButton.putClientProperty("JButton.buttonType", "gradient");
                    this.selectAllButton.putClientProperty("JComponent.sizeVariant", "small");
                }
            }
            return this.selectAllButton;
        }

        private JButton getSelectNoneButton() {
            if (this.selectNoneButton == null) {
                this.selectNoneButton = new JButton("Select None");
                this.selectNoneButton.addActionListener(evt -> this.setSelectedToAllRows(false));
                if (LookAndFeelUtil.isAquaLAF()) {
                    this.selectNoneButton.putClientProperty("JButton.buttonType", "gradient");
                    this.selectNoneButton.putClientProperty("JComponent.sizeVariant", "small");
                }
            }
            return this.selectNoneButton;
        }

        private void setSelectedToAllRows(boolean selected) {
            int rowCount = this.getTable().getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                this.getTable().setValueAt(selected, i, 0);
                String name = (String)this.getTable().getValueAt(i, 1);
                if (selected) {
                    CyColumnSelector.this.selectedColumnNames.add(name);
                    continue;
                }
                CyColumnSelector.this.selectedColumnNames.remove(name);
            }
            this.getTable().repaint();
            this.updateSelectionButtons();
        }

        private void toggleSelection(int row) {
            boolean selected = (Boolean)this.getTable().getValueAt(row, 0);
            int[] selectedRows = this.getTable().getSelectedRows();
            if (selectedRows != null) {
                for (int i : selectedRows) {
                    String name = (String)this.getTable().getValueAt(i, 1);
                    this.getTable().setValueAt(!selected, i, 0);
                    if (selected) {
                        CyColumnSelector.this.selectedColumnNames.remove(name);
                        continue;
                    }
                    CyColumnSelector.this.selectedColumnNames.add(name);
                }
                this.getTable().repaint();
            }
        }
    }

    private class NamespaceListRenderer
    extends DefaultListCellRenderer {
        private NamespaceListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String namespace = (String)value;
            CyColumnPresentation columnPresentation = CyColumnSelector.this.columnPresentationManager.getColumnPresentation(namespace);
            if (value == null) {
                value = "Cytoscape";
            }
            Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            Icon icon = columnPresentation.getNamespaceIcon();
            if (icon != null) {
                icon = IconManager.resizeIcon(icon, 16);
            }
            this.setIcon(icon);
            return component;
        }
    }

    private static enum AttributeDataType {
        TYPE_STRING(String.class, null, "ab", "String"),
        TYPE_INTEGER(Integer.class, null, "1", "Integer"),
        TYPE_LONG(Long.class, null, "123", "Long Integer"),
        TYPE_FLOATING(Double.class, null, "1.0", "Floating Point"),
        TYPE_BOOLEAN(Boolean.class, null, "y/n", "Boolean"),
        TYPE_STRING_LIST(List.class, String.class, "[ ab ]", "List of Strings"),
        TYPE_INTEGER_LIST(List.class, Integer.class, "[ 1 ]", "List of Integers"),
        TYPE_LONG_LIST(List.class, Long.class, "[ 123 ]", "List of Long Integers"),
        TYPE_FLOATING_LIST(List.class, Double.class, "[ 1.0 ]", "List of Floating Point Numbers"),
        TYPE_BOOLEAN_LIST(List.class, Boolean.class, "[ y/n ]", "List of Booleans");

        private final Class<?> type;
        private final Class<?> listType;
        private final String text;
        private final String description;

        private AttributeDataType(Class<?> type, Class<?> listType, String text, String description) {
            this.type = type;
            this.listType = listType;
            this.text = text;
            this.description = description;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Class<?> getListType() {
            return this.listType;
        }

        public boolean isList() {
            return this.listType != null;
        }

        public String getText() {
            return this.text;
        }

        public String getDescription() {
            return this.description;
        }

        public static AttributeDataType getAttributeDataType(Class<?> type, Class<?> listType) {
            for (AttributeDataType adt : AttributeDataType.values()) {
                if (adt.getType() != type || listType != null && listType != adt.getListType()) continue;
                return adt;
            }
            return TYPE_STRING;
        }
    }

    private class CheckBoxTableCellRenderer
    implements TableCellRenderer {
        final JPanel panel;
        final JCheckBox chk = new JCheckBox();

        CheckBoxTableCellRenderer() {
            if (LookAndFeelUtil.isAquaLAF()) {
                this.chk.putClientProperty("JComponent.sizeVariant", "mini");
            }
            this.panel = new JPanel(new BorderLayout());
            this.panel.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
            this.panel.add((Component)this.chk, "West");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color bg = UIManager.getColor("Table.background");
            this.chk.setSelected((Boolean)value);
            this.chk.setToolTipText((Boolean)value != false ? "Show" : "Hide");
            this.chk.setBackground(isSelected ? UIManager.getColor("Table.selectionBackground") : bg);
            this.panel.setBackground(isSelected ? UIManager.getColor("Table.selectionBackground") : bg);
            this.panel.setBorder(new EmptyBorder(0, 0, 0, 0));
            return this.panel;
        }
    }

    private class DefaultSelectorTableCellRenderer
    extends DefaultTableCellRenderer {
        final Font typeFont = new Font("Serif", 1, 11);
        final Font defFont = this.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize());

        DefaultSelectorTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setForeground(table.getForeground());
            Color bg = UIManager.getColor("Table.background");
            this.setBackground(isSelected ? UIManager.getColor("Table.selectionBackground") : bg);
            this.setBorder(CELL_BORDER);
            if (value instanceof Boolean) {
                this.setFont(CyColumnSelector.this.iconManager.getIconFont(12.0f));
                this.setHorizontalAlignment(0);
                if (column == 3) {
                    this.setText((Boolean)value != false ? "\uf0e8" : "");
                    this.setToolTipText((Boolean)value != false ? "Network Collection Column" : null);
                } else {
                    this.setText((Boolean)value != false ? "\uf14a" : "\uf096");
                }
            } else if (column == 2 && value instanceof CyColumn) {
                CyColumn c = (CyColumn)value;
                AttributeDataType adt = AttributeDataType.getAttributeDataType(c.getType(), c.getListElementType());
                if (adt != null) {
                    this.setFont(this.typeFont);
                    this.setHorizontalAlignment(0);
                    this.setText(adt.getText());
                    this.setToolTipText(adt.getDescription());
                }
            } else {
                this.setFont(this.defFont);
                this.setHorizontalAlignment(2);
                this.setToolTipText("" + value);
                if (column == 1 && value instanceof String) {
                    String name = (String)value;
                    String[] parts = CyColumn.splitColumnName(name);
                    this.setText(parts[1]);
                }
            }
            return this;
        }
    }
}

