/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.application.swing;

import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractEnableSupport;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.swing.DynamicSubmenuListener;

public final class ActionEnableSupport
extends AbstractEnableSupport {
    private final CyApplicationManager applicationManager;
    private final CyNetworkViewManager networkViewManager;
    private final String enableFor;
    public static final String ENABLE_FOR_NETWORK = "network";
    public static final String ENABLE_FOR_SINGLE_NETWORK = "singleNetwork";
    public static final String ENABLE_FOR_NETWORK_WITHOUT_VIEW = "networkWithoutView";
    public static final String ENABLE_FOR_NETWORK_AND_VIEW = "networkAndView";
    public static final String ENABLE_FOR_SELECTED_NODES_OR_EDGES = "selectedNodesOrEdges";
    public static final String ENABLE_FOR_SELECTED_NODES = "selectedNodes";
    public static final String ENABLE_FOR_SELECTED_EDGES = "selectedEdges";
    public static final String ENABLE_FOR_TABLE = "table";
    public static final String ENABLE_FOR_ALWAYS = "always";

    public ActionEnableSupport(DynamicSubmenuListener submenuListener, String enableFor, CyApplicationManager applicationManager, CyNetworkViewManager networkViewManager) {
        super(submenuListener);
        this.networkViewManager = networkViewManager;
        this.enableFor = enableFor;
        this.applicationManager = applicationManager;
    }

    public ActionEnableSupport(Action action, String enableFor, CyApplicationManager applicationManager, CyNetworkViewManager networkViewManager) {
        super(action);
        this.enableFor = enableFor;
        this.applicationManager = applicationManager;
        this.networkViewManager = networkViewManager;
    }

    public ActionEnableSupport(JMenuItem menuItem, String enableFor, CyApplicationManager applicationManager, CyNetworkViewManager networkViewManager) {
        super(menuItem);
        this.enableFor = enableFor;
        this.applicationManager = applicationManager;
        this.networkViewManager = networkViewManager;
    }

    @Override
    public void updateEnableState() {
        if (this.enableFor == null) {
            this.setEnabled(true);
        } else if (this.enableFor.equals(ENABLE_FOR_ALWAYS)) {
            this.setEnabled(true);
        } else if (this.enableFor.equals(ENABLE_FOR_NETWORK)) {
            this.enableForNetwork();
        } else if (this.enableFor.equals(ENABLE_FOR_SINGLE_NETWORK)) {
            this.enableForSingleNetwork();
        } else if (this.enableFor.equals(ENABLE_FOR_NETWORK_WITHOUT_VIEW)) {
            this.enableForNetworkWithoutView();
        } else if (this.enableFor.equals(ENABLE_FOR_NETWORK_AND_VIEW)) {
            this.enableForNetworkAndView();
        } else if (this.enableFor.equals(ENABLE_FOR_SELECTED_NODES_OR_EDGES)) {
            this.enableForSelectedNodesOrEdges();
        } else if (this.enableFor.equals(ENABLE_FOR_SELECTED_NODES)) {
            this.enableForSelectedNodes();
        } else if (this.enableFor.equals(ENABLE_FOR_SELECTED_EDGES)) {
            this.enableForSelectedEdges();
        } else if (this.enableFor.equals(ENABLE_FOR_TABLE)) {
            this.enableForTable();
        } else {
            this.setEnabled(true);
        }
    }

    private void enableForNetwork() {
        CyNetwork n = this.applicationManager.getCurrentNetwork();
        this.setEnabled(n != null);
    }

    private void enableForSingleNetwork() {
        CyNetwork n = this.applicationManager.getCurrentNetwork();
        if (n == null) {
            this.setEnabled(false);
        } else {
            List<CyNetwork> networks = this.applicationManager.getSelectedNetworks();
            this.setEnabled(networks.size() == 1 && networks.contains(n));
        }
    }

    private void enableForNetworkWithoutView() {
        CyNetwork n = this.applicationManager.getCurrentNetwork();
        if (n == null) {
            this.setEnabled(false);
        } else {
            Collection<CyNetworkView> views = this.networkViewManager.getNetworkViews(n);
            this.setEnabled(views.isEmpty());
        }
    }

    private void enableForNetworkAndView() {
        CyNetworkView v = this.applicationManager.getCurrentNetworkView();
        this.setEnabled(v != null);
    }

    private void enableForSelectedNodesOrEdges() {
        CyNetwork n = this.applicationManager.getCurrentNetwork();
        if (n == null || n.getDefaultNodeTable() == null || n.getDefaultEdgeTable() == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(n.getDefaultNodeTable().countMatchingRows("selected", true) > 0 || n.getDefaultEdgeTable().countMatchingRows("selected", true) > 0);
        }
    }

    private void enableForSelectedNodes() {
        CyNetwork n = this.applicationManager.getCurrentNetwork();
        if (n == null || n.getDefaultNodeTable() == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(n.getDefaultNodeTable().countMatchingRows("selected", true) > 0);
        }
    }

    private void enableForSelectedEdges() {
        CyNetwork n = this.applicationManager.getCurrentNetwork();
        if (n == null || n.getDefaultEdgeTable() == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(n.getDefaultEdgeTable().countMatchingRows("selected", true) > 0);
        }
    }

    private void enableForTable() {
        this.setEnabled(this.applicationManager.getCurrentTable() != null);
    }
}

