/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.application.swing;

import javax.swing.Action;
import javax.swing.JMenuItem;
import org.cytoscape.work.swing.DynamicSubmenuListener;

abstract class AbstractEnableSupport {
    private final Action action;
    private final JMenuItem menuItem;
    private final DynamicSubmenuListener submenuListener;
    private boolean enableState;

    public AbstractEnableSupport(DynamicSubmenuListener submenuListener) {
        this.submenuListener = submenuListener;
        this.action = null;
        this.menuItem = null;
        this.enableState = true;
    }

    public AbstractEnableSupport(Action action) {
        this.submenuListener = null;
        this.action = action;
        this.menuItem = null;
        this.enableState = true;
    }

    public AbstractEnableSupport(JMenuItem menuItem) {
        this.submenuListener = null;
        this.action = null;
        this.menuItem = menuItem;
        this.enableState = true;
    }

    public abstract void updateEnableState();

    protected void setEnabled(boolean b) {
        this.enableState = b;
        if (this.submenuListener != null) {
            this.submenuListener.setEnabled(this.enableState);
        }
        if (this.action != null) {
            this.action.setEnabled(this.enableState);
        }
        if (this.menuItem != null) {
            this.menuItem.setEnabled(this.enableState);
        }
    }

    public final synchronized boolean isCurrentlyEnabled() {
        return this.enableState;
    }
}

