/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.application.events;

import java.util.Collection;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.event.AbstractCyEvent;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;

public final class SetCurrentNetworkEvent
extends AbstractCyEvent<CyApplicationManager> {
    private final CyNetwork net;
    private Collection<CyNode> selectedNodes;
    private Collection<CyNode> unselectedNodes;
    private Collection<CyEdge> selectedEdges;
    private Collection<CyEdge> unselectedEdges;

    public final CyNetwork getNetwork() {
        return this.net;
    }

    public SetCurrentNetworkEvent(CyApplicationManager source, CyNetwork net) {
        super(source, SetCurrentNetworkListener.class);
        this.net = net;
    }

    public Collection<CyNode> getSelectedNodes() {
        if (this.selectedNodes == null) {
            this.selectedNodes = CyTableUtil.getNodesInState(this.getNetwork(), "selected", true);
        }
        return this.selectedNodes;
    }

    public Collection<CyNode> getUnselectedNodes() {
        if (this.unselectedNodes == null) {
            this.unselectedNodes = CyTableUtil.getNodesInState(this.getNetwork(), "selected", false);
        }
        return this.unselectedNodes;
    }

    public Collection<CyEdge> getSelectedEdges() {
        if (this.selectedEdges == null) {
            this.selectedEdges = CyTableUtil.getEdgesInState(this.getNetwork(), "selected", true);
        }
        return this.selectedEdges;
    }

    public Collection<CyEdge> getUnselectedEdges() {
        if (this.unselectedEdges == null) {
            this.unselectedEdges = CyTableUtil.getEdgesInState(this.getNetwork(), "selected", false);
        }
        return this.unselectedEdges;
    }
}

