/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.idmapper.task;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.cytoscape.idmapper.task.ColumnMappingTask;
import org.cytoscape.idmapper.task.MapColumnCommandTask;
import org.cytoscape.idmapper.task.MapColumnTaskFactory;
import org.cytoscape.model.CyColumn;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractTableColumnTaskFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TunableSetter;
import org.cytoscape.work.undo.UndoSupport;

public class MapColumnTaskFactoryImpl
extends AbstractTableColumnTaskFactory
implements MapColumnTaskFactory,
TaskFactory {
    private final UndoSupport undoSupport;
    private CyServiceRegistrar serviceRegistrar;
    private final TunableSetter tunableSetter;
    public String ERROR = "Can't map this column type as identifiers";

    public MapColumnTaskFactoryImpl(UndoSupport undo, TunableSetter tunable, CyServiceRegistrar reg) {
        this.undoSupport = undo;
        this.tunableSetter = tunable;
        this.serviceRegistrar = reg;
    }

    public TaskIterator createTaskIterator(CyColumn column) {
        if (column == null) {
            throw new IllegalStateException("you forgot to set the CyColumn on this task factory.");
        }
        Class type = column.getType();
        if (type == Double.class) {
            return new TaskIterator(new Task[]{new EmptyTask()});
        }
        if (type == Integer.class) {
            return new TaskIterator(new Task[]{new EmptyTask()});
        }
        return new TaskIterator(new Task[]{new ColumnMappingTask(this.undoSupport, column, this.serviceRegistrar)});
    }

    @Override
    public TaskIterator createTaskIterator(CyColumn column, String newColumnName) {
        return this.createTaskIterator();
    }

    public TaskIterator createTaskIterator() {
        return new TaskIterator(new Task[]{new MapColumnCommandTask(this.serviceRegistrar)});
    }

    public boolean isReady() {
        return true;
    }

    class EmptyTask
    extends AbstractTask {
        EmptyTask() {
        }

        public void run(TaskMonitor taskMonitor) throws Exception {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, MapColumnTaskFactoryImpl.this.ERROR, "ID Mapping Result", 2);
                }
            });
        }
    }
}

