/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Map;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;

public class DiscreteMappingSerializer
extends JsonSerializer<DiscreteMapping> {
    public Class<DiscreteMapping> handledType() {
        return DiscreteMapping.class;
    }

    public void serialize(DiscreteMapping mapping, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.useDefaultPrettyPrinter();
        jgen.writeStartObject();
        jgen.writeStringField("mappingType", "discrete");
        jgen.writeStringField("mappingColumn", mapping.getMappingColumnName());
        jgen.writeStringField("mappingColumnType", mapping.getMappingColumnType().getSimpleName());
        jgen.writeStringField("visualProperty", mapping.getVisualProperty().getIdString());
        this.serializeMapping(mapping, jgen);
        jgen.writeEndObject();
    }

    private final void serializeMapping(DiscreteMapping mapping, JsonGenerator jgen) throws IOException {
        Map valueMap = mapping.getAll();
        VisualProperty vp = mapping.getVisualProperty();
        jgen.writeArrayFieldStart("map");
        for (Object key : valueMap.keySet()) {
            Object value = valueMap.get(key);
            jgen.writeStartObject();
            jgen.writeStringField("key", key.toString());
            jgen.writeStringField("value", vp.toSerializableString(value));
            jgen.writeEndObject();
        }
        jgen.writeEndArray();
    }
}

