/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint;

public class ContinuousMappingSerializer
extends JsonSerializer<ContinuousMapping> {
    public Class<ContinuousMapping> handledType() {
        return ContinuousMapping.class;
    }

    public void serialize(ContinuousMapping mapping, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.useDefaultPrettyPrinter();
        jgen.writeStartObject();
        jgen.writeStringField("mappingType", "continuous");
        jgen.writeStringField("mappingColumn", mapping.getMappingColumnName());
        jgen.writeStringField("mappingColumnType", mapping.getMappingColumnType().getSimpleName());
        jgen.writeStringField("visualProperty", mapping.getVisualProperty().getIdString());
        this.serializePoints(mapping, jgen);
        jgen.writeEndObject();
    }

    private final void serializePoints(ContinuousMapping mapping, JsonGenerator jgen) throws IOException {
        VisualProperty vp = mapping.getVisualProperty();
        jgen.writeArrayFieldStart("points");
        List points = mapping.getAllPoints();
        for (ContinuousMappingPoint point : points) {
            jgen.writeStartObject();
            Number val = (Number)point.getValue();
            jgen.writeNumberField("value", val.doubleValue());
            BoundaryRangeValues range = point.getRange();
            jgen.writeStringField("lesser", vp.toSerializableString(range.lesserValue));
            jgen.writeStringField("equal", vp.toSerializableString(range.equalValue));
            jgen.writeStringField("greater", vp.toSerializableString(range.greaterValue));
            jgen.writeEndObject();
        }
        jgen.writeEndArray();
    }
}

