/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.rest.internal.CyActivator;
import org.cytoscape.rest.internal.model.CytoPanelModel;
import org.cytoscape.rest.internal.model.DesktopAvailableModel;
import org.cytoscape.rest.internal.model.MessageModel;
import org.cytoscape.rest.internal.resource.AbstractResource;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"User Interface"})
@Singleton
@Path(value="/v1/ui")
public class UIResource
extends AbstractResource {
    static final String RESOURCE_URN = "ui";
    private static final Logger logger = LoggerFactory.getLogger(UIResource.class);
    public static final int INTERNAL_METHOD_ERROR = 1;
    @Inject
    @NotNull
    protected CySwingApplication desktop;
    @Inject
    @NotNull
    protected CyActivator.LevelOfDetails detailsTF;
    @Inject
    @NotNull
    private TaskMonitor headlessTaskMonitor;

    @Override
    public String getResourceURI() {
        return RESOURCE_URN;
    }

    @Override
    public Logger getResourceLogger() {
        return logger;
    }

    @GET
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Get status of Desktop", notes="Returns the status of the Desktop", response=DesktopAvailableModel.class)
    public Map<String, Boolean> getDesktop() {
        HashMap<String, Boolean> status = new HashMap<String, Boolean>();
        boolean desktopAvailable = false;
        if (this.desktop != null) {
            desktopAvailable = true;
        }
        status.put("isDesktopAvailable", desktopAvailable);
        return status;
    }

    @PUT
    @Path(value="/lod")
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Toggle level of graphics details (LoD)", notes="Switch between full graphics details <---> fast rendering mode.\n\nReturns a success message.")
    public MessageModel updateLodState() {
        CyNetworkView view = this.applicationManager.getCurrentNetworkView();
        TaskIterator lod = this.detailsTF.getLodTF().createTaskIterator(view);
        try {
            lod.next().run(this.headlessTaskMonitor);
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 1, "Could not toggle LOD.", logger, e);
        }
        return new MessageModel("Toggled Graphics level of details.");
    }

    @GET
    @Path(value="/panels")
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Get status of all CytoPanels", notes="Returns all CytoPanels and their statuses.", response=CytoPanelModel.class, responseContainer="List")
    public List<Map<String, String>> getAllPanelStatus() {
        try {
            return Arrays.asList(CytoPanelName.values()).stream().map(panelName -> this.desktop.getCytoPanel(panelName)).map(panel -> this.getMap((CytoPanel)panel)).collect(Collectors.toList());
        }
        catch (Exception ex) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 1, "Could not get panel status.", logger, ex);
        }
    }

    private final Map<String, String> getMap(CytoPanel panel) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("name", panel.getCytoPanelName().name());
        values.put("state", panel.getState().name());
        return values;
    }

    @GET
    @Path(value="/panels/{panelName}")
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Get status of a CytoPanel", notes="Returns the status of the CytoPanel specified by the `panelName` parameter.", response=CytoPanelModel.class)
    public Response getPanelStatus(@ApiParam(value="Name of the CytoPanel") @PathParam(value="panelName") String panelName) {
        CytoPanelName panel = CytoPanelName.valueOf((String)panelName);
        if (panel == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        CytoPanel panelObject = this.desktop.getCytoPanel(panel);
        return Response.ok(this.getMap(panelObject)).build();
    }

    @PUT
    @Path(value="/panels")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update CytoPanel states", notes="Updates the status(es) of available CytoPanels.")
    @ApiImplicitParams(value={@ApiImplicitParam(value="A list of CytoPanels with states.", dataType="[Lorg.cytoscape.rest.internal.model.CytoPanelModel;", paramType="body", required=true)})
    public Response updatePanelStatus(@ApiParam(hidden=true) InputStream is) {
        ObjectMapper objMapper = new ObjectMapper();
        JsonNode rootNode = null;
        try {
            rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 1, "Could not parse input JSON.", logger, null);
        }
        for (JsonNode entry : rootNode) {
            JsonNode panelName = entry.get("name");
            JsonNode panelStatus = entry.get("state");
            if (panelName == null || panelStatus == null) {
                throw new IllegalArgumentException("Imput parameters are missing.");
            }
            CytoPanelName panel = CytoPanelName.valueOf((String)panelName.asText());
            if (panel == null) {
                throw new IllegalArgumentException("Could not find panel: " + panelName.asText());
            }
            CytoPanelState state = CytoPanelState.valueOf((String)panelStatus.asText());
            if (state == null) {
                throw new IllegalArgumentException("Invalid Panel State: " + panelStatus.asText());
            }
            CytoPanel panelObject = this.desktop.getCytoPanel(panel);
            if (state == CytoPanelState.HIDE && panelObject.getState() == CytoPanelState.FLOAT) {
                panelObject.setState(CytoPanelState.DOCK);
            }
            panelObject.setState(state);
        }
        return Response.ok().build();
    }
}

