/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.rest.internal.datamapper.TableMapper;
import org.cytoscape.rest.internal.model.CyColumnModel;
import org.cytoscape.rest.internal.model.CyColumnValuesModel;
import org.cytoscape.rest.internal.model.CyRowModel;
import org.cytoscape.rest.internal.model.CyTableWithRowsModel;
import org.cytoscape.rest.internal.resource.AbstractResource;
import org.cytoscape.rest.internal.serializer.CyTableSerializer;
import org.cytoscape.rest.internal.serializer.TableModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Tables"})
@Singleton
@Path(value="/v1/networks/{networkId}/tables")
public class TableResource
extends AbstractResource {
    static final int NETWORK_NOT_FOUND_ERROR = 1;
    static final int TABLE_NOT_FOUND_ERROR = 2;
    static final int COLUMN_NOT_FOUND_ERROR = 3;
    static final int ROW_NOT_FOUND_ERROR = 4;
    static final int INVALID_PARAMETER_ERROR = 5;
    static final int SERIALIZATION_ERROR = 6;
    static final int INTERNAL_METHOD_ERROR = 7;
    static final String RESOURCE_URN = "networks:tables";
    private static final Logger logger = LoggerFactory.getLogger(TableResource.class);
    public static final String ROW_EXAMPLE = "A row contains one or more entries of column names to values.\n\n```json\n{\n  \"SUID\": 101,\n  \"gene_name\": \"brca1\",\n  \"exp\": 0.1\n}\n```";
    public static final String ROW_ARRAY_EXAMPLE = "```\n[\n  {\n    \"SUID\": 101,\n    \"gene_name\": \"brca1\",\n    \"exp\": 0.1\n  },\n  {\n    \"SUID\": 102,\n    \"gene_name\": \"brca2\",\n    \"exp\": 0.2\n  }\n]\n```";
    private final TableMapper tableMapper = new TableMapper();
    private final ObjectMapper tableObjectMapper = new ObjectMapper();
    private final CyTableSerializer tableSerializer;

    @Override
    public String getResourceURI() {
        return RESOURCE_URN;
    }

    @Override
    public Logger getResourceLogger() {
        return logger;
    }

    public TableResource() {
        this.tableObjectMapper.registerModule((Module)new TableModule());
        this.tableSerializer = new CyTableSerializer();
    }

    @POST
    @Path(value="/{tableType}/columns")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Create new column(s) in the table", notes="Creates a new, empty column in the table specified by the `tableType` parameter, in the network specified by the `networkId` parameter.\n\nThis resource can also accept an array of new columns to create multiple columns.")
    @ApiImplicitParams(value={@ApiImplicitParam(value="New Column Info", dataType="org.cytoscape.rest.internal.model.NewColumnParameterModel", paramType="body", required=true)})
    @ApiResponses(value={@ApiResponse(code=201, message="Column(s) createed"), @ApiResponse(code=412, message="Could not process column JSON")})
    public Response createColumn(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="Table Type", allowableValues="defaultnode,defaultedge,defaultnetwork") @PathParam(value="tableType") String tableType, @ApiParam(hidden=true) InputStream is) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyTable table = this.getTableByType(network, tableType, null);
        CyTable localTable = this.getTableByType(network, tableType, "local");
        ObjectMapper objMapper = new ObjectMapper();
        JsonNode rootNode = null;
        try {
            rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not process column JSON.", logger, e);
        }
        if (rootNode.isArray()) {
            for (JsonNode node : rootNode) {
                this.tableMapper.createNewColumn(node, table, localTable);
            }
        } else {
            this.tableMapper.createNewColumn(rootNode, table, localTable);
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @DELETE
    @Path(value="/{tableType}/columns/{columnName}")
    @ApiOperation(value="Delete a column in a table", notes="Deletes the column specified by the `columnName` parameter from the table speficied by the `tableType` and `networkId` parameters.")
    public Response deleteColumn(@ApiParam(value="SUID of the network containing the table from which to delete the column") @PathParam(value="networkId") Long networkId, @ApiParam(value="Table Type from which to delete the column", allowableValues="defaultnode,defaultedge,defaultnetwork") @PathParam(value="tableType") String tableType, @ApiParam(value="Name of the column to delete") @PathParam(value="columnName") String columnName) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyTable table = this.getTableByType(network, tableType, null);
        if (table != null) {
            table.deleteColumn(columnName);
            return Response.ok().build();
        }
        logger.error("Failed to delete a column. (Missing table?)");
        throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 2, "Could not find the table.  (This should not happen!)", logger, null);
    }

    @PUT
    @Path(value="/{tableType}/columns")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update a column name", notes="Renames an existing column in the table specified by the `tableType` and `networkId` parameters.")
    @ApiImplicitParams(value={@ApiImplicitParam(value="Old and new column name", dataType="org.cytoscape.rest.internal.model.RenameModel", paramType="body", required=true)})
    public Response updateColumnName(@ApiParam(value="SUID of the network containing the table") @PathParam(value="networkId") Long networkId, @ApiParam(value="Table Type", allowableValues="defaultnode,defaultedge,defaultnetwork") @PathParam(value="tableType") String tableType, @ApiParam(hidden=true) InputStream is) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyTable table = this.getTableByType(network, tableType, null);
        ObjectMapper objMapper = new ObjectMapper();
        JsonNode rootNode = null;
        try {
            rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not parse the input JSON for updating column name.", logger, e);
        }
        try {
            this.tableMapper.updateColumnName(rootNode, table);
        }
        catch (IllegalArgumentException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, e.getMessage(), logger, e);
        }
        catch (TableMapper.ColumnNotFoundException e) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 3, e.getMessage(), logger, e);
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="/{tableType}/columns/{columnName}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update values in a column", notes="Sets the values for cells in the table specified by the `tableType` and `networkId` parameters.\n\nIf the 'default` parameter is not specified, the message body should consist of key-value pairs with which to set values.\n\nIf the `default` parameter is specified, its value will be used for every cell in the column. This is useful to set columns like \"selected.\"")
    @ApiImplicitParams(value={@ApiImplicitParam(value="Array of SUID Keyed values", dataType="[Lorg.cytoscape.rest.internal.model.SUIDKeyValueModel;", paramType="body", required=true)})
    public Response updateColumnValues(@ApiParam(value="SUID of the network containing the table") @PathParam(value="networkId") Long networkId, @ApiParam(value="The type of table", allowableValues="defaultnode,defaultedge,defaultnetwork") @PathParam(value="tableType") String tableType, @ApiParam(value="Name of the column in which to set values") @PathParam(value="columnName") String columnName, @ApiParam(value="Default Value. If this value is provided, all cells will be set to this.", required=false) @QueryParam(value="default") String defaultValue, @ApiParam(hidden=true) InputStream is) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyTable table = this.getTableByType(network, tableType, null);
        if (defaultValue != null) {
            this.tableMapper.updateAllColumnValues(defaultValue, table, columnName);
        } else {
            ObjectMapper objMapper = new ObjectMapper();
            JsonNode rootNode = null;
            try {
                rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
            }
            catch (IOException e) {
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not parse the input JSON for updating column values.", logger, e);
            }
            this.tableMapper.updateColumnValues(rootNode, table, columnName);
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="/{tableType}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update default node/edge/network data table", notes="Updates the table specified by the `tableType` and `networkId` parameters.  New columns will be created if they do not exist in the target table.\n\nCurrent limitations:\n* Numbers are handled as Double\n* List columns must be valid, and of non-zero length, with no nulls or heterogenous content.\n")
    @ApiImplicitParams(value={@ApiImplicitParam(value="The data with which to update the table.", dataType="org.cytoscape.rest.internal.model.UpdateTableModel", paramType="body", required=true)})
    public Response updateTable(@ApiParam(value="SUID containing the table") @PathParam(value="networkId") Long networkId, @ApiParam(value="Type of table", allowableValues="defaultnode,defaultedge,defaultnetwork") @PathParam(value="tableType") String tableType, @ApiParam(allowableValues="local", required=false) @QueryParam(value="class") String tableClass, @ApiParam(hidden=true) InputStream is) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyTable table = this.getTableByType(network, tableType, tableClass);
        ObjectMapper objMapper = new ObjectMapper();
        JsonNode rootNode = null;
        try {
            rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, "Could not parse the input JSON for updating table because: " + e.getMessage(), logger, e);
        }
        try {
            this.tableMapper.updateTableValues(rootNode, table);
        }
        catch (IllegalArgumentException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 5, e.getMessage(), logger, e);
        }
        catch (TableMapper.ColumnNotFoundException e) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 3, e.getMessage(), logger, e);
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/{tableType}/rows/{primaryKey}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a row in the table", notes="Gets a row matching the value specified by the `primaryKey` parameter from the table specified by the `tableType` and `networkId` parameters.\n\nData is represented by column names and their values.\n\n```json\n{\n  \"name\": \"Hodor 1\",\n  \"value\": 0.11,\n  \"matched\": false\n  ...\n}\n```", response=CyRowModel.class)
    public String getRow(@ApiParam(value="SUID of the network containing the table") @PathParam(value="networkId") Long networkId, @ApiParam(value="Table type", allowableValues="defaultnode,defaultedge,defaultnetwork") @PathParam(value="tableType") String tableType, @ApiParam(value="Primary key of the row Object, normally an SUID") @PathParam(value="primaryKey") Long primaryKey) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyTable table = this.getTableByType(network, tableType, null);
        if (!table.rowExists((Object)primaryKey)) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 4, "Could not find the row with primary key: " + primaryKey, logger, null);
        }
        CyRow row = table.getRow((Object)primaryKey);
        try {
            return this.serializer.serializeRow(row);
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 6, "Could not serialize a row with primary key: " + primaryKey, logger, e);
        }
    }

    @GET
    @Path(value="/{tableType}/rows/{primaryKey}/{columnName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a value from a cell", notes="Return the value of a cell specified by the `primaryKey` and `columnName` parameters in the table specified by the `tableType` and `networkId` parameters.\n\nReturns a JSON representation of a String, Boolean, Number, or List.")
    public Object getCell(@ApiParam(value="SUID of the network containing the table") @PathParam(value="networkId") Long networkId, @ApiParam(value="Table type", allowableValues="defaultnode,defaultedge,defaultnetwork") @PathParam(value="tableType") String tableType, @ApiParam(value="Primary key of the row Object, normally an SUID") @PathParam(value="primaryKey") Long primaryKey, @ApiParam(value="Name of the Column") @PathParam(value="columnName") String columnName) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyTable table = this.getTableByType(network, tableType, null);
        if (!table.rowExists((Object)primaryKey)) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 4, "Could not find the row with primary key: " + primaryKey, logger, null);
        }
        CyColumn column = table.getColumn(columnName);
        if (column == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 3, "Could not find the column: " + columnName, logger, null);
        }
        CyRow row = table.getRow((Object)primaryKey);
        if (column.getType() == List.class) {
            List listCell = row.getList(columnName, column.getListElementType());
            if (listCell == null) {
                throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 4, "Could not find list value for row with primary key: " + primaryKey, logger, null);
            }
            return listCell;
        }
        Object cell = row.get(columnName, column.getType());
        if (cell == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 4, "Could not find value for row with primary key: " + primaryKey, logger, null);
        }
        if (column.getType() == String.class) {
            return cell.toString();
        }
        return cell;
    }

    @GET
    @Path(value="/{tableType}/rows")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all rows in a table", notes="Returns all rows from the table specified by `networkId` and `tableType` parameters. Returns a JSON representation of an array of rows.\n\n```\n[\n  {\n    \"SUID\": 101,\n    \"gene_name\": \"brca1\",\n    \"exp\": 0.1\n  },\n  {\n    \"SUID\": 102,\n    \"gene_name\": \"brca2\",\n    \"exp\": 0.2\n  }\n]\n```", response=CyRowModel.class, responseContainer="List")
    public String getRows(@ApiParam(value="SUID of the network containing the table") @PathParam(value="networkId") Long networkId, @ApiParam(value="Table Type", allowableValues="defaultnode,defaultedge,defaultnetwork") @PathParam(value="tableType") String tableType) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyTable table = this.getTableByType(network, tableType, null);
        try {
            return this.serializer.serializeAllRows(table.getAllRows());
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 6, "Could not serialize rows.", logger, e);
        }
    }

    @GET
    @Path(value="/{tableType}/columns")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all columns in a table", notes="Returns all the columns in the table specified by the `networkId` and `tableType` parameters.", response=CyColumnModel.class, responseContainer="List")
    public String getColumnNames(@ApiParam(value="SUID of the network containing the table") @PathParam(value="networkId") Long networkId, @ApiParam(value="Table Type", allowableValues="defaultnode,defaultedge,defaultnetwork") @PathParam(value="tableType") String tableType) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyTable table = this.getTableByType(network, tableType, null);
        try {
            return this.serializer.serializeColumns(table.getColumns());
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 6, "Could not serialize column names.", logger, e);
        }
    }

    @GET
    @Path(value="/{tableType}/columns/{columnName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all values in a column", notes="Returns all the values for the column specified by the `columnType` parameter, in the table specified by the `networkId` and `tableType` parameters.", response=CyColumnValuesModel.class)
    public String getColumnValues(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(value="Type of Table", allowableValues="defaultnode,defaultedge,defaultnetwork") @PathParam(value="tableType") String tableType, @ApiParam(value="Name of the Column") @PathParam(value="columnName") String columnName) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyTable table = this.getTableByType(network, tableType, null);
        CyColumn column = table.getColumn(columnName);
        List values = column.getValues(column.getType());
        try {
            return this.serializer.serializeColumnValues(column, values);
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 6, "Could not serialize column names.", logger, e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all Tables assigned to the Network", notes="Returns every table in the network specified by the `networkId` parameter.", response=CyTableWithRowsModel.class, responseContainer="List")
    public String getTables(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId) {
        Set tables = this.tableManager.getAllTables(true);
        try {
            return this.tableObjectMapper.writeValueAsString((Object)tables);
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 6, "Could not serialize tables.", logger, e);
        }
    }

    private final CyTable getTableByType(CyNetwork network, String tableType, String tableClass) {
        CyTable table;
        Boolean isLocal = tableClass == null || tableClass.isEmpty() ? Boolean.valueOf(false) : (tableClass.equals("local") ? Boolean.valueOf(true) : Boolean.valueOf(false));
        if (tableType.equals(TableType.DEFAULT_NODE.getType())) {
            table = isLocal.booleanValue() ? network.getTable(CyNode.class, "LOCAL_ATTRS") : network.getDefaultNodeTable();
        } else if (tableType.equals(TableType.DEFAULT_EDGE.getType())) {
            table = isLocal.booleanValue() ? network.getTable(CyEdge.class, "LOCAL_ATTRS") : network.getDefaultEdgeTable();
        } else if (tableType.equals(TableType.DEFAULT_NETWORK.getType())) {
            table = isLocal.booleanValue() ? network.getTable(CyNetwork.class, "LOCAL_ATTRS") : network.getDefaultNetworkTable();
        } else {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 2, "No such table type: " + tableType, logger, null);
        }
        return table;
    }

    @GET
    @Path(value="/{tableType}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a default table", notes="Returns the table specified by the `networkId` and 'tableType' parameters.", response=CyTableWithRowsModel.class)
    public String getTable(@ApiParam(value="SUID of the network containing the table") @PathParam(value="networkId") Long networkId, @ApiParam(value="Table type", allowableValues="defaultnode,defaultedge,defaultnetwork") @PathParam(value="tableType") String tableType) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyTable table = this.getTableByType(network, tableType, null);
        try {
            return this.tableObjectMapper.writeValueAsString((Object)table);
        }
        catch (JsonProcessingException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 6, "Could not serialize table.", logger, (Exception)((Object)e));
        }
    }

    @GET
    @Path(value="/{tableType}.csv")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get a table as CSV", notes="Returns a CSV representation of the table specified by the `networkId` and `tableType` parameters. All column names are included in the first row.")
    public String getTableAsCsv(@ApiParam(value="SUID of the network containing the table") @PathParam(value="networkId") Long networkId, @ApiParam(value="Table type", allowableValues="defaultnode,defaultedge,defaultnetwork") @PathParam(value="tableType") String tableType) {
        return this.getTableString(networkId, tableType, ",");
    }

    @GET
    @Path(value="/{tableType}.tsv")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get a table as TSV (tab delimited text)", notes="Returns a TSV (tab delimited text) representation of the table specified by the `networkId` and `tableType` parameters. All column names are included in the first row.")
    public String getTableAsTsv(@ApiParam(value="SUID of the network containing the table") @PathParam(value="networkId") Long networkId, @ApiParam(value="Table type", allowableValues="defaultnode,defaultedge,defaultnetwork") @PathParam(value="tableType") String tableType) {
        return this.getTableString(networkId, tableType, "\t");
    }

    private final String getTableString(Long networkId, String tableType, String separator) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyTable table = this.getTableByType(network, tableType, null);
        try {
            String result = this.tableSerializer.toCSV(table, separator);
            return result;
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 6, "Could not serialize table into CSV.", logger, e);
        }
    }

    private static enum TableType {
        DEFAULT_NODE("defaultnode"),
        DEFAULT_EDGE("defaultedge"),
        DEFAULT_NETWORK("defaultnetwork");

        private final String type;

        private TableType(String type) {
            this.type = type;
        }

        private String getType() {
            return this.type;
        }
    }
}

