/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.cytoscape.ci.model.CIResponse;
import org.cytoscape.io.read.AbstractCyNetworkReader;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.io.read.InputStreamTaskFactory;
import org.cytoscape.io.write.CyNetworkViewWriterFactory;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.rest.internal.model.CountModel;
import org.cytoscape.rest.internal.model.CreatedCyEdgeModel;
import org.cytoscape.rest.internal.model.EdgeModel;
import org.cytoscape.rest.internal.model.NetworkSUIDModel;
import org.cytoscape.rest.internal.model.NetworkViewSUIDModel;
import org.cytoscape.rest.internal.model.NodeModel;
import org.cytoscape.rest.internal.model.SUIDNameModel;
import org.cytoscape.rest.internal.resource.AbstractResource;
import org.cytoscape.rest.internal.task.HeadlessTaskMonitor;
import org.cytoscape.task.AbstractNetworkCollectionTask;
import org.cytoscape.task.select.SelectFirstNeighborsTaskFactory;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Networks"})
@Singleton
@Path(value="/v1/networks")
public class NetworkResource
extends AbstractResource {
    private static final String CX_READER_ID = "cytoscapeCxNetworkReaderFactory";
    private static final String CX2_READER_ID = "cytoscapeCx2NetworkReaderFactory";
    private static final String CX_FORMAT = "cx";
    private static final String CX2_FORMAT = "cx2";
    private static final String RESOURCE_URN = "networks";
    private static final Logger logger = LoggerFactory.getLogger(NetworkResource.class);
    @Inject
    protected SelectFirstNeighborsTaskFactory selectFirstNeighborsTaskFactory;
    @Inject
    @NotNull
    private CyLayoutAlgorithmManager layoutManager;

    @Override
    public String getResourceURI() {
        return RESOURCE_URN;
    }

    @Override
    public Logger getResourceLogger() {
        return logger;
    }

    @GET
    @Path(value="/count")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get number of networks in current session", notes="Returns the number of networks in current Cytoscape session.", response=CountModel.class)
    public Response getNetworkCount() {
        String result = this.getNumberObjectString(9, "count", this.networkManager.getNetworkSet().size());
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/currentNetwork")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the current network", notes="Returns the current network.", response=NetworkSUIDResponse.class)
    public Response getCurrentNetwork() {
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        if (network == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 1, "No current network available", logger, null);
        }
        NetworkSUIDModel entity = new NetworkSUIDModel(network.getSUID());
        return Response.ok((Object)this.ciResponseFactory.getCIResponse((Object)entity)).build();
    }

    @PUT
    @Path(value="/currentNetwork")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Set the current network", notes="Sets the current network.", response=CIResponse.class)
    public Response setCurrentNetwork(@ApiParam(value="SUID of the Network") NetworkSUIDModel networkSUIDModel) {
        if (networkSUIDModel == null || networkSUIDModel.networkSUID == null) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 7, "Missing or invalid message body.", logger, null);
        }
        CyNetwork network = this.getCyNetwork(1, networkSUIDModel.networkSUID);
        this.applicationManager.setCurrentNetwork(network);
        return Response.ok((Object)this.ciResponseFactory.getCIResponse(new Object())).build();
    }

    @PUT
    @Path(value="/views/currentNetworkView")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Set the current Network View", notes="Sets the current Network View.", response=CIResponse.class, tags={"Network Views"})
    public Response setCurrentNetworkView(@ApiParam(value="SUID of the Network View") NetworkViewSUIDModel networkViewSUIDModel) {
        if (networkViewSUIDModel == null || networkViewSUIDModel.networkViewSUID == null) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 7, "Missing or invalid message body.", logger, null);
        }
        CyNetworkView networkView = null;
        Set cyNetworks = this.networkManager.getNetworkSet();
        if (cyNetworks != null) {
            for (CyNetwork cyNetwork : cyNetworks) {
                Collection views = this.networkViewManager.getNetworkViews(cyNetwork);
                for (CyNetworkView view : views) {
                    Long vid = view.getSUID();
                    if (!vid.equals(networkViewSUIDModel.networkViewSUID)) continue;
                    networkView = view;
                }
            }
        }
        if (networkView == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), RESOURCE_URN, 6, "Could not find view matching SUID:" + networkViewSUIDModel.networkViewSUID, logger, null);
        }
        this.applicationManager.setCurrentNetworkView(networkView);
        return Response.ok((Object)this.ciResponseFactory.getCIResponse(new Object())).build();
    }

    @GET
    @Path(value="/views/currentNetworkView")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the current Network View", notes="Returns the current Network View.", response=NetworkViewSUIDResponse.class, tags={"Network Views"})
    public Response getCurrentNetworkView() {
        CyNetworkView network = this.applicationManager.getCurrentNetworkView();
        if (network == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), "networks:views", 2, "No current network view available", logger, null);
        }
        NetworkViewSUIDModel entity = new NetworkViewSUIDModel(network.getSUID());
        return Response.ok((Object)this.ciResponseFactory.getCIResponse((Object)entity)).build();
    }

    @GET
    @Path(value="/{networkId}.cx")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a Network in CX format", notes="Returns the Network specified by the `networkId` parameters in [CX format](https://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#cytoscape-cx)")
    public Response getNetworkAsCx(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId, @ApiParam(hidden=true, value="File (unused)") @QueryParam(value="file") String file, @ApiParam(value="CX version, either '1' or '2'") @DefaultValue(value="1") @QueryParam(value="version") String cxVersion) throws Exception {
        PipedOutputStream out;
        CyNetwork network = this.networkManager.getNetwork(networkId.longValue());
        boolean isCX2 = cxVersion.equals("2");
        CyNetworkViewWriterFactory cxWriterFactory = this.viewWriterFactoryManager.getFactory(isCX2 ? "cx2NetworkWriterFactory" : "cxNetworkWriterFactory");
        if (cxWriterFactory == null) {
            throw this.getCIWebApplicationException(Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), this.getResourceURI(), 10, "CX writer is not available.  Please install CX Support App to use this API.", this.getResourceLogger(), null);
        }
        PipedInputStream pin = new PipedInputStream();
        try {
            out = new PipedOutputStream(pin);
        }
        catch (IOException e) {
            try {
                pin.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw new Exception("IOExcetion when creating the piped output stream: " + e.getMessage());
        }
        new CXSubNetWriterThread(out, network, cxWriterFactory).start();
        return Response.ok().entity((Object)pin).build();
    }

    @GET
    @Path(value="/{networkId}/nodes/count")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get number of nodes in the network", notes="Returns the number of nodes in the network specified by the `networkId` parameter.", response=CountModel.class)
    public Response getNodeCount(@ApiParam(value="SUID of the network containing the nodes") @PathParam(value="networkId") Long networkId) {
        String result = this.getNumberObjectString(9, "count", this.getCyNetwork(1, networkId).getNodeCount());
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/{networkId}/edges/count")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get number of edges in the network", notes="Returns the number of edges in the network specified by the `networkId` parameter.", response=CountModel.class)
    public Response getEdgeCount(@ApiParam(value="SUID of the network containing the edges") @PathParam(value="networkId") Long networkId) {
        String result = this.getNumberObjectString(9, "count", this.getCyNetwork(1, networkId).getEdgeCount());
        return Response.ok((Object)result).build();
    }

    @GET
    @Produces(value={"application/json; charset=UTF-8"})
    @ApiOperation(value="Get SUID list of networks", notes="Returns a list of all networks as SUIDs.\n\nIf the `column` and `query` parameters are specified, the results will be limited to rows in the network table where the value in the column specified by the `column` parameter matches the value specified by the `query` parameter.")
    public Collection<Long> getNetworksAsSUID(@ApiParam(value="The name of the column that will be queried for matches.", required=false) @QueryParam(value="column") String column, @ApiParam(value="The value to be matched.", required=false) @QueryParam(value="query") String query) {
        Set<Object> networks = new HashSet();
        if (column == null && query == null) {
            networks = this.networkManager.getNetworkSet();
        } else {
            try {
                networks = this.getNetworksByQuery(7, query, column);
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 8, "Error executing Network query.", this.getResourceLogger(), e);
            }
        }
        HashSet<Long> suids = new HashSet<Long>();
        for (CyNetwork cyNetwork : networks) {
            suids.add(cyNetwork.getSUID());
        }
        return suids;
    }

    @GET
    @Path(value="/{networkId}")
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Get a network in Cytoscape.js format", notes="Returns the Network specified by the `networkId` parameter with all associated tables in [Cytoscape.js](https://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#cytoscape-js-json) format")
    public String getNetwork(@ApiParam(value="SUID of the Network") @PathParam(value="networkId") Long networkId) {
        return this.getNetworkString(10, 9, this.getCyNetwork(1, networkId));
    }

    @GET
    @Path(value="/{networkId}/nodes")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get nodes", notes="Returns a list of all nodes in the network specified by the `networkId` parameter as SUIDs.\n\nIf the `column` and `query` parameters are specified, the results will be limited to rows in the node table where the value in the column specified by the `column` parameter matches the value specified by the `query` parameter.")
    public Collection<Long> getNodes(@ApiParam(value="SUID of the network containing the nodes") @PathParam(value="networkId") Long networkId, @ApiParam(value="The name of the column that will be queried for matches.", required=false) @QueryParam(value="column") String column, @ApiParam(value="The value to be matched.", required=false) @QueryParam(value="query") String query) {
        return this.getByQuery(1, 8, 7, networkId, "nodes", column, query);
    }

    @GET
    @Path(value="/{networkId}/nodes/selected")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get selected nodes", notes="Gets the selected nodes in the network specified by the `networkId` parameter. The results are presented as a list of SUIDs.")
    public Collection<Long> getSelectedNodes(@ApiParam(value="SUID of the network containing the nodes") @PathParam(value="networkId") Long networkId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)network, (String)"selected", (boolean)true);
        List<Long> selectedNodeIds = selectedNodes.stream().map(node -> node.getSUID()).collect(Collectors.toList());
        return selectedNodeIds;
    }

    @PUT
    @Path(value="/{networkId}/nodes/selected")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Set selected nodes", notes="Sets as selected the nodes specified by the `suids` and `networkId` parameters.\n\nReturns a list of selected SUIDs.")
    public Collection<Long> setSelectedNodes(@ApiParam(value="SUID of the network containing the nodes") @PathParam(value="networkId") Long networkId, @ApiParam(value="Array of node SUIDs to select") Collection<Double> suids) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyTable table = network.getDefaultNodeTable();
        return this.setSelected(network, table, suids);
    }

    private Collection<Long> setSelected(CyNetwork network, CyTable table, Collection<Double> suids) {
        for (CyRow row : table.getAllRows()) {
            row.set("selected", (Object)false);
        }
        HashSet<Long> output = new HashSet<Long>();
        for (Double suid : suids) {
            if (table.rowExists((Object)suid.longValue())) {
                CyRow row = table.getRow((Object)suid.longValue());
                row.set("selected", (Object)true);
                output.add(suid.longValue());
                continue;
            }
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 8, "SUID " + suid + " cannot be found in table.", this.getResourceLogger(), null);
        }
        return output;
    }

    @GET
    @Path(value="/{networkId}/nodes/selected/neighbors")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all neighbors of the selected nodes", notes="Returns the neighbors of the nodes currently selected in the network specified by the `networkId` parameter as a list of SUIDs.\n\nNote that this does not include the nodes in the original selection.")
    public Collection<Long> getNeighborsSelected(@ApiParam(value="SUID of the network") @PathParam(value="networkId") Long networkId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)network, (String)"selected", (boolean)true);
        Set<Long> res = selectedNodes.stream().map(node -> network.getNeighborList(node, CyEdge.Type.ANY)).flatMap(Collection::stream).map(neighbor -> neighbor.getSUID()).collect(Collectors.toSet());
        return res;
    }

    @GET
    @Path(value="/{networkId}/edges/selected")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get selected edges", notes="Gets the selected edges in the network specified by the `networkId` parameter. The results are presented as a list of SUIDs.")
    public Collection<Long> getSelectedEdges(@ApiParam(value="SUID of the network containing the edges") @PathParam(value="networkId") Long networkId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        List selectedEdges = CyTableUtil.getEdgesInState((CyNetwork)network, (String)"selected", (boolean)true);
        List<Long> selectedEdgeIds = selectedEdges.stream().map(edge -> edge.getSUID()).collect(Collectors.toList());
        return selectedEdgeIds;
    }

    @PUT
    @Path(value="/{networkId}/edges/selected")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Set selected edges", notes="Sets as selected the edges specified by the `suids` and `networkId` parameters.\n\nReturns a list of selected SUIDs.")
    public Collection<Long> setSelectedEdges(@ApiParam(value="SUID of the network containing the edges") @PathParam(value="networkId") Long networkId, @ApiParam(value="Array of edge SUIDs to select") Collection<Double> suids) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyTable table = network.getDefaultEdgeTable();
        return this.setSelected(network, table, suids);
    }

    @GET
    @Path(value="/{networkId}/edges")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get edges", notes="Returns a list of all edges in the network specified by the `networkId` parameter as SUIDs.\n\nIf the `column` and `query` parameters are specified, the results will be limited to rows in the edge table where the value in the column specified by the `column` parameter matches the value specified by the `query` parameter.")
    public Collection<Long> getEdges(@ApiParam(value="SUID of the network containing the edges") @PathParam(value="networkId") Long networkId, @ApiParam(value="The name of the column that will be queried for matches.", required=false) @QueryParam(value="column") String column, @ApiParam(value="The value to be matched.", required=false) @QueryParam(value="query") String query) {
        return this.getByQuery(1, 8, 7, networkId, "edges", column, query);
    }

    @GET
    @Path(value="/{networkId}/nodes/{nodeId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a node", notes="Returns a node with its associated row data.", response=NodeModel.class)
    public String getNode(@ApiParam(value="SUID of the network containing the node") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the node") @PathParam(value="nodeId") Long nodeId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyNode node = network.getNode(nodeId.longValue());
        if (node == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 3, "Could not find Node with SUID: " + nodeId, this.getResourceLogger(), null);
        }
        return this.getGraphObject(9, network, (CyIdentifiable)node);
    }

    @GET
    @Path(value="/{networkId}/edges/{edgeId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an edge", notes="Returns an edge with its associated row data.", response=EdgeModel.class)
    public String getEdge(@ApiParam(value="SUID of the network containing the edge") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the edge") @PathParam(value="edgeId") Long edgeId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyEdge edge = network.getEdge(edgeId.longValue());
        if (edge == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 2, "Could not find Edge with SUID: " + edgeId, this.getResourceLogger(), null);
        }
        return this.getGraphObject(9, network, (CyIdentifiable)edge);
    }

    @GET
    @Path(value="/{networkId}/edges/{edgeId}/{type}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get source/target node of an edge", notes="Returns the SUID of the source or target node of the edge specified by the `edgeId` and `networkId` parameters.\n\nReturn values can be in one of two formats, depending on the value specified in the `type` parameter:\n\n```\n{\n   \"source\": 101\n}\n```\n\n```\n{\n   \"target\": 102\n}\n```\n\n", response=Object.class)
    public String getEdgeComponent(@ApiParam(value="SUID of the network containing the edge") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the edge") @PathParam(value="edgeId") Long edgeId, @ApiParam(value="The node type to return", allowableValues="source,target") @PathParam(value="type") String type) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyEdge edge = network.getEdge(edgeId.longValue());
        if (edge == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 2, "Could not find Edge. SUID: " + edgeId, this.getResourceLogger(), null);
        }
        Long nodeSUID = null;
        if (type.equals("source")) {
            nodeSUID = edge.getSource().getSUID();
        } else if (type.equals("target")) {
            nodeSUID = edge.getTarget().getSUID();
        } else {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 5, "Invalid parameter for edge: " + type, this.getResourceLogger(), null);
        }
        return this.getNumberObjectString(9, type, nodeSUID);
    }

    @GET
    @Path(value="/{networkId}/edges/{edgeId}/isDirected")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get edge directionality", notes="Returns true if the edge specified by the `edgeId` and `networkId` parameters is directed.")
    public Boolean getEdgeDirected(@ApiParam(value="SUID of the network containing the edge") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the edge") @PathParam(value="edgeId") Long edgeId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyEdge edge = network.getEdge(edgeId.longValue());
        if (edge == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 2, "Could not find Edge. SUID: " + edgeId, this.getResourceLogger(), null);
        }
        return edge.isDirected();
    }

    @GET
    @Path(value="/{networkId}/nodes/{nodeId}/adjEdges")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get adjacent edges for a node", notes="Returns a list of connected edges as SUIDs for the node specified by the `nodeId` and `networkId` parameters.")
    public Collection<Long> getAdjEdges(@ApiParam(value="SUID of the network containing the node") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the node") @PathParam(value="nodeId") Long nodeId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyNode node = this.getNode(3, network, nodeId);
        List edges = network.getAdjacentEdgeList(node, CyEdge.Type.ANY);
        return this.getGraphObjectArray(edges);
    }

    @GET
    @Path(value="/{networkId}/nodes/{nodeId}/pointer")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get network pointer (nested network SUID)", notes="If the node specified by the `nodeId` and `networkId` parameters has an associated nested network, returns the SUID of the nested network.", response=NetworkSUIDModel.class)
    public NetworkSUIDModel getNetworkPointer(@ApiParam(value="SUID of the network containing the node") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the node") @PathParam(value="nodeId") Long nodeId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyNode node = this.getNode(3, network, nodeId);
        CyNetwork pointer = node.getNetworkPointer();
        if (pointer == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 4, "Could not find Network pointer", this.getResourceLogger(), null);
        }
        return new NetworkSUIDModel(pointer.getSUID());
    }

    @GET
    @Path(value="/{networkId}/nodes/{nodeId}/neighbors")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get neighbors of the node", notes="Returns the neighbors of the node specified by the `nodeId` and `networkId` parameters as a list of SUIDs.")
    public Collection<Long> getNeighbours(@ApiParam(value="SUID of the network containing the node.") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the node") @PathParam(value="nodeId") Long nodeId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyNode node = this.getNode(3, network, nodeId);
        List nodes = network.getNeighborList(node, CyEdge.Type.ANY);
        return this.getGraphObjectArray(nodes);
    }

    private final Collection<Long> getGraphObjectArray(Collection<? extends CyIdentifiable> objects) {
        return objects.stream().map(CyIdentifiable::getSUID).collect(Collectors.toList());
    }

    @POST
    @Path(value="/{networkId}/nodes")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add node(s) to a network", notes="Adds new nodes to the network specified by the `networkId` parameter. The `name` column will be populated by the contents of the message body.")
    @ApiImplicitParams(value={@ApiImplicitParam(value="Array of new node names", dataType="[Ljava.lang.String;", paramType="body", required=true)})
    @ApiResponses(value={@ApiResponse(code=201, message="", response=SUIDNameModel.class, responseContainer="List"), @ApiResponse(code=412, message="")})
    public Response createNode(@ApiParam(value="SUID of the network containing the node.") @PathParam(value="networkId") Long networkId, @ApiParam(hidden=true) InputStream is) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        ObjectMapper objMapper = new ObjectMapper();
        JsonNode rootNode = null;
        try {
            rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 7, "Could not parse input JSON", this.getResourceLogger(), e);
        }
        if (rootNode.isArray()) {
            JsonFactory factory = new JsonFactory();
            String result = null;
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                JsonGenerator generator = null;
                generator = factory.createGenerator((OutputStream)stream);
                generator.writeStartArray();
                for (JsonNode node : rootNode) {
                    String nodeName = node.textValue();
                    CyNode newNode = network.addNode();
                    network.getRow((CyIdentifiable)newNode).set("name", (Object)nodeName);
                    generator.writeStartObject();
                    generator.writeStringField("name", nodeName);
                    generator.writeNumberField("SUID", newNode.getSUID().longValue());
                    generator.writeEndObject();
                }
                generator.writeEndArray();
                generator.close();
                result = stream.toString("UTF-8");
                stream.close();
                this.updateViews(network);
            }
            catch (IOException e) {
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 9, "Could not create node list.", this.getResourceLogger(), e);
            }
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result).build();
        }
        throw this.getCIWebApplicationException(Response.Status.PRECONDITION_FAILED.getStatusCode(), this.getResourceURI(), 7, "Message body was not an array.", this.getResourceLogger(), null);
    }

    @POST
    @Path(value="/{networkId}/edges")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add edge(s) to existing network", notes="Add new edge(s) to the network.  Body should include an array of new node names.\n\nReturns and array of objects with fields itentifying the SUIDs of the new edges along with source and target SUIDs.", response=CreatedCyEdgeModel.class, responseContainer="List")
    @ApiImplicitParams(value={@ApiImplicitParam(value="Array of new edges", dataType="[Lorg.cytoscape.rest.internal.model.CreateCyEdgeParameterModel;", paramType="body", required=true)})
    public Response createEdge(@ApiParam(value="SUID of the network to add edges to.") @PathParam(value="networkId") Long networkId, @ApiParam(hidden=true) InputStream is) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        ObjectMapper objMapper = new ObjectMapper();
        JsonNode rootNode = null;
        try {
            rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.PRECONDITION_FAILED.getStatusCode(), this.getResourceURI(), 7, "Could not find root node in the given JSON.", this.getResourceLogger(), e);
        }
        if (rootNode.isArray()) {
            JsonFactory factory = new JsonFactory();
            String result = null;
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                JsonGenerator generator = null;
                generator = factory.createGenerator((OutputStream)stream);
                generator.writeStartArray();
                for (JsonNode node : rootNode) {
                    JsonNode source = node.get("source");
                    JsonNode target = node.get("target");
                    JsonNode interaction = node.get("interaction");
                    JsonNode isDirected = node.get("directed");
                    if (source == null || target == null) continue;
                    Long sourceSUID = source.asLong();
                    Long targetSUID = target.asLong();
                    CyNode sourceNode = network.getNode(sourceSUID.longValue());
                    CyNode targetNode = network.getNode(targetSUID.longValue());
                    CyEdge edge = isDirected != null ? network.addEdge(sourceNode, targetNode, isDirected.asBoolean()) : network.addEdge(sourceNode, targetNode, true);
                    String sourceName = (String)network.getRow((CyIdentifiable)sourceNode).get("name", String.class);
                    String targetName = (String)network.getRow((CyIdentifiable)targetNode).get("name", String.class);
                    String interactionString = interaction != null ? interaction.textValue() : "-";
                    network.getRow((CyIdentifiable)edge).set("interaction", (Object)interactionString);
                    network.getRow((CyIdentifiable)edge).set("name", (Object)(sourceName + " (" + interactionString + ") " + targetName));
                    generator.writeStartObject();
                    generator.writeNumberField("SUID", edge.getSUID().longValue());
                    generator.writeNumberField("source", sourceSUID.longValue());
                    generator.writeNumberField("target", targetSUID.longValue());
                    generator.writeEndObject();
                }
                generator.writeEndArray();
                generator.close();
                result = stream.toString("UTF-8");
                stream.close();
                this.updateViews(network);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 8, "Could not create edge.", this.getResourceLogger(), e);
            }
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result).build();
        }
        throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 7, "Need to POST as array.", this.getResourceLogger(), null);
    }

    @DELETE
    @ApiOperation(value="Delete all networks in current session", notes="Delete all networks in the current session.")
    public Response deleteAllNetworks() {
        this.networkViewManager.getNetworkViewSet().stream().forEach(networkView -> this.networkViewManager.destroyNetworkView(networkView));
        this.networkViewManager.reset();
        this.networkManager.getNetworkSet().stream().forEach(network -> this.networkManager.destroyNetwork(network));
        this.networkManager.reset();
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{networkId}")
    @ApiOperation(value="Delete a network", notes="Deletes the network specified by the `networkId` parameter.")
    public Response deleteNetwork(@ApiParam(value="SUID of the network to delete") @PathParam(value="networkId") Long networkId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        this.networkManager.destroyNetwork(network);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{networkId}/nodes")
    @ApiOperation(value="Delete all nodes in a network", notes="Delete all the nodes from the network specified by the `networkId` parameter.")
    public Response deleteAllNodes(@ApiParam(value="SUID of the network to delete nodes from") @PathParam(value="networkId") Long networkId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        network.removeNodes((Collection)network.getNodeList());
        this.updateViews(network);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{networkId}/edges")
    @ApiOperation(value="Delete all edges in a network", notes="Delete all the edges from the network specified by the `networkId` parameter.")
    public Response deleteAllEdges(@ApiParam(value="SUID of the network to delete edges from") @PathParam(value="networkId") Long networkId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        network.removeEdges((Collection)network.getEdgeList());
        this.updateViews(network);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{networkId}/nodes/{nodeId}")
    @ApiOperation(value="Delete a node in the network", notes="Deletes the node specified by the `nodeId` and `networkId` parameters.")
    public Response deleteNode(@ApiParam(value="SUID of the network containing the node.") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the node") @PathParam(value="nodeId") Long nodeId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyNode node = network.getNode(nodeId.longValue());
        if (node == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 3, "Could not find Node with SUID: " + nodeId, this.getResourceLogger(), null);
        }
        ArrayList<CyNode> nodes = new ArrayList<CyNode>();
        nodes.add(node);
        network.removeNodes(nodes);
        this.updateViews(network);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{networkId}/edges/{edgeId}")
    @ApiOperation(value="Delete an edge in the network.", notes="Deletes the edge specified by the `edgeId` and `networkId` parameters.")
    public Response deleteEdge(@ApiParam(value="SUID of the network containing the edge.") @PathParam(value="networkId") Long networkId, @ApiParam(value="SUID of the edge") @PathParam(value="edgeId") Long edgeId) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        CyEdge edge = network.getEdge(edgeId.longValue());
        if (edge == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 2, "Could not find Edge with SUID: " + edgeId, this.getResourceLogger(), null);
        }
        ArrayList<CyEdge> edges = new ArrayList<CyEdge>();
        edges.add(edge);
        network.removeEdges(edges);
        this.updateViews(network);
        return Response.ok().build();
    }

    private final void updateViews(CyNetwork network) {
        Collection views = this.networkViewManager.getNetworkViews(network);
        for (CyNetworkView view : views) {
            view.updateView();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new network from a file or URL", notes="Creates a new network in the current session from a file or URL source.\n\nDepending on the setting of the `format` parameter the source can be in one of several formats:\n\n| Format   | Details    |\n| -------- | -------    |\n| edgeList | [SIF](https://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#sif-format) format |\n| cx       | [CX](https://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#cytoscape-cx) format |\n| cx2      | [CX2](https://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#cytoscape-cx) format |\n| json     | [Cytoscape.js](https://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#cytoscape-js-json) format |\nIf the `source` parameter is left unspecified, the message body should contain data in the format specified by the `format` parameter.\n\n\nIf the `source` parameter is specified as \"url\", the message body should be a list of URLs, formatted as below:\n\n```\n[\n  {\n    \"source_location\": \"http://somewhere.com/graph.js\",\n\t   \"source_method\": \"GET\",\n\t   \"ndex_uuid\": \"12345\"\n  }\n  ...\n]\n```\nThe `source_location` field specifies the URL from which to get data, and the `source_method` field specifies the HTTP method to use. All entries should be in the format specified by the `format` parameter. All the fields in each entry will be copied to columns in the default network table row for the new network.", response=NetworkSUIDModel.class)
    public String createNetwork(@ApiParam(value="The name of the network collection to add new networks to. If the collection does not exist, it will be created.") @QueryParam(value="collection") String collection, @ApiParam(value="Set this to `url` to treat the message body as a list of urls.", allowableValues="url,", required=false) @QueryParam(value="source") String source, @ApiParam(value="The format of the source data.", allowableValues="edgelist,json,cx,cx2") @QueryParam(value="format") String format, @ApiParam(value="Name of the new network. This is only used if the network name cannot be set directly in source data.") @QueryParam(value="title") String title, @ApiParam(value="Source data. This is either the data to be loaded, or a list of URLs from which to load data.") InputStream is, @Context HttpHeaders headers) {
        TaskIterator it;
        this.applicationManager.setCurrentNetworkView(null);
        this.applicationManager.setCurrentNetwork(null);
        if (source != null && source.equals("url")) {
            try {
                return this.loadNetworks(format, collection, is);
            }
            catch (Exception e) {
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 11, "Could not load networks from given locations.", this.getResourceLogger(), e);
            }
        }
        List agent = headers.getRequestHeader("user-agent");
        String userAgent = "";
        if (agent != null) {
            userAgent = (String)agent.get(0);
        }
        String collectionName = null;
        if (collection != null) {
            collectionName = collection;
        }
        if (format != null && format.trim().equals("edgelist")) {
            it = this.edgeListReaderFactory.createTaskIterator(is, collection);
        } else if (format != null && format.equalsIgnoreCase(CX_FORMAT)) {
            readerFactory = this.tfManager.getInputStreamTaskFactory(CX_READER_ID);
            it = readerFactory.createTaskIterator(is, collection);
        } else if (format != null && format.equalsIgnoreCase(CX2_FORMAT)) {
            readerFactory = this.tfManager.getInputStreamTaskFactory(CX2_READER_ID);
            it = readerFactory.createTaskIterator(is, collection);
        } else {
            InputStreamTaskFactory cytoscapeJsReaderFactory = (InputStreamTaskFactory)this.cytoscapeJsReaderFactory.getService();
            if (cytoscapeJsReaderFactory == null) {
                throw this.getCIWebApplicationException(Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), this.getResourceURI(), 9, "No Cytoscape js reader available", this.getResourceLogger(), null);
            }
            it = cytoscapeJsReaderFactory.createTaskIterator(is, collection);
        }
        CyNetworkReader reader = (CyNetworkReader)it.next();
        try {
            reader.run((TaskMonitor)new HeadlessTaskMonitor());
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.PRECONDITION_FAILED.getStatusCode(), this.getResourceURI(), 7, "Could not parse the given network JSON: " + e.getMessage(), this.getResourceLogger(), e);
        }
        CyNetwork[] networks = reader.getNetworks();
        CyNetwork newNetwork = networks[0];
        if (title != null && !title.isEmpty()) {
            try {
                newNetwork.getTable(CyNetwork.class, "LOCAL_ATTRS").getRow((Object)newNetwork.getSUID()).set("name", (Object)title);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.addNetwork(networks, reader, collectionName);
        try {
            is.close();
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 8, "Could not close the network input stream.", this.getResourceLogger(), e);
        }
        return this.getNumberObjectString(9, "networkSUID", newNetwork.getSUID());
    }

    @POST
    @Path(value="/{networkId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a subnetwork from selected nodes and edges", notes="Creates new sub-network from current selection, with the name specified by the `title` parameter.\n\nReturns the SUID of the new sub-network.", response=NetworkSUIDModel.class)
    public String createNetworkFromSelected(@ApiParam(value="SUID of the network containing the selected nodes and edges") @PathParam(value="networkId") Long networkId, @ApiParam(value="Name for the new sub-network") @QueryParam(value="title") String title, @ApiParam(hidden=true) InputStream is, @Context HttpHeaders headers) {
        CyNetwork network = this.getCyNetwork(1, networkId);
        TaskIterator itr = this.newNetworkSelectedNodesAndEdgesTaskFactory.createTaskIterator(network);
        Object viewTask = null;
        while (itr.hasNext()) {
            Task task = itr.next();
            try {
                task.run((TaskMonitor)new HeadlessTaskMonitor());
                if (!(task instanceof AbstractNetworkCollectionTask)) continue;
                viewTask = (AbstractNetworkCollectionTask)task;
            }
            catch (Exception e) {
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 8, "Could not create sub network from selection.", this.getResourceLogger(), e);
            }
        }
        try {
            is.close();
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 9, "Could not close input stream.", this.getResourceLogger(), e);
        }
        if (viewTask != null) {
            try {
                Method method = viewTask.getClass().getMethod("getResults", Class.class);
                Collection result = (Collection)method.invoke(viewTask, Collection.class);
                if (result.size() == 1) {
                    CyNetwork newSubNetwork = (CyNetwork)((CyNetworkView)result.iterator().next()).getModel();
                    Long suid = newSubNetwork.getSUID();
                    if (title != null) {
                        newSubNetwork.getRow((CyIdentifiable)newSubNetwork).set("name", (Object)title);
                    }
                    return this.getNumberObjectString(9, "networkSUID", suid);
                }
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 8, "viewTask returned no networks.", this.getResourceLogger(), null);
            }
            catch (NoSuchMethodException e) {
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 8, "no method 'getResults(Class)' in viewTask.", this.getResourceLogger(), e);
            }
            catch (SecurityException e) {
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 8, "security exeception accessing 'getResults(Class)' in viewTask.", this.getResourceLogger(), e);
            }
            catch (IllegalAccessException e) {
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 8, "IllegalAccessException accessing 'getResults(Class)' in viewTask", this.getResourceLogger(), e);
            }
            catch (IllegalArgumentException e) {
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 8, "IllegalArgumentException accessing 'getResults(Class)' in viewTask", this.getResourceLogger(), e);
            }
            catch (InvocationTargetException e) {
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 8, "InvocationTargetException accessing 'getResults(Class)' in viewTask.", this.getResourceLogger(), e);
            }
        }
        System.err.println("viewTask was null");
        throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 8, "Could not get new network SUID", this.getResourceLogger(), null);
    }

    private final Map<String, Map<String, Object>> getNetworkProps(JsonNode root) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (JsonNode node : root) {
            String sourceUrl = null;
            if (node.isObject()) {
                Iterator names = node.fieldNames();
                HashMap<String, String> networkPropMap = new HashMap<String, String>();
                while (names.hasNext()) {
                    String name = (String)names.next();
                    if (name.equals("source_location")) {
                        sourceUrl = node.get(name).asText();
                    }
                    networkPropMap.put(name, node.get(name).asText());
                }
                if (sourceUrl == null) {
                    throw new IllegalArgumentException("Missing source");
                }
                result.put(sourceUrl, networkPropMap);
                continue;
            }
            sourceUrl = node.asText();
            result.put(sourceUrl, null);
        }
        return result;
    }

    private final String loadNetworks(String format, String collection, InputStream is) throws Exception {
        this.applicationManager.setCurrentNetworkView(null);
        this.applicationManager.setCurrentNetwork(null);
        String collectionName = collection;
        ObjectMapper objMapper = new ObjectMapper();
        JsonNode rootNode = (JsonNode)objMapper.readValue(is, JsonNode.class);
        Map<String, Map<String, Object>> netProps = this.getNetworkProps(rootNode);
        HashMap<String, Long[]> results = new HashMap<String, Long[]>();
        HashMap<Long, CyRootNetwork> sub2roots = new HashMap<Long, CyRootNetwork>();
        HashMap<CyNetworkView, VisualStyle> styleMap = new HashMap<CyNetworkView, VisualStyle>();
        for (String url : netProps.keySet()) {
            Map<CyNetworkView, VisualStyle> subMap = this.loadNetworkFromUrl(format, url, collectionName, results, netProps, sub2roots);
            styleMap.putAll(subMap);
        }
        is.close();
        styleMap.keySet().stream().forEach(view -> this.postProcess((CyNetworkView)view, (VisualStyle)styleMap.get(view)));
        return this.generateNetworkLoadResults(results);
    }

    private final Map<CyNetworkView, VisualStyle> loadNetworkFromUrl(String format, String sourceUrl, String collectionName, Map<String, Long[]> results, Map<String, Map<String, Object>> netProps, Map<Long, CyRootNetwork> sub2roots) throws IOException {
        CyRootNetwork rootNetwork;
        ArrayList<CyNetwork> cxNetworks = new ArrayList<CyNetwork>();
        TaskIterator itr = null;
        if (format != null && format.equalsIgnoreCase(CX_FORMAT)) {
            readerFactory = this.tfManager.getInputStreamTaskFactory(CX_READER_ID);
            source = new URL(sourceUrl);
            itr = readerFactory.createTaskIterator(source.openStream(), "cx collection");
        } else if (format != null && format.equalsIgnoreCase(CX2_FORMAT)) {
            readerFactory = this.tfManager.getInputStreamTaskFactory(CX2_READER_ID);
            source = new URL(sourceUrl);
            itr = readerFactory.createTaskIterator(source.openStream(), "cx collection");
        } else {
            itr = this.loadNetworkURLTaskFactory.loadCyNetworks(new URL(sourceUrl));
        }
        CyNetworkReader reader = null;
        while (itr.hasNext()) {
            Task task = itr.next();
            try {
                if (task instanceof CyNetworkReader) {
                    reader = (CyNetworkReader)task;
                    if (reader instanceof AbstractCyNetworkReader) {
                        AbstractCyNetworkReader ar = (AbstractCyNetworkReader)reader;
                        List rootNames = ar.getRootNetworkList().getPossibleValues();
                        if (collectionName != null && rootNames.contains(collectionName)) {
                            ar.getRootNetworkList().setSelectedValue((Object)collectionName);
                        }
                    }
                    reader.run((TaskMonitor)new HeadlessTaskMonitor());
                    continue;
                }
                task.run((TaskMonitor)new HeadlessTaskMonitor());
            }
            catch (Exception e) {
                throw new IOException("Could not execute network reader.", e);
            }
        }
        CyNetwork[] networks = reader.getNetworks();
        Map<CyNetworkView, VisualStyle> styleMap = new HashMap<CyNetworkView, VisualStyle>();
        if (networks == null || networks.length == 0) {
            return styleMap;
        }
        cxNetworks.addAll(Arrays.asList(networks));
        Long[] suids = new Long[networks.length];
        int counter = 0;
        for (CyNetwork network : networks) {
            sub2roots.put(network.getSUID(), this.cyRootNetworkManager.getRootNetwork(network));
            suids[counter] = network.getSUID();
            Map<String, Object> propMap = netProps.get(sourceUrl);
            if (propMap != null) {
                propMap.keySet().stream().forEach(key -> this.setNetworkProps((String)key, propMap.get(key), network));
            } else {
                this.setNetworkProps("source_location", sourceUrl, network);
            }
            ++counter;
        }
        results.put(sourceUrl, suids);
        if (format != null && (format.equalsIgnoreCase(CX_FORMAT) || format.equalsIgnoreCase(CX2_FORMAT))) {
            rootNetwork = ((CySubNetwork)cxNetworks.get(0)).getRootNetwork();
            String cxCollectionName = (String)rootNetwork.getRow((CyIdentifiable)rootNetwork).get("name", String.class);
            CyNetwork[] cxArray = cxNetworks.toArray(new CyNetwork[0]);
            styleMap = this.addNetwork(cxArray, reader, cxCollectionName, false);
        }
        if (collectionName != null) {
            rootNetwork = ((CySubNetwork)networks[0]).getRootNetwork();
            rootNetwork.getRow((CyIdentifiable)rootNetwork).set("name", (Object)collectionName);
        }
        return styleMap;
    }

    private void setNetworkProps(String key, Object value, CyNetwork network) {
        CyColumn col = network.getDefaultNetworkTable().getColumn(key);
        if (col == null) {
            network.getDefaultNetworkTable().createColumn(key, String.class, true);
        }
        network.getRow((CyIdentifiable)network).set(key, (Object)value.toString());
    }

    private final String generateNetworkLoadResults(Map<String, Long[]> results) {
        JsonFactory factory = new JsonFactory();
        String result = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonGenerator generator = null;
        try {
            generator = factory.createGenerator((OutputStream)stream);
            generator.writeStartArray();
            for (String url : results.keySet()) {
                generator.writeStartObject();
                generator.writeStringField("source", url);
                generator.writeArrayFieldStart("networkSUID");
                for (Long suid : results.get(url)) {
                    generator.writeNumber(suid.longValue());
                }
                generator.writeEndArray();
                generator.writeEndObject();
            }
            generator.writeEndArray();
            generator.close();
            result = stream.toString("UTF-8");
            stream.close();
        }
        catch (IOException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 9, "Could not create object count.", this.getResourceLogger(), e);
        }
        return result;
    }

    private final void addNetwork(CyNetwork[] networks, CyNetworkReader reader, String collectionName) {
        this.addNetwork(networks, reader, collectionName, true);
    }

    private final Map<CyNetworkView, VisualStyle> addNetwork(CyNetwork[] networks, CyNetworkReader reader, String collectionName, Boolean applyStyle) {
        ArrayList<CyNetworkView> results = new ArrayList<CyNetworkView>();
        HashMap<CyNetworkView, VisualStyle> styleMap = new HashMap<CyNetworkView, VisualStyle>();
        HashSet<CyRootNetwork> rootNetworks = new HashSet<CyRootNetwork>();
        for (CyNetwork net : this.networkManager.getNetworkSet()) {
            CyRootNetwork rootNet = this.cyRootNetworkManager.getRootNetwork(net);
            rootNetworks.add(rootNet);
        }
        for (CyNetwork network : networks) {
            String networkName = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
            if (networkName == null || networkName.trim().length() == 0) {
                if (networkName == null) {
                    networkName = collectionName;
                }
                network.getRow((CyIdentifiable)network).set("name", (Object)networkName);
            }
            this.networkManager.addNetwork(network);
            int numGraphObjects = network.getNodeCount() + network.getEdgeCount();
            int viewThreshold = 200000;
            if (numGraphObjects >= viewThreshold) continue;
            CyNetworkView view = reader.buildCyNetworkView(network);
            VisualStyle style = this.vmm.getVisualStyle(view);
            if (style == null) {
                style = this.vmm.getDefaultVisualStyle();
            }
            styleMap.put(view, style);
            this.networkViewManager.addNetworkView(view);
            results.add(view);
        }
        if (networks.length == 1 && networks[0] instanceof CySubNetwork) {
            CySubNetwork subnet = (CySubNetwork)networks[0];
            CyRootNetwork rootNet = subnet.getRootNetwork();
            String rootNetName = (String)rootNet.getRow((CyIdentifiable)rootNet).get("name", String.class);
            if (collectionName != null && collectionName.trim().length() > 0) {
                rootNet.getRow((CyIdentifiable)rootNet).set("name", (Object)collectionName);
            }
            if ((rootNetName == null || rootNetName.trim().length() == 0) && collectionName != null) {
                rootNet.getRow((CyIdentifiable)rootNet).set("name", (Object)collectionName);
            }
        }
        return styleMap;
    }

    private final void postProcess(CyNetworkView view, VisualStyle style) {
        this.vmm.setVisualStyle(style, view);
        style.apply(view);
        view.fitContent();
        view.updateView();
    }

    private class CXSubNetWriterThread
    extends Thread {
        private OutputStream out;
        private CyNetwork target;
        private CyNetworkViewWriterFactory cxWriterFactory;

        public CXSubNetWriterThread(OutputStream out, CyNetwork targetSubNet, CyNetworkViewWriterFactory cxWriterFactory) {
            this.out = out;
            this.target = targetSubNet;
            this.cxWriterFactory = cxWriterFactory;
        }

        @Override
        public void run() {
            CyWriter writer = this.cxWriterFactory.createWriter(this.out, this.target);
            try {
                writer.run(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class NetworkViewSUIDResponse
    extends CIResponse<NetworkViewSUIDModel> {
        private NetworkViewSUIDResponse() {
        }
    }

    private static class NetworkSUIDResponse
    extends CIResponse<NetworkSUIDModel> {
        private NetworkSUIDResponse() {
        }
    }
}

