/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.rest.internal.resource.AbstractResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Networks"})
@Singleton
@Path(value="/v1/networks.json")
public class NetworkFullResource
extends AbstractResource {
    private static final String RESOURCE_URN = "networks";
    private static final Logger logger = LoggerFactory.getLogger(NetworkFullResource.class);

    @Override
    public String getResourceURI() {
        return RESOURCE_URN;
    }

    @Override
    public Logger getResourceLogger() {
        return logger;
    }

    @GET
    @Produces(value={"application/json; charset=UTF-8"})
    @ApiOperation(value=" Get networks in Cytoscape.js JSON format", notes="Returns a list of all networks as an array of [Cytoscape.js](https://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#cytoscape-js-json) format entries.\n\nIf the `column` and `query` parameters are specified, the results will be limited to rows in the network table where the value in the column specified by the `column` parameter matches the value specified by the `query` parameter.")
    public String getNetworks(@ApiParam(value="The name of the column that will be queried for matches.", required=false) @QueryParam(value="column") String column, @ApiParam(value="The value to be matched.", required=false) @QueryParam(value="query") String query) {
        Set<CyNetwork> networks;
        if (column == null && query == null) {
            networks = this.networkManager.getNetworkSet();
        } else {
            try {
                networks = this.getNetworksByQuery(7, query, column);
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 8, "Error executing Network query.", this.getResourceLogger(), e);
            }
        }
        return this.getNetworksAsString(networks);
    }

    private final String getNetworksAsString(Set<CyNetwork> networks) {
        if (networks.isEmpty()) {
            return "[]";
        }
        StringBuilder result = new StringBuilder();
        result.append("[");
        for (CyNetwork network : networks) {
            result.append(this.getNetworkString(10, 9, network));
            result.append(",");
        }
        String jsonString = result.toString();
        jsonString = jsonString.substring(0, jsonString.length() - 1);
        return jsonString + "]";
    }
}

