/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.cytoscape.io.write.CyNetworkViewWriterFactory;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.rest.internal.datamapper.TableMapper;
import org.cytoscape.rest.internal.model.CountModel;
import org.cytoscape.rest.internal.model.CyColumnModel;
import org.cytoscape.rest.internal.model.CyTableWithRowsModel;
import org.cytoscape.rest.internal.resource.AbstractResource;
import org.cytoscape.rest.internal.serializer.TableModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Collections"})
@Singleton
@Path(value="/v1/collections")
public class CollectionResource
extends AbstractResource {
    private final ObjectMapper mapper = new ObjectMapper();
    private final TableMapper tableMapper = new TableMapper();
    private static final String RESOURCE_URN = "collections";
    private static final Logger logger = LoggerFactory.getLogger(CollectionResource.class);
    public static final int INTERNAL_METHOD_ERROR = 1;
    public static final int SUB_NETWORK_NOT_FOUND_ERROR = 2;
    public static final int ROOT_NETWORK_NOT_FOUND_ERROR = 3;
    public static final int TABLE_NOT_FOUND_ERROR = 4;
    public static final int SERIALIZATION_ERROR = 5;
    public static final int CX_SERVICE_UNAVAILABLE_ERROR = 6;
    private static final int INVALID_PARAMETER_ERROR = 7;
    private static final String COLLECTION_ASCII_ART = "Cytoscape can contain multiple Root Networks, each with their own Sub-Networks\n```\n\u2500\u2500 Root Network 1\n   \u251c\u2500\u2500 Sub-Network A\n   \u2514\u2500\u2500 Sub-Network B\n\u2500\u2500 Root Network 2\n   \u2514\u2500\u2500 Sub-Network C\n```";
    private static final String TABLE_TYPE_DESCRIPTION = "The `default` table contains data relevant to a Root Network. The `shared` table contains data shared by all Sub-Networks of a Root Network.";
    private static final String TABLE_TYPE_NOTES_DESCRIPTION = "Root network tables, particularly the shared table accessible by specifying the `tableType` parameter as `shared`, are available through Collection operations, and are not normally accessible in other contexts.";

    @Override
    public String getResourceURI() {
        return RESOURCE_URN;
    }

    @Override
    public Logger getResourceLogger() {
        return logger;
    }

    public CollectionResource() {
        this.mapper.registerModule((Module)new TableModule());
    }

    private final Set<CyRootNetwork> getRootNetworks() {
        return this.networkManager.getNetworkSet().stream().map(net -> this.cyRootNetworkManager.getRootNetwork(net)).collect(Collectors.toSet());
    }

    private final CyRootNetwork getRootNetwork(Long suid) {
        Set<CyRootNetwork> roots = this.getRootNetworks();
        for (CyRootNetwork root : roots) {
            if (!root.getSUID().equals(suid)) continue;
            return root;
        }
        return null;
    }

    private final Response getResponse(Object val) {
        String result = null;
        try {
            result = this.mapper.writeValueAsString(val);
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 5, "Could not serialize result: " + String.valueOf(val), this.getResourceLogger(), e);
        }
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/count")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a count of all root networks.", notes="Returns a count of all root networks.")
    public CountModel getCollectionCount() {
        return new CountModel(Long.valueOf(this.getRootNetworks().size()));
    }

    @GET
    @Produces(value={"application/json; charset=UTF-8"})
    @ApiOperation(value="Get one or all root networks.", notes="Returns all Root Networks as an array of SUIDs.\n\nIf a valid Sub-Network SUID is specified in the `subsuid` parameter, the list will contain only the SUID of that Sub-Network's Root Network.")
    public Collection<Long> getCollectionsAsSUID(@ApiParam(value="Sub-Network SUID. If this parameter is used, the Root Network of this Sub-Network will be returned.\n\nCytoscape can contain multiple Root Networks, each with their own Sub-Networks\n```\n\u2500\u2500 Root Network 1\n   \u251c\u2500\u2500 Sub-Network A\n   \u2514\u2500\u2500 Sub-Network B\n\u2500\u2500 Root Network 2\n   \u2514\u2500\u2500 Sub-Network C\n```", required=false) @QueryParam(value="subsuid") Long subsuid) {
        if (subsuid == null) {
            return this.getRootNetworks().stream().map(root -> root.getSUID()).collect(Collectors.toSet());
        }
        CyNetwork subnetwork = this.networkManager.getNetwork(subsuid.longValue());
        if (subnetwork == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 2, "Could not find Network with SUID: " + subsuid, this.getResourceLogger(), null);
        }
        CyRootNetwork root2 = this.cyRootNetworkManager.getRootNetwork(subnetwork);
        if (root2 == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 3, "Could not find Root Network for Network with SUID: " + subsuid, this.getResourceLogger(), null);
        }
        ArrayList<Long> rootId = new ArrayList<Long>();
        rootId.add(root2.getSUID());
        return rootId;
    }

    @GET
    @Path(value="/{networkId}.cx")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a collection as CX", notes="Returns a Root Network or Sub-Network in [CX format](https://manual.cytoscape.org/en/stable/Supported_Network_File_Formats.html#cytoscape-cx).\n\nIf the `networkId` parameter is a Root Network, this returns that Root Network.\n\nIf the `networkId` parameter is a Sub-Network, this returns the Root Retwork that contains that Sub-Network.")
    public Response getCollectionAsCx(@ApiParam(value="Root Network or Sub-Network SUID. \n\nCytoscape can contain multiple Root Networks, each with their own Sub-Networks\n```\n\u2500\u2500 Root Network 1\n   \u251c\u2500\u2500 Sub-Network A\n   \u2514\u2500\u2500 Sub-Network B\n\u2500\u2500 Root Network 2\n   \u2514\u2500\u2500 Sub-Network C\n```") @PathParam(value="networkId") Long networkId) {
        return this.getCX(networkId);
    }

    @GET
    @Path(value="/{networkId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a collection", notes="", hidden=true)
    public Response getCollection(@ApiParam(value="Network SUID") @PathParam(value="networkId") Long networkId) {
        return this.getCX(networkId);
    }

    @GET
    @Path(value="/{networkId}/subnetworks")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get SubNetworks", notes="Returns a list of SUIDs representing Sub-Networks that belong to the Root Network specified by the `networkId` parameter.")
    public Collection<Long> getSubnetworks(@ApiParam(value="Root Network SUID\n\nCytoscape can contain multiple Root Networks, each with their own Sub-Networks\n```\n\u2500\u2500 Root Network 1\n   \u251c\u2500\u2500 Sub-Network A\n   \u2514\u2500\u2500 Sub-Network B\n\u2500\u2500 Root Network 2\n   \u2514\u2500\u2500 Sub-Network C\n```") @PathParam(value="networkId") Long networkId) {
        CyRootNetwork root = this.getRootNetwork(networkId);
        List subnetworks = root.getSubNetworkList();
        Set<Long> subnetIds = subnetworks.stream().map(subNet -> subNet.getSUID()).collect(Collectors.toSet());
        return subnetIds;
    }

    @GET
    @Path(value="/{networkId}/tables")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get Tables in a Root Network", notes="Returns a collection of tables belonging to the Root Network specified by the `networkId` parameter. ", response=CyTableWithRowsModel.class, responseContainer="list")
    public Response getRootTables(@ApiParam(value="Root Network SUID\n\nCytoscape can contain multiple Root Networks, each with their own Sub-Networks\n```\n\u2500\u2500 Root Network 1\n   \u251c\u2500\u2500 Sub-Network A\n   \u2514\u2500\u2500 Sub-Network B\n\u2500\u2500 Root Network 2\n   \u2514\u2500\u2500 Sub-Network C\n```") @PathParam(value="networkId") Long networkId) {
        CyRootNetwork root = this.getRootNetwork(networkId);
        CyTable table = root.getDefaultNetworkTable();
        CyTable shared = root.getSharedNetworkTable();
        HashSet<CyTable> tables = new HashSet<CyTable>();
        tables.add(shared);
        tables.add(table);
        return this.getResponse(tables);
    }

    @GET
    @Path(value="/{networkId}/tables/{tableType}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a specific Table in a Root Network", response=CyTableWithRowsModel.class, notes="Returns either the `default` or `shared` table from the Root Network specified by the `networkId` parameter.\n\nRoot network tables, particularly the shared table accessible by specifying the `tableType` parameter as `shared`, are available through Collection operations, and are not normally accessible in other contexts.")
    public Response getRootTable(@ApiParam(value="Root Network SUID\n\nCytoscape can contain multiple Root Networks, each with their own Sub-Networks\n```\n\u2500\u2500 Root Network 1\n   \u251c\u2500\u2500 Sub-Network A\n   \u2514\u2500\u2500 Sub-Network B\n\u2500\u2500 Root Network 2\n   \u2514\u2500\u2500 Sub-Network C\n```") @PathParam(value="networkId") Long networkId, @ApiParam(value="The `default` table contains data relevant to a Root Network. The `shared` table contains data shared by all Sub-Networks of a Root Network.", allowableValues="default,shared") @PathParam(value="tableType") String tableType) {
        return this.getResponse(this.getTable(networkId, tableType));
    }

    @DELETE
    @Path(value="/{networkId}/tables/{tableType}/columns/{columnName}")
    @ApiOperation(value="Delete a column", notes="Deletes the column specified by the `columnName` parameter from the table specified the `tableType` parameter in the Root Network specified by the `networkId` parameter.\n\nRoot network tables, particularly the shared table accessible by specifying the `tableType` parameter as `shared`, are available through Collection operations, and are not normally accessible in other contexts.")
    public Response deleteColumn(@ApiParam(value="Root Network SUID\n\nCytoscape can contain multiple Root Networks, each with their own Sub-Networks\n```\n\u2500\u2500 Root Network 1\n   \u251c\u2500\u2500 Sub-Network A\n   \u2514\u2500\u2500 Sub-Network B\n\u2500\u2500 Root Network 2\n   \u2514\u2500\u2500 Sub-Network C\n```") @PathParam(value="networkId") Long networkId, @ApiParam(value="The `default` table contains data relevant to a Root Network. The `shared` table contains data shared by all Sub-Networks of a Root Network.", allowableValues="default,shared") @PathParam(value="tableType") String tableType, @ApiParam(value="Column Name") @PathParam(value="columnName") String columnName) {
        CyTable table = this.getTable(networkId, tableType);
        if (table != null) {
            try {
                table.deleteColumn(columnName);
            }
            catch (Exception e) {
                throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 1, "Could not delete column: " + columnName, this.getResourceLogger(), e);
            }
            return Response.ok().build();
        }
        throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 4, "No such Table type: " + tableType, this.getResourceLogger(), null);
    }

    @GET
    @Path(value="/{networkId}/tables/{tableType}/columns")
    @ApiOperation(value="Get a list of columns for a Root Network table", notes="Return a list of the columns in the table specified by the `tableType` parameter in the Root Network specified by the `networkId` parameter.\n\nRoot network tables, particularly the shared table accessible by specifying the `tableType` parameter as `shared`, are available through Collection operations, and are not normally accessible in other contexts.", response=CyColumnModel.class, responseContainer="list")
    public Response getColumns(@ApiParam(value="Root Network SUID\n\nCytoscape can contain multiple Root Networks, each with their own Sub-Networks\n```\n\u2500\u2500 Root Network 1\n   \u251c\u2500\u2500 Sub-Network A\n   \u2514\u2500\u2500 Sub-Network B\n\u2500\u2500 Root Network 2\n   \u2514\u2500\u2500 Sub-Network C\n```") @PathParam(value="networkId") Long networkId, @ApiParam(value="The `default` table contains data relevant to a Root Network. The `shared` table contains data shared by all Sub-Networks of a Root Network.", allowableValues="default,shared") @PathParam(value="tableType") String tableType) {
        CyTable table = this.getTable(networkId, tableType);
        try {
            String result = this.serializer.serializeColumns(table.getColumns());
            return Response.ok((Object)result).build();
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 5, "Could not serialize column names.", this.getResourceLogger(), null);
        }
    }

    private final CyTable getTable(Long networkId, String tableType) {
        CyRootNetwork root = this.getRootNetwork(networkId);
        if (tableType.equals("default")) {
            return root.getDefaultNetworkTable();
        }
        if (tableType.equals("shared")) {
            return root.getSharedNetworkTable();
        }
        return null;
    }

    @PUT
    @Path(value="/{networkId}/tables/{tableType}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update table values", notes="Updates the values in a table. New columns will be created if they do not exist in the target table.\n\nRoot network tables, particularly the shared table accessible by specifying the `tableType` parameter as `shared`, are available through Collection operations, and are not normally accessible in other contexts.")
    @ApiImplicitParams(value={@ApiImplicitParam(value="The data with which to update the table.", dataType="org.cytoscape.rest.internal.model.UpdateTableModel", paramType="body", required=true)})
    public Response updateTable(@ApiParam(value="Root Network SUID\n\nCytoscape can contain multiple Root Networks, each with their own Sub-Networks\n```\n\u2500\u2500 Root Network 1\n   \u251c\u2500\u2500 Sub-Network A\n   \u2514\u2500\u2500 Sub-Network B\n\u2500\u2500 Root Network 2\n   \u2514\u2500\u2500 Sub-Network C\n```") @PathParam(value="networkId") Long networkId, @ApiParam(value="The `default` table contains data relevant to a Root Network. The `shared` table contains data shared by all Sub-Networks of a Root Network.", allowableValues="default,shared") @PathParam(value="tableType") String tableType, @ApiParam(hidden=true) InputStream is) {
        CyTable table = this.getTable(networkId, tableType);
        if (table == null) {
            throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 4, "No such Table type: " + tableType, this.getResourceLogger(), null);
        }
        JsonNode rootNode = null;
        try {
            rootNode = (JsonNode)this.mapper.readValue(is, JsonNode.class);
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 7, "Could not parse the input JSON", this.getResourceLogger(), e);
        }
        try {
            this.tableMapper.updateTableValues(rootNode, table);
        }
        catch (IllegalArgumentException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 7, e.getMessage(), logger, e);
        }
        catch (TableMapper.ColumnNotFoundException e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), RESOURCE_URN, 7, e.getMessage(), logger, e);
        }
        return Response.ok().build();
    }

    private final Response getCX(Long networkId) {
        CyNetworkViewWriterFactory cxWriterFactory = this.viewWriterFactoryManager.getFactory("cxNetworkWriterFactory");
        if (cxWriterFactory == null) {
            throw this.getCIWebApplicationException(Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), this.getResourceURI(), 6, "No CX Writer available. Please install CX Support App to use this API.", this.getResourceLogger(), null);
        }
        CyRootNetwork root = null;
        if (!this.getCollectionsAsSUID(null).contains(networkId)) {
            CyNetwork subNet = this.networkManager.getNetwork(networkId.longValue());
            if (subNet == null) {
                throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 2, "Network not found: " + networkId, this.getResourceLogger(), null);
            }
            root = this.cyRootNetworkManager.getRootNetwork(subNet);
        } else {
            root = this.getRootNetwork(networkId);
            if (root == null) {
                throw this.getCIWebApplicationException(Response.Status.NOT_FOUND.getStatusCode(), this.getResourceURI(), 3, "Collection not found: " + networkId, this.getResourceLogger(), null);
            }
        }
        return Response.ok((Object)this.getNetworkViewsAsCX(root)).build();
    }

    private final String getNetworkViewsAsCX(CyRootNetwork root) {
        CyNetworkViewWriterFactory cxWriterFactory = this.viewWriterFactoryManager.getFactory("cxNetworkWriterFactory");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        CyWriter writer = cxWriterFactory.createWriter((OutputStream)stream, (CyNetwork)root.getSubNetworkList().get(0));
        String jsonString = null;
        try {
            writer.run(null);
            jsonString = stream.toString("UTF-8");
            stream.close();
        }
        catch (Exception e) {
            throw this.getCIWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResourceURI(), 5, "Failed to serialize network into CX: " + String.valueOf(root), this.getResourceLogger(), e);
        }
        return jsonString;
    }
}

