/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.resource;

import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.cytoscape.ci.model.CIResponse;
import org.cytoscape.rest.internal.CyRESTConstants;
import org.cytoscape.rest.internal.model.AppModel;
import org.cytoscape.rest.internal.model.CountModel;
import org.cytoscape.rest.internal.resource.AbstractResource;
import org.cytoscape.rest.internal.task.AutomationAppTracker;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Apps"})
@Singleton
@Path(value="/v1/apps")
public class AppsResource
extends AbstractResource {
    @Inject
    AutomationAppTracker appTracker;
    private static final String RESOURCE_URN = "apps";
    private static final Logger logger = LoggerFactory.getLogger(AppsResource.class);

    @Override
    public String getResourceURI() {
        return RESOURCE_URN;
    }

    @Override
    public Logger getResourceLogger() {
        return logger;
    }

    @GET
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Get installed Automation Accessible Cytoscape Apps", notes="Returns installed Cytoscape Apps that have CyREST accessible Functions or Commands. If the `bundleState` parameter is used, this operation will only return Apps with an OSGi bundle state matching the passed parameter.")
    public List<AppModel> getAppList(@ApiParam(value="The state of the App bundle. This should be one of the following:\n* 1 UNINSTALLED\n* 2 INSTALLED\n* 4 RESOLVED\n* 8 STARTING\n* 16 STOPPING\n* 32 ACTIVE\n", allowableValues="1,2,4,8,16,32,", required=false) @QueryParam(value="bundleState") Integer bundleState) {
        ArrayList<AppModel> list = new ArrayList<AppModel>();
        for (Bundle bundle : this.appTracker.getAppBundles()) {
            AppModel appModel = new AppModel();
            Object bundleNameObject = bundle.getHeaders().get(CyRESTConstants.BUNDLE_NAME);
            if (bundleNameObject != null) {
                appModel.bundleName = bundleNameObject.toString();
            }
            appModel.bundleSymbolicName = bundle.getSymbolicName();
            appModel.bundleVersion = bundle.getVersion().toString();
            appModel.bundleState = bundle.getState();
            if (bundleState != null && appModel.bundleState != bundleState) continue;
            list.add(appModel);
        }
        return list;
    }

    @GET
    @Path(value="/count")
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Get the number of Automation Accessible Cytoscape Apps", notes="Returns the number of installed Cytoscape Apps that have CyREST accessible Functions or Commands.  If the `bundleState` parameter is used, this operation will only count Apps with an OSGi bundle state matching the passed parameter.")
    public CIResponse<CountModel> getAppCount(@ApiParam(value="The state of the App bundle. This should be one of the following:\n* 1 UNINSTALLED\n* 2 INSTALLED\n* 4 RESOLVED\n* 8 STARTING\n* 16 STOPPING\n* 32 ACTIVE\n", allowableValues="1,2,4,8,16,32,", required=false) @QueryParam(value="bundleState") Integer bundleState) {
        long count = 0L;
        for (Bundle bundle : this.appTracker.getAppBundles()) {
            if (bundleState != null && bundle.getState() != bundleState.intValue()) continue;
            ++count;
        }
        CountModel data = new CountModel(count);
        return this.ciResponseFactory.getCIResponse((Object)data);
    }
}

