/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.datamapper;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.rest.internal.datamapper.MapperUtil;

public class TableMapper {
    private static final String KEY = "key";
    private static final String DATA_KEY = "dataKey";
    private static final String DATA = "data";

    public void updateColumnName(JsonNode rootNode, CyTable table) throws ColumnNotFoundException {
        JsonNode currentNameTag = rootNode.get("oldName");
        if (currentNameTag == null) {
            throw new IllegalArgumentException("Original column name is missing.");
        }
        JsonNode newNameTag = rootNode.get("newName");
        if (newNameTag == null) {
            throw new IllegalArgumentException("New column name is missing.");
        }
        String currentName = currentNameTag.asText();
        if (currentName == null || currentName.isEmpty()) {
            throw new IllegalArgumentException("Original column name is missing.");
        }
        String newName = newNameTag.asText();
        if (newName == null || newName.isEmpty()) {
            throw new IllegalArgumentException("New column name is missing.");
        }
        CyColumn column = table.getColumn(currentName);
        if (column == null) {
            throw new ColumnNotFoundException("Column does not exist.");
        }
        column.setName(newName);
    }

    public void createNewColumn(JsonNode rootNode, CyTable table, CyTable localTable) {
        String columnName = rootNode.get("name").textValue();
        Class<?> type = MapperUtil.getColumnClass(rootNode.get("type").textValue(), true);
        if (table.getColumn(columnName) != null) {
            throw new IllegalArgumentException("Column already exists: " + columnName);
        }
        boolean isImmutable = false;
        boolean isList = false;
        boolean isLocal = false;
        JsonNode immutable = rootNode.get("immutable");
        JsonNode list = rootNode.get("list");
        JsonNode local = rootNode.get("local");
        if (list != null) {
            isList = list.asBoolean();
        }
        if (immutable != null) {
            isImmutable = immutable.asBoolean();
        }
        if (local != null) {
            isLocal = local.asBoolean();
        }
        if (isList) {
            if (isLocal) {
                localTable.createListColumn(columnName, type, isImmutable);
            } else {
                table.createListColumn(columnName, type, isImmutable);
            }
        } else if (isLocal) {
            localTable.createColumn(columnName, type, isImmutable);
        } else {
            table.createColumn(columnName, type, isImmutable);
        }
    }

    public void updateColumnValues(JsonNode rootNode, CyTable table, String columnName) {
        for (JsonNode entry : rootNode) {
            Long primaryKey = entry.get("SUID").asLong();
            CyRow row = table.getRow((Object)primaryKey);
            if (row == null) continue;
            JsonNode value = entry.get("value");
            this.setValue(table.getColumn(columnName).getType(), value, row, columnName);
        }
    }

    public void updateAllColumnValues(String defaultValue, CyTable table, String columnName) {
        Class dataType = table.getColumn(columnName).getType();
        for (CyRow row : table.getAllRows()) {
            this.assignValue(defaultValue, dataType, row, columnName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void updateTableValues(JsonNode rootNode, CyTable table) throws ColumnNotFoundException {
        data = rootNode.get("data");
        if (data == null) {
            throw new IllegalArgumentException("Data array is missing.");
        }
        if (!data.isArray()) {
            throw new IllegalArgumentException("Data should be an array.");
        }
        keyCol = rootNode.get("key");
        keyColName = keyCol == null ? "SUID" : keyCol.asText();
        col = table.getColumn(keyColName);
        if (col == null) {
            throw new ColumnNotFoundException("No such column in the table: " + keyColName);
        }
        dataKeyCol = rootNode.get("dataKey");
        dataKeyColName = dataKeyCol == null ? "SUID" : dataKeyCol.asText();
        for (JsonNode entry : data) {
            keyValue = entry.get(dataKeyColName);
            if (keyValue == null || (key = MapperUtil.getValue(keyValue, col.getType())) == null || (machingRows = table.getMatchingRows(keyColName, key)).isEmpty()) continue;
            for (CyRow row : machingRows) {
                fields = entry.fieldNames();
                while (fields.hasNext()) {
                    block15: {
                        field = (String)fields.next();
                        value = entry.get(field);
                        if (value == null) continue;
                        column = null;
                        var20_20 = this;
                        synchronized (var20_20) {
                            column = table.getColumn(field);
                            if (column != null) break block15;
                            type = this.getValueType(value);
                            if (type != List.class) ** GOTO lbl44
                            uniform = true;
                            listType = null;
                            for (JsonNode element : value) {
                                if (listType == null) {
                                    listType = this.getValueType(element);
                                    continue;
                                }
                                if (listType.equals(this.getValueType(element))) continue;
                                uniform = false;
                            }
                            if (listType != null && uniform) {
                                table.createListColumn(field, listType, false);
                                column = table.getColumn(field);
                            } else {
                                continue;
lbl44:
                                // 1 sources

                                table.createColumn(field, type, false);
                                column = table.getColumn(field);
                            }
                        }
                    }
                    try {
                        this.setValue(column.getType(), value, row, field);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private final void setValue(Class<?> type, JsonNode value, CyRow row, String columnName) {
        if (value.isNull()) {
            row.set(columnName, null);
            return;
        }
        if (type == String.class) {
            row.set(columnName, (Object)value.asText());
        } else if (type == Boolean.class) {
            row.set(columnName, (Object)value.asBoolean());
        } else if (type == Double.class) {
            row.set(columnName, (Object)value.asDouble());
        } else if (type == Integer.class) {
            row.set(columnName, (Object)value.asInt());
        } else if (type == Long.class) {
            row.set(columnName, (Object)value.asLong());
        } else if (type == Float.class) {
            row.set(columnName, (Object)value.asDouble());
        } else if (type == List.class) {
            Class listType = row.getTable().getColumn(columnName).getListElementType();
            this.updateList(listType, value, row, columnName);
        }
    }

    private final <K> void updateList(Class<K> listType, JsonNode values, CyRow row, String columnName) {
        List list = row.getList(columnName, listType);
        if (list == null) {
            row.set(columnName, new ArrayList());
            list = row.getList(columnName, listType);
        }
        list.clear();
        for (JsonNode value : values) {
            if (listType == String.class) {
                list.add(value.asText());
                continue;
            }
            if (listType == Boolean.class) {
                list.add(new Boolean(value.asBoolean()));
                continue;
            }
            if (listType == Double.class) {
                list.add(new Double(value.asDouble()));
                continue;
            }
            if (listType == Integer.class) {
                list.add(new Integer(value.asInt()));
                continue;
            }
            if (listType == Long.class) {
                list.add(new Long(value.asLong()));
                continue;
            }
            if (listType != Float.class) continue;
            list.add(new Float(value.asDouble()));
        }
    }

    private final void assignValue(String value, Class<?> type, CyRow row, String columnName) {
        if (type == String.class) {
            row.set(columnName, (Object)value.toString());
        } else if (type == Boolean.class) {
            row.set(columnName, (Object)Boolean.parseBoolean(value));
        } else if (type == Double.class) {
            row.set(columnName, (Object)Double.parseDouble(value));
        } else if (type == Integer.class) {
            row.set(columnName, (Object)Integer.parseInt(value));
        } else if (type == Long.class) {
            row.set(columnName, (Object)Long.parseLong(value));
        } else if (type == Float.class) {
            row.set(columnName, (Object)Double.parseDouble(value));
        }
    }

    private final Class<?> getValueType(JsonNode value) {
        if (value.isArray()) {
            return List.class;
        }
        if (value.isBoolean()) {
            return Boolean.class;
        }
        if (value.isNumber()) {
            return Double.class;
        }
        return String.class;
    }

    public final class ColumnNotFoundException
    extends Exception {
        public ColumnNotFoundException(String string) {
            super(string);
        }
    }
}

