/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal.commands.resources;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.cytoscape.rest.internal.commands.handlers.MessageHandler;
import org.cytoscape.rest.internal.commands.resources.CommandResourceTaskObserver;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskObserver;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

public class StringResultTaskObserver
extends CommandResourceTaskObserver
implements PaxAppender,
TaskObserver {
    public StringResultTaskObserver(MessageHandler messageHandler) {
        super(messageHandler);
    }

    public void taskFinished(ObservableTask t) {
        Object res = t.getResults(String.class);
        if (res != null) {
            this.messageHandler.appendResult(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allFinished(FinishStatus status) {
        if (status.getType().equals((Object)FinishStatus.Type.SUCCEEDED)) {
            this.messageHandler.appendMessage("Finished");
        } else if (status.getType().equals((Object)FinishStatus.Type.CANCELLED)) {
            this.messageHandler.appendWarning("Cancelled by user");
        } else if (status.getType().equals((Object)FinishStatus.Type.FAILED)) {
            if (status.getException() != null) {
                this.messageHandler.appendError("Failed: " + status.getException().getMessage());
                this.taskException = new CustomFailureException("Failed: " + status.getException().getMessage());
            } else {
                this.messageHandler.appendError("Failed");
                this.taskException = new CustomFailureException();
            }
        }
        StringResultTaskObserver stringResultTaskObserver = this;
        synchronized (stringResultTaskObserver) {
            this.finished = true;
            this.notify();
        }
    }

    public void doAppend(PaxLoggingEvent event) {
        String message = event.getMessage();
        switch (event.getLevel().toLevel()) {
            case AUDIT: 
            case ERROR: {
                this.messageHandler.appendError(message);
                break;
            }
            case WARN: {
                this.messageHandler.appendWarning(message);
                break;
            }
            default: {
                this.messageHandler.appendMessage(message);
            }
        }
    }

    public class CustomFailureException
    extends WebApplicationException {
        public CustomFailureException() {
            super(500);
        }

        public CustomFailureException(String message) {
            super(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).type("text/plain").build());
        }
    }
}

