/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.rest.internal;

import com.google.inject.Module;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.karaf.features.FeaturesService;
import org.cytoscape.app.event.AppsFinishedStartingEvent;
import org.cytoscape.app.event.AppsFinishedStartingListener;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.ci.CIErrorFactory;
import org.cytoscape.ci.CIExceptionFactory;
import org.cytoscape.ci.CIResponseFactory;
import org.cytoscape.command.AvailableCommands;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.group.CyGroupFactory;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.io.BasicCyFileFilter;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.read.InputStreamTaskFactory;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.io.write.CyNetworkViewWriterFactory;
import org.cytoscape.io.write.PresentationWriterFactory;
import org.cytoscape.io.write.VizmapWriterFactory;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.property.CyProperty;
import org.cytoscape.rest.internal.BundleResourceProvider;
import org.cytoscape.rest.internal.CIErrorFactoryImpl;
import org.cytoscape.rest.internal.CIExceptionFactoryImpl;
import org.cytoscape.rest.internal.CIResponseFactoryImpl;
import org.cytoscape.rest.internal.ClearAllEdgeBends;
import org.cytoscape.rest.internal.CyAutomationAction;
import org.cytoscape.rest.internal.CyJSONUtilImpl;
import org.cytoscape.rest.internal.CyNetworkViewWriterFactoryManager;
import org.cytoscape.rest.internal.CyRESTCommandSwaggerAction;
import org.cytoscape.rest.internal.CyRESTConstants;
import org.cytoscape.rest.internal.CyRESTCoreSwaggerAction;
import org.cytoscape.rest.internal.EdgeBundler;
import org.cytoscape.rest.internal.GraphicsWriterManager;
import org.cytoscape.rest.internal.MappingFactoryManager;
import org.cytoscape.rest.internal.TaskFactoryManagerImpl;
import org.cytoscape.rest.internal.reader.EdgeListReaderFactory;
import org.cytoscape.rest.internal.resource.apps.clustermaker2.ClusterMaker2Resource;
import org.cytoscape.rest.internal.task.AllAppsStartedListener;
import org.cytoscape.rest.internal.task.AutomationAppTracker;
import org.cytoscape.rest.internal.task.CoreServiceModule;
import org.cytoscape.rest.internal.task.CyPropertyListener;
import org.cytoscape.rest.internal.task.HeadlessTaskMonitor;
import org.cytoscape.rest.internal.task.OSGiJAXRSManager;
import org.cytoscape.rest.internal.task.ResourceManager;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.task.NetworkCollectionTaskFactory;
import org.cytoscape.task.NetworkTaskFactory;
import org.cytoscape.task.NetworkViewCollectionTaskFactory;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.task.create.NewNetworkSelectedNodesAndEdgesTaskFactory;
import org.cytoscape.task.create.NewSessionTaskFactory;
import org.cytoscape.task.read.LoadNetworkURLTaskFactory;
import org.cytoscape.task.read.OpenSessionTaskFactory;
import org.cytoscape.task.select.SelectFirstNeighborsTaskFactory;
import org.cytoscape.task.write.ExportNetworkViewTaskFactory;
import org.cytoscape.task.write.SaveSessionAsTaskFactory;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.TaskFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyActivator
extends AbstractCyActivator
implements AppsFinishedStartingListener {
    private static final Logger logger = LoggerFactory.getLogger(CyActivator.class);
    private BundleContext bc;
    private String cyRESTPort = null;
    private URI logLocation = null;
    private ServiceTracker cytoscapeJsWriterFactory = null;
    private ServiceTracker cytoscapeJsReaderFactory = null;
    private AllAppsStartedListener allAppsStartedListener = null;
    private FeaturesService featuresService = null;
    private CyPropertyListener cyPropertyListener = null;
    private CyProperty<Properties> cyPropertyServiceRef = null;
    private OSGiJAXRSManager osgiJAXRSManager = null;
    private ResourceManager resourceManager = null;
    private AutomationAppTracker automationAppTracker = null;
    private ServerState serverState = ServerState.STOPPED;

    public void start(BundleContext bc) throws InvalidSyntaxException {
        this.bc = bc;
        try {
            this.logLocation = this.getLogLocation(bc);
        }
        catch (IOException e1) {
            this.logLocation = null;
            logger.warn("CyREST is unable to find the Karaf log");
        }
        this.serverState = ServerState.STARTING;
        this.allAppsStartedListener = new AllAppsStartedListener();
        this.registerService(bc, this.allAppsStartedListener, AppsFinishedStartingListener.class);
        this.cyPropertyListener = new CyPropertyListener();
        this.featuresService = (FeaturesService)this.getService(bc, FeaturesService.class);
        this.registerServiceListener(bc, this.cyPropertyListener::addCyProperty, this.cyPropertyListener::removeCyProperty, CyProperty.class);
        this.cyPropertyServiceRef = (CyProperty)this.getService(bc, CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        CyProperty commandLineProps = (CyProperty)this.getService(bc, CyProperty.class, "(cyPropertyName=commandline.props)");
        Properties clProps = (Properties)commandLineProps.getProperties();
        String argumentPortNumber = clProps.getProperty("rest.port");
        String preferencesPortNumber = ((Properties)this.cyPropertyServiceRef.getProperties()).getProperty("rest.port");
        if (preferencesPortNumber == null) {
            preferencesPortNumber = ResourceManager.DEF_PORT_NUMBER.toString();
            ((Properties)this.cyPropertyServiceRef.getProperties()).setProperty("rest.port", preferencesPortNumber);
        }
        String string = this.cyRESTPort = argumentPortNumber != null ? argumentPortNumber : preferencesPortNumber;
        if (this.suggestRestart(bc)) {
            this.showRestartDialog();
            this.serverState = ServerState.SUGGEST_RESTART;
            logger.warn("Detected new installation. Restarting Cytoscape is recommended.");
        } else {
            this.registerService(bc, (Object)this, AppsFinishedStartingListener.class);
        }
    }

    private final URI getLogLocation(BundleContext bc) throws IOException {
        Dictionary dictionary;
        Object logObject;
        Configuration config;
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)this.getService(bc, ConfigurationAdmin.class);
        String logLocation = configurationAdmin != null ? ((config = configurationAdmin.getConfiguration("org.cytoscape")) != null ? ((logObject = (dictionary = config.getProperties()).get("org.cytoscape.logging.file")) != null && logObject instanceof String ? (String)logObject : null) : null) : null;
        if (logLocation != null) {
            return new File(logLocation).toURI();
        }
        try {
            return new URI("");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ServerState getServerState() {
        return this.serverState;
    }

    private boolean suggestRestart(BundleContext bc) {
        Bundle defaultBundle = bc.getBundle();
        CyProperty cyProperties = (CyProperty)this.getService(bc, CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        Object cyRESTVersion = ((Properties)cyProperties.getProperties()).get("cyrest.version");
        if (!defaultBundle.getVersion().toString().equals(cyRESTVersion)) {
            logger.info("CyREST [" + defaultBundle.getVersion().toString() + "] discovered previous CyREST Version: " + String.valueOf(cyRESTVersion));
            ((Properties)cyProperties.getProperties()).put("cyrest.version", defaultBundle.getVersion().toString());
        }
        return false;
    }

    private void showRestartDialog() {
        CySwingApplication swingApplication = (CySwingApplication)this.getService(this.bc, CySwingApplication.class);
        if (swingApplication != null && swingApplication.getJFrame() != null) {
            JOptionPane messagePane = new JOptionPane("The running version of CyREST has changed.\nCyREST requires a restart of Cytoscape to function correctly.\n\nThis may be caused by installing different versions of CyREST\nor switching between different versions of Cytoscape.", 2);
            JFrame frame = swingApplication.getJFrame();
            final JDialog d2 = new JDialog((Frame)frame, "Restart required");
            d2.setModal(false);
            d2.add(messagePane);
            d2.pack();
            d2.setLocationRelativeTo(frame);
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String prop = evt.getPropertyName();
                    Object val = evt.getNewValue();
                    if (prop.equals("value") && val != null && val != JOptionPane.UNINITIALIZED_VALUE) {
                        d2.setVisible(false);
                    }
                }
            };
            messagePane.addPropertyChangeListener(propertyChangeListener);
            d2.setVisible(true);
        }
    }

    private void startCyREST() throws Exception {
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.submit(() -> {
            try {
                logger.info("Initializing cyREST API server...");
                long start = System.currentTimeMillis();
                this.osgiJAXRSManager = new OSGiJAXRSManager();
                this.initDependencies(this.bc, this.cyPropertyListener, this.cyPropertyServiceRef, this.cyRESTPort);
                this.osgiJAXRSManager.installOSGiJAXRSBundles(this.bc, this.featuresService, this.cyRESTPort);
                this.resourceManager.registerResourceServices();
                this.serverState = ServerState.STARTED;
                long startTime = System.currentTimeMillis() - start;
                logger.info("cyREST API Server initialized in " + startTime + "msec");
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Failed to initialize cyREST server.", (Throwable)e);
                this.serverState = ServerState.FAILED_INITIALIZATION;
            }
            catch (Error e) {
                e.printStackTrace();
                logger.error("Failed to initialize cyREST server.", (Throwable)e);
                this.serverState = ServerState.FAILED_INITIALIZATION;
                throw e;
            }
        });
    }

    public void handleEvent(AppsFinishedStartingEvent event) {
        try {
            this.startCyREST();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Unable to start CyREST", (Throwable)e);
        }
    }

    private final void initDependencies(BundleContext bc, CyPropertyListener cyPropertyListener, CyProperty<Properties> cyPropertyServiceRef, String restPortNumber) throws Exception {
        CIResponseFactoryImpl ciResponseFactory = new CIResponseFactoryImpl();
        CIErrorFactoryImpl ciErrorFactory = new CIErrorFactoryImpl(this.logLocation);
        CIExceptionFactoryImpl ciExceptionFactory = new CIExceptionFactoryImpl();
        this.registerService(bc, ciResponseFactory, CIResponseFactory.class, new Properties());
        this.registerService(bc, ciExceptionFactory, CIExceptionFactory.class, new Properties());
        this.registerService(bc, ciErrorFactory, CIErrorFactory.class, new Properties());
        this.registerService(bc, new CyJSONUtilImpl(), CyJSONUtil.class, new Properties());
        MappingFactoryManager mappingFactoryManager = new MappingFactoryManager();
        this.registerServiceListener(bc, mappingFactoryManager::addFactory, mappingFactoryManager::removeFactory, VisualMappingFunctionFactory.class);
        GraphicsWriterManager graphicsWriterManager = new GraphicsWriterManager();
        this.registerServiceListener(bc, graphicsWriterManager::addFactory, graphicsWriterManager::removeFactory, PresentationWriterFactory.class);
        CyNetworkViewWriterFactoryManager viewWriterManager = new CyNetworkViewWriterFactoryManager();
        this.registerServiceListener(bc, viewWriterManager::addFactory, viewWriterManager::removeFactory, CyNetworkViewWriterFactory.class);
        this.automationAppTracker = new AutomationAppTracker(bc, bc.createFilter("(&(objectClass=*)(!(com.eclipsesource.jaxrs.publish=false)))"));
        this.automationAppTracker.open();
        bc.addBundleListener((BundleListener)this.automationAppTracker);
        HeadlessTaskMonitor headlessTaskMonitor = new HeadlessTaskMonitor();
        CyNetworkFactory netFact = (CyNetworkFactory)this.getService(bc, CyNetworkFactory.class);
        CyNetworkViewFactory netViewFact = (CyNetworkViewFactory)this.getService(bc, CyNetworkViewFactory.class);
        CyNetworkManager netMan = (CyNetworkManager)this.getService(bc, CyNetworkManager.class);
        CyRootNetworkManager cyRootNetworkManager = (CyRootNetworkManager)this.getService(bc, CyRootNetworkManager.class);
        CyNetworkViewManager netViewMan = (CyNetworkViewManager)this.getService(bc, CyNetworkViewManager.class);
        VisualMappingManager visMan = (VisualMappingManager)this.getService(bc, VisualMappingManager.class);
        CyApplicationManager applicationManager = (CyApplicationManager)this.getService(bc, CyApplicationManager.class);
        CyLayoutAlgorithmManager layoutManager = (CyLayoutAlgorithmManager)this.getService(bc, CyLayoutAlgorithmManager.class);
        VisualStyleFactory vsFactory = (VisualStyleFactory)this.getService(bc, VisualStyleFactory.class);
        CyGroupFactory groupFactory = (CyGroupFactory)this.getService(bc, CyGroupFactory.class);
        CyGroupManager groupManager = (CyGroupManager)this.getService(bc, CyGroupManager.class);
        CyTableManager tableManager = (CyTableManager)this.getService(bc, CyTableManager.class);
        CyTableFactory tableFactory = (CyTableFactory)this.getService(bc, CyTableFactory.class);
        StreamUtil streamUtil = (StreamUtil)this.getService(bc, StreamUtil.class);
        CySessionManager sessionManager = (CySessionManager)this.getService(bc, CySessionManager.class);
        SaveSessionAsTaskFactory saveSessionAsTaskFactory = (SaveSessionAsTaskFactory)this.getService(bc, SaveSessionAsTaskFactory.class);
        OpenSessionTaskFactory openSessionTaskFactory = (OpenSessionTaskFactory)this.getService(bc, OpenSessionTaskFactory.class);
        NewSessionTaskFactory newSessionTaskFactory = (NewSessionTaskFactory)this.getService(bc, NewSessionTaskFactory.class);
        CySwingApplication desktop = (CySwingApplication)this.getService(bc, CySwingApplication.class);
        ExportNetworkViewTaskFactory exportNetworkViewTaskFactory = (ExportNetworkViewTaskFactory)this.getService(bc, ExportNetworkViewTaskFactory.class);
        AvailableCommands available = (AvailableCommands)this.getService(bc, AvailableCommands.class);
        CommandExecutorTaskFactory ceTaskFactory = (CommandExecutorTaskFactory)this.getService(bc, CommandExecutorTaskFactory.class);
        SynchronousTaskManager synchronousTaskManager = (SynchronousTaskManager)this.getService(bc, SynchronousTaskManager.class);
        CyServiceRegistrar serviceRegistrar = (CyServiceRegistrar)this.getService(bc, CyServiceRegistrar.class);
        CyEventHelper cyEventHelper = (CyEventHelper)this.getService(bc, CyEventHelper.class);
        CyRESTCoreSwaggerAction swaggerCoreAction = new CyRESTCoreSwaggerAction(serviceRegistrar, this.cyRESTPort);
        this.registerService(bc, (Object)swaggerCoreAction, CyAction.class, new Properties());
        CyRESTCommandSwaggerAction swaggerCommandAction = new CyRESTCommandSwaggerAction(serviceRegistrar, this.cyRESTPort);
        this.registerService(bc, (Object)swaggerCommandAction, CyAction.class, new Properties());
        CyAutomationAction automationAction = new CyAutomationAction(serviceRegistrar);
        this.registerService(bc, (Object)automationAction, CyAction.class, new Properties());
        NewNetworkSelectedNodesAndEdgesTaskFactory networkSelectedNodesAndEdgesTaskFactory = (NewNetworkSelectedNodesAndEdgesTaskFactory)this.getService(bc, NewNetworkSelectedNodesAndEdgesTaskFactory.class);
        this.cytoscapeJsWriterFactory = new ServiceTracker(bc, bc.createFilter("(&(objectClass=org.cytoscape.io.write.CyNetworkViewWriterFactory)(id=cytoscapejsNetworkWriterFactory))"), null);
        this.cytoscapeJsWriterFactory.open();
        this.cytoscapeJsReaderFactory = new ServiceTracker(bc, bc.createFilter("(&(objectClass=org.cytoscape.io.read.InputStreamTaskFactory)(id=cytoscapejsNetworkReaderFactory))"), null);
        this.cytoscapeJsReaderFactory.open();
        LoadNetworkURLTaskFactory loadNetworkURLTaskFactory = (LoadNetworkURLTaskFactory)this.getService(bc, LoadNetworkURLTaskFactory.class);
        SelectFirstNeighborsTaskFactory selectFirstNeighborsTaskFactory = (SelectFirstNeighborsTaskFactory)this.getService(bc, SelectFirstNeighborsTaskFactory.class);
        NetworkViewTaskFactory fitContent = (NetworkViewTaskFactory)this.getService(bc, NetworkViewTaskFactory.class, "(title=Fit Content)");
        NetworkTaskFactory edgeBundler = (NetworkTaskFactory)this.getService(bc, NetworkTaskFactory.class, "(title=All Nodes and Edges)");
        NetworkViewCollectionTaskFactory clearEdgeBends = (NetworkViewCollectionTaskFactory)this.getService(bc, NetworkViewCollectionTaskFactory.class, "(id=clearAllEdgeBendsFactory)");
        NetworkViewTaskFactory showDetailsTaskFactory = (NetworkViewTaskFactory)this.getService(bc, NetworkViewTaskFactory.class, "(id=showGraphicsDetailsTaskFactory)");
        RenderingEngineManager renderingEngineManager = (RenderingEngineManager)this.getService(bc, RenderingEngineManager.class);
        WriterListener writerListener = new WriterListener();
        this.registerServiceListener(bc, writerListener::registerFactory, writerListener::unregisterFactory, VizmapWriterFactory.class);
        TaskFactoryManagerImpl taskFactoryManagerManager = new TaskFactoryManagerImpl();
        this.registerServiceListener(bc, taskFactoryManagerManager, "addTaskFactory", "removeTaskFactory", TaskFactory.class);
        this.registerServiceListener(bc, taskFactoryManagerManager, "addInputStreamTaskFactory", "removeInputStreamTaskFactory", InputStreamTaskFactory.class);
        this.registerServiceListener(bc, taskFactoryManagerManager, "addNetworkTaskFactory", "removeNetworkTaskFactory", NetworkTaskFactory.class);
        this.registerServiceListener(bc, taskFactoryManagerManager, "addNetworkCollectionTaskFactory", "removeNetworkCollectionTaskFactory", NetworkCollectionTaskFactory.class);
        BasicCyFileFilter elFilter = new BasicCyFileFilter(new String[]{"el"}, new String[]{"text/edgelist"}, "Edgelist files", DataCategory.NETWORK, streamUtil);
        EdgeListReaderFactory edgeListReaderFactory = new EdgeListReaderFactory((CyFileFilter)elFilter, netViewFact, netFact, netMan, cyRootNetworkManager);
        Properties edgeListReaderFactoryProps = new Properties();
        edgeListReaderFactoryProps.setProperty("ID", "edgeListReaderFactory");
        this.registerService(bc, (Object)edgeListReaderFactory, InputStreamTaskFactory.class, edgeListReaderFactoryProps);
        BundleResourceProvider bundleResourceProvider = new BundleResourceProvider(bc);
        HashMap shimResources = new HashMap();
        shimResources.put(ClusterMaker2Resource.class, null);
        CoreServiceModule coreServiceModule = new CoreServiceModule(this.allAppsStartedListener, netMan, netViewMan, netFact, taskFactoryManagerManager, applicationManager, visMan, this.cytoscapeJsWriterFactory, this.cytoscapeJsReaderFactory, this.automationAppTracker, layoutManager, writerListener, headlessTaskMonitor, tableManager, vsFactory, cyEventHelper, mappingFactoryManager, groupFactory, groupManager, cyRootNetworkManager, loadNetworkURLTaskFactory, cyPropertyListener, cyPropertyServiceRef, networkSelectedNodesAndEdgesTaskFactory, edgeListReaderFactory, netViewFact, tableFactory, fitContent, new EdgeBundlerImpl(edgeBundler), new ClearAllEdgeBendsImpl(clearEdgeBends), renderingEngineManager, sessionManager, saveSessionAsTaskFactory, openSessionTaskFactory, newSessionTaskFactory, desktop, new LevelOfDetails(showDetailsTaskFactory), selectFirstNeighborsTaskFactory, graphicsWriterManager, exportNetworkViewTaskFactory, available, ceTaskFactory, synchronousTaskManager, viewWriterManager, bundleResourceProvider, restPortNumber, this.logLocation, ciResponseFactory, ciErrorFactory, ciExceptionFactory);
        this.resourceManager = new ResourceManager(bc, CyRESTConstants.coreResourceClasses, (Module)coreServiceModule, shimResources);
    }

    public void shutDown() {
        logger.info("Shutting down REST server...");
        this.automationAppTracker.close();
        if (this.resourceManager != null) {
            this.resourceManager.unregisterResourceServices();
        }
        if (this.osgiJAXRSManager != null) {
            try {
                this.osgiJAXRSManager.uninstallOSGiJAXRSBundles();
            }
            catch (BundleException e) {
                this.serverState = ServerState.FAILED_STOP;
                logger.error("Error shutting down REST server", (Throwable)e);
                e.printStackTrace();
            }
        }
        if (this.cytoscapeJsWriterFactory != null) {
            this.cytoscapeJsWriterFactory.close();
        }
        if (this.cytoscapeJsReaderFactory != null) {
            this.cytoscapeJsReaderFactory.close();
        }
        super.shutDown();
    }

    public static enum ServerState {
        STARTING,
        STARTED,
        SUGGEST_RESTART,
        FAILED_INITIALIZATION,
        FAILED_STOP,
        STOPPED;

    }

    public class WriterListener {
        private VizmapWriterFactory jsFactory;

        public void registerFactory(VizmapWriterFactory factory, Map props) {
            if (factory != null && factory.getClass().getSimpleName().equals("CytoscapeJsVisualStyleWriterFactory")) {
                this.jsFactory = factory;
            }
        }

        public void unregisterFactory(VizmapWriterFactory factory, Map props) {
        }

        public VizmapWriterFactory getFactory() {
            return this.jsFactory;
        }
    }

    class EdgeBundlerImpl
    implements EdgeBundler {
        private final NetworkTaskFactory bundler;

        public EdgeBundlerImpl(NetworkTaskFactory tf) {
            this.bundler = tf;
        }

        @Override
        public NetworkTaskFactory getBundlerTF() {
            return this.bundler;
        }
    }

    class ClearAllEdgeBendsImpl
    implements ClearAllEdgeBends {
        private final NetworkViewCollectionTaskFactory clearAllEdgeBendsTF;

        public ClearAllEdgeBendsImpl(NetworkViewCollectionTaskFactory clearAllEdgeBendsTF) {
            this.clearAllEdgeBendsTF = clearAllEdgeBendsTF;
        }

        @Override
        public NetworkViewCollectionTaskFactory getClearAllEdgeBendsTF() {
            return this.clearAllEdgeBendsTF;
        }
    }

    public class LevelOfDetails {
        private final NetworkViewTaskFactory lod;

        public LevelOfDetails(NetworkViewTaskFactory tf) {
            this.lod = tf;
        }

        public NetworkViewTaskFactory getLodTF() {
            return this.lod;
        }
    }
}

