/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.LargestSubnetwork;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.command.StringToModel;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.create.NewNetworkSelectedNodesOnlyTaskFactory;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.view.layout.LayoutNode;
import org.cytoscape.view.layout.LayoutPartition;
import org.cytoscape.view.layout.PartitionUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.swing.DialogTaskManager;

public class LargestConnectedComponentTask
extends AbstractTask
implements TunableValidator,
ObservableTask {
    private CyServiceRegistrar serviceRegistrar;
    private CyApplicationManager applicationManager;
    private CyNetworkViewManager cynetworkviewmanager;
    private CySwingApplication swingApplication;
    private CyNetworkView view;
    private CyNetwork networks;
    private StringToModel stringToModel;
    private List<LayoutPartition> partitionList = null;
    private List<LayoutNode> layoutNodeList = new ArrayList<LayoutNode>();
    private List<LayoutNode> tempNodeList = new ArrayList<LayoutNode>();
    private List<LayoutNode> secondLargestNodeList = new ArrayList<LayoutNode>();
    private List<LayoutNode> largestNodeList = new ArrayList<LayoutNode>();
    private ArrayList<Double> partlist = new ArrayList();
    private List<CyNode> res = new ArrayList<CyNode>();
    private List<CyNode> temp = new ArrayList<CyNode>();
    private List<CyNode> selectNode = new ArrayList<CyNode>();
    private CyNode eachNode;
    private CyNode startNode;
    private Collection<CyNetworkView> viewCollection;
    @Tunable(description="Network to select?", context="nogui", exampleStringValue="current", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.")
    public String network = null;
    @Tunable(description="Create subnetwork?", context="nogui", exampleStringValue="false", longDescription="If true, new subnetwork will be created.")
    public Boolean createSubnetwork = false;
    @Tunable(description="Must contain this node?", context="nogui", exampleStringValue="suid:114", longDescription="Selects a node by name, or, if the parameter has the prefix suid:, selects a node by SUID.")
    public String includesNode = null;

    static void setSelectedState(CyNetwork networks, Collection<? extends CyIdentifiable> list, Boolean selected) {
        for (CyIdentifiable cyIdentifiable : list) {
            CyRow row = networks.getRow(cyIdentifiable);
            row.set("selected", (Object)selected);
        }
    }

    public LargestConnectedComponentTask(CyApplicationManager applicationManager, CyNetworkView view, CyNetwork networks, CySwingApplication swingApplication, StringToModel stringToModel, CyNetworkViewManager cynetworkviewmanager, CyServiceRegistrar serviceRegistrar) {
        this.applicationManager = applicationManager;
        this.view = view;
        this.networks = networks;
        this.swingApplication = swingApplication;
        this.stringToModel = stringToModel;
        this.cynetworkviewmanager = cynetworkviewmanager;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        if (this.view == null) {
            return;
        }
        if (this.network == null) {
            this.networks = this.networks;
            this.view = this.view;
        } else {
            this.networks = this.stringToModel.getNetwork(this.network);
            this.viewCollection = this.cynetworkviewmanager.getNetworkViews(this.networks);
            this.view = this.viewCollection.iterator().next();
        }
        LargestConnectedComponentTask.setSelectedState(this.networks, CyTableUtil.getNodesInState((CyNetwork)this.networks, (String)"selected", (boolean)true), false);
        LargestConnectedComponentTask.setSelectedState(this.networks, CyTableUtil.getEdgesInState((CyNetwork)this.networks, (String)"selected", (boolean)true), false);
        ArrayList<List<LayoutNode>> nestedList = new ArrayList<List<LayoutNode>>();
        this.partitionList = PartitionUtil.partition((CyNetworkView)this.view, (boolean)false, null);
        if (this.partitionList.size() == 0) {
            tm.showMessage(TaskMonitor.Level.WARN, "Empty network!");
            return;
        }
        if (this.partitionList.size() == 1) {
            LargestConnectedComponentTask.setSelectedState(this.networks, CyTableUtil.getNodesInState((CyNetwork)this.networks, (String)"selected", (boolean)false), true);
            this.res = CyTableUtil.getNodesInState((CyNetwork)this.networks, (String)"selected", (boolean)true);
        } else {
            for (LayoutPartition partition : this.partitionList) {
                this.layoutNodeList = partition.getNodeList();
                nestedList.add(this.layoutNodeList);
            }
            if (this.includesNode == null) {
                Collections.sort(nestedList, new Comparator<List<LayoutNode>>(){

                    @Override
                    public int compare(List<LayoutNode> a1, List<LayoutNode> a2) {
                        return a2.size() - a1.size();
                    }
                });
                this.largestNodeList = (List)nestedList.get(0);
                this.secondLargestNodeList = (List)nestedList.get(1);
                int largestSize = this.largestNodeList.size();
                int secondSize = this.secondLargestNodeList.size();
                for (LayoutNode layoutNode : this.largestNodeList) {
                    this.eachNode = layoutNode.getNode();
                    this.res.add(this.eachNode);
                }
                LargestConnectedComponentTask.setSelectedState(this.networks, this.res, true);
                if (largestSize == secondSize) {
                    tm.setTitle("Largest connected component is not unique");
                    tm.showMessage(TaskMonitor.Level.WARN, "There is more than one largest connected component. One was selected randomly.");
                }
            } else {
                this.selectNode = this.stringToModel.getNodeList(this.networks, this.includesNode);
                if (this.selectNode.size() == 0) {
                    tm.showMessage(TaskMonitor.Level.ERROR, "No nodes found. Please enter correct node.");
                    return;
                }
                if (this.selectNode.size() != 1) {
                    tm.showMessage(TaskMonitor.Level.ERROR, "Only one node can be included. Please only enter one node.");
                    return;
                }
                this.startNode = this.selectNode.get(0);
                ArrayList<CyNode> tempList = new ArrayList<CyNode>();
                for (List list : nestedList) {
                    for (LayoutNode layoutNode : list) {
                        this.eachNode = layoutNode.getNode();
                        tempList.add(this.eachNode);
                    }
                    if (tempList.contains(this.startNode)) {
                        this.res = tempList;
                        break;
                    }
                    tempList.clear();
                }
                LargestConnectedComponentTask.setSelectedState(this.networks, this.res, true);
            }
        }
        if (this.createSubnetwork.booleanValue()) {
            DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
            NewNetworkSelectedNodesOnlyTaskFactory factory = (NewNetworkSelectedNodesOnlyTaskFactory)this.serviceRegistrar.getService(NewNetworkSelectedNodesOnlyTaskFactory.class);
            taskManager.execute(factory.createTaskIterator(this.networks));
        }
    }

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        return TunableValidator.ValidationState.OK;
    }

    public Object getResults(Class type) {
        ArrayList<CyNode> identifiables = new ArrayList<CyNode>();
        if (this.res != null) {
            identifiables.addAll(this.res);
        }
        if (type.equals(List.class)) {
            return identifiables;
        }
        if (type.equals(String.class)) {
            if (this.res.size() == 0) {
                return "<none>";
            }
            String ret = "";
            if (this.res != null && this.res.size() > 0) {
                ret = ret + "Nodes selected: \n";
                for (CyNode node : this.res) {
                    ret = ret + "   " + (String)this.networks.getRow((CyIdentifiable)node).get("name", String.class) + "\n";
                }
            }
            return ret;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult resJson = () -> {
                if (identifiables == null || identifiables.size() == 0) {
                    return "{}";
                }
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                String result = "{\"nodes\":";
                result = this.res == null || this.res.size() == 0 ? result + "[]" : result + cyJSONUtil.cyIdentifiablesToJson(this.res);
                return result + "}";
            };
            return resJson;
        }
        return identifiables;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, List.class, JSONResult.class);
    }
}

