/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.opencl.layout;

import java.util.Properties;
import org.cytoscape.cycl.CyCLDevice;
import org.cytoscape.cycl.CyCLFactory;
import org.cytoscape.opencl.layout.CLLayout;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.work.undo.UndoSupport;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyActivator
extends AbstractCyActivator {
    private final Logger logger = LoggerFactory.getLogger(CyActivator.class);

    public void start(BundleContext bc) {
        this.registerServiceListener(bc, (cycl, props) -> this.initialize(bc, (CyCLFactory)cycl), (cycl, props) -> {}, CyCLFactory.class);
    }

    private void initialize(BundleContext bc, CyCLFactory cycl) {
        new Thread(() -> {
            try {
                if (!cycl.isInitialized()) {
                    this.logger.error("OpenCL did not initialize. Cannot register 'Prefuse Force Directed OpenCL Layout'.");
                    return;
                }
                CyCLDevice device = cycl.getDevice();
                UndoSupport undo = (UndoSupport)this.getService(bc, UndoSupport.class);
                CLLayout forceDirectedCLLayout = new CLLayout(undo, device);
                Properties forceDirectedCLLayoutProps = new Properties();
                forceDirectedCLLayoutProps.setProperty("preferredMenu", "Layout.Cytoscape Layouts");
                forceDirectedCLLayoutProps.setProperty("preferredTaskManager", "menu");
                forceDirectedCLLayoutProps.setProperty("title", forceDirectedCLLayout.toString());
                forceDirectedCLLayoutProps.setProperty("menuGravity", "10.5");
                this.registerService(bc, (Object)forceDirectedCLLayout, CyLayoutAlgorithm.class, forceDirectedCLLayoutProps);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }
}

