/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.opencl.layout;

import java.util.HashSet;
import java.util.Set;
import org.cytoscape.cycl.CyCLDevice;
import org.cytoscape.model.CyNode;
import org.cytoscape.opencl.layout.CLLayoutContext;
import org.cytoscape.opencl.layout.CLLayoutTask;
import org.cytoscape.view.layout.AbstractLayoutAlgorithm;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.undo.UndoSupport;

public class CLLayout
extends AbstractLayoutAlgorithm {
    private static final String ALGORITHM_ID = "force-directed-cl";
    static final String ALGORITHM_DISPLAY_NAME = "Prefuse Force Directed OpenCL Layout";
    final CyCLDevice device;

    public CLLayout(UndoSupport undo, CyCLDevice device) {
        super(ALGORITHM_ID, ALGORITHM_DISPLAY_NAME, undo);
        this.device = device;
    }

    public TaskIterator createTaskIterator(CyNetworkView networkView, Object context, Set<View<CyNode>> nodesToLayOut, String attrName) {
        return new TaskIterator(new Task[]{new CLLayoutTask(this.toString(), this.device, networkView, nodesToLayOut, (CLLayoutContext)context, attrName, this.undoSupport)});
    }

    public Object createLayoutContext() {
        return new CLLayoutContext();
    }

    public Set<Class<?>> getSupportedEdgeAttributeTypes() {
        HashSet ret = new HashSet();
        ret.add(Integer.class);
        ret.add(Double.class);
        return ret;
    }

    public boolean getSupportsSelectedOnly() {
        return true;
    }
}

