/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.intr;

import java.io.Serializable;
import org.cytoscape.util.intr.LongEnumerator;

public final class MinLongHeap
implements Serializable {
    private static final long serialVersionUID = 1213745949141430L;
    private static final int DEFAULT_CAPACITY = 11;
    private long[] m_heap = new long[12];
    private int m_currentSize;
    private boolean m_orderOK;

    public MinLongHeap() {
        this.m_heap[0] = Integer.MIN_VALUE;
        this.m_currentSize = 0;
        this.m_orderOK = true;
    }

    public final void empty() {
        this.m_currentSize = 0;
        this.m_orderOK = true;
    }

    public final int size() {
        return this.m_currentSize;
    }

    public final boolean isOrdered() {
        return this.m_orderOK;
    }

    public final void toss(long x) {
        try {
            this.m_heap[++this.m_currentSize] = x;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            --this.m_currentSize;
            this.checkSize(1);
            this.m_heap[++this.m_currentSize] = x;
        }
        this.m_orderOK = false;
    }

    public final void toss(long[] elements, int beginIndex, int length) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex is less than zero");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("length is less than zero");
        }
        if ((long)beginIndex + (long)length > (long)elements.length) {
            throw new IndexOutOfBoundsException("combination of beginIndex and length exceed length of array");
        }
        this.checkSize(length);
        System.arraycopy(elements, beginIndex, this.m_heap, this.m_currentSize + 1, length);
        this.m_currentSize += length;
        this.m_orderOK = false;
    }

    public final void insert(long x) {
        try {
            this.m_heap[++this.m_currentSize] = x;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            --this.m_currentSize;
            this.checkSize(1);
            this.m_heap[++this.m_currentSize] = x;
        }
        if (this.m_orderOK) {
            MinLongHeap.percolateUp(this.m_heap, this.m_currentSize);
        }
    }

    public final long findMin() {
        if (!this.m_orderOK) {
            for (int i = this.m_currentSize / 2; i > 0; --i) {
                MinLongHeap.percolateDown(this.m_heap, i, this.m_currentSize);
            }
            this.m_orderOK = true;
        }
        return this.m_heap[1];
    }

    public final long deleteMin() {
        if (!this.m_orderOK) {
            for (int i = this.m_currentSize / 2; i > 0; --i) {
                MinLongHeap.percolateDown(this.m_heap, i, this.m_currentSize);
            }
            this.m_orderOK = true;
        }
        long returnThis = this.m_heap[1];
        this.m_heap[1] = this.m_heap[this.m_currentSize--];
        MinLongHeap.percolateDown(this.m_heap, 1, this.m_currentSize);
        return returnThis;
    }

    private final void checkSize(int newElements) {
        if (this.m_currentSize < this.m_heap.length - newElements) {
            return;
        }
        long newHeapSize = Math.max((long)this.m_heap.length + (long)newElements, Math.min(Integer.MAX_VALUE, (long)this.m_heap.length * 2L + 1L));
        if (newHeapSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("cannot allocate large enough array");
        }
        long[] newHeap = new long[(int)newHeapSize];
        System.arraycopy(this.m_heap, 0, newHeap, 0, this.m_heap.length);
        this.m_heap = newHeap;
    }

    private static final void percolateUp(long[] heap, int childIndex) {
        int parentIndex = childIndex / 2;
        while (heap[childIndex] < heap[parentIndex]) {
            MinLongHeap.swap(heap, parentIndex, childIndex);
            childIndex = parentIndex;
            parentIndex /= 2;
        }
    }

    private static final void percolateDown(long[] heap, int parentIndex, int size) {
        for (int childIndex = parentIndex * 2; childIndex <= size && childIndex > 0; childIndex *= 2) {
            if (childIndex + 1 <= size && heap[childIndex + 1] < heap[childIndex]) {
                ++childIndex;
            }
            if (heap[childIndex] >= heap[parentIndex]) break;
            MinLongHeap.swap(heap, parentIndex, childIndex);
            parentIndex = childIndex;
        }
    }

    private static final void swap(long[] arr, int index1, int index2) {
        long temp = arr[index1];
        arr[index1] = arr[index2];
        arr[index2] = temp;
    }

    public final LongEnumerator orderedElements(boolean pruneDuplicates) {
        final long[] heap = this.m_heap;
        final int size = this.m_currentSize;
        if (!this.m_orderOK) {
            for (int i = size / 2; i > 0; --i) {
                MinLongHeap.percolateDown(heap, i, size);
            }
        }
        this.m_orderOK = false;
        if (pruneDuplicates) {
            int dups = 0;
            for (int sizeIter = size; sizeIter > 1; --sizeIter) {
                MinLongHeap.swap(heap, 1, sizeIter);
                MinLongHeap.percolateDown(heap, 1, sizeIter - 1);
                if (heap[1] != heap[sizeIter]) continue;
                ++dups;
            }
            final int numDuplicates = dups;
            return new LongEnumerator(){
                int m_index;
                int m_dups;
                long m_prevValue;
                {
                    this.m_index = size;
                    this.m_dups = numDuplicates;
                    this.m_prevValue = heap[this.m_index] + 1L;
                }

                @Override
                public int numRemaining() {
                    return this.m_index - this.m_dups;
                }

                @Override
                public long nextLong() {
                    while (heap[this.m_index] == this.m_prevValue) {
                        --this.m_dups;
                        --this.m_index;
                    }
                    this.m_prevValue = heap[this.m_index--];
                    return this.m_prevValue;
                }
            };
        }
        return new LongEnumerator(){
            int m_size;
            {
                this.m_size = size;
            }

            @Override
            public int numRemaining() {
                return this.m_size;
            }

            @Override
            public long nextLong() {
                try {
                    MinLongHeap.swap(heap, 1, this.m_size);
                }
                catch (Exception e) {
                    return -1L;
                }
                MinLongHeap.percolateDown(heap, 1, this.m_size - 1);
                return heap[this.m_size--];
            }
        };
    }

    public final LongEnumerator elements() {
        final long[] heap = this.m_heap;
        final int size = this.m_currentSize;
        return new LongEnumerator(){
            int index = 0;

            @Override
            public int numRemaining() {
                return size - this.index;
            }

            @Override
            public long nextLong() {
                return heap[++this.index];
            }
        };
    }

    public final void copyInto(long[] output, int beginIndex) {
        System.arraycopy(this.m_heap, 1, output, beginIndex, this.m_currentSize);
    }
}

