/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.intr;

import java.io.Serializable;
import org.cytoscape.util.intr.LongEnumerator;

public final class LongStack
implements Serializable {
    private static final long serialVersionUID = 1213745949153047L;
    private static final int DEFAULT_CAPACITY = 11;
    private long[] m_stack = new long[11];
    private int m_currentSize;

    public LongStack() {
        this.empty();
    }

    public final void empty() {
        this.m_currentSize = 0;
    }

    public final int size() {
        return this.m_currentSize;
    }

    public final void push(long value) {
        try {
            this.m_stack[this.m_currentSize++] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            --this.m_currentSize;
            this.checkSize();
            this.m_stack[this.m_currentSize++] = value;
        }
    }

    public final long peek() {
        return this.m_stack[this.m_currentSize - 1];
    }

    public final long pop() {
        try {
            return this.m_stack[--this.m_currentSize];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            ++this.m_currentSize;
            throw e;
        }
    }

    public final LongEnumerator elements() {
        final long[] stack = this.m_stack;
        final int size = this.m_currentSize;
        return new LongEnumerator(){
            private int inx;
            {
                this.inx = size;
            }

            @Override
            public final int numRemaining() {
                return this.inx;
            }

            @Override
            public final long nextLong() {
                return stack[--this.inx];
            }
        };
    }

    private final void checkSize() {
        if (this.m_currentSize < this.m_stack.length) {
            return;
        }
        int newStackSize = (int)Math.min(Integer.MAX_VALUE, (long)this.m_stack.length * 2L + 1L);
        if (newStackSize == this.m_stack.length) {
            throw new IllegalStateException("cannot allocate large enough array");
        }
        long[] newStack = new long[newStackSize];
        System.arraycopy(this.m_stack, 0, newStack, 0, this.m_stack.length);
        this.m_stack = newStack;
    }
}

