/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.graph.render.stateful;

import java.awt.geom.Rectangle2D;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.canvas.NetworkTransform;
import org.cytoscape.graph.render.stateful.GraphLOD;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.model.spacial.EdgeSpacialIndex2DEnumerator;
import org.cytoscape.view.model.spacial.NetworkSpacialIndex2D;
import org.cytoscape.view.model.spacial.NodeSpacialIndex2DEnumerator;
import org.cytoscape.view.model.spacial.SpacialIndex2DEnumerator;

public class RenderDetailFlags {
    public static final int LOD_HIGH_DETAIL = 2;
    public static final int LOD_NODE_BORDERS = 4;
    public static final int LOD_NODE_LABELS = 8;
    public static final int LOD_EDGE_ARROWS = 16;
    public static final int LOD_DASHED_EDGES = 32;
    public static final int LOD_EDGE_ANCHORS = 64;
    public static final int LOD_EDGE_LABELS = 128;
    public static final int LOD_TEXT_AS_SHAPE = 256;
    public static final int LOD_CUSTOM_GRAPHICS = 512;
    public static final int OPT_EDGE_BUFF_PAN = 1024;
    public static final int OPT_LABEL_CACHE = 2048;
    public static final int OPT_PDF_FONT_HACK = 4096;
    private final int lodBits;
    private final GraphLOD.RenderEdges renderEdges;
    private final int nodeCount;
    private final int edgeCountEstimate;

    private RenderDetailFlags(int lodBits, GraphLOD.RenderEdges renderEdges, int nodeCount, int edgeCountEstimate) {
        this.lodBits = lodBits;
        this.renderEdges = renderEdges;
        this.nodeCount = nodeCount;
        this.edgeCountEstimate = edgeCountEstimate;
    }

    public RenderDetailFlags add(int opts) {
        return new RenderDetailFlags(this.lodBits | opts, this.renderEdges, this.nodeCount, this.edgeCountEstimate);
    }

    public GraphLOD.RenderEdges renderEdges() {
        return this.renderEdges;
    }

    public int getVisibleNodeCount() {
        return this.nodeCount;
    }

    public int getEstimatedEdgeCount() {
        return this.edgeCountEstimate;
    }

    public boolean not(int flag) {
        return (this.lodBits & flag) == 0;
    }

    public boolean has(int flag) {
        return (this.lodBits & flag) != 0;
    }

    public boolean all(int ... flags) {
        for (int flag : flags) {
            if (!this.not(flag)) continue;
            return false;
        }
        return true;
    }

    public boolean any(int ... flags) {
        for (int flag : flags) {
            if (!this.has(flag)) continue;
            return true;
        }
        return false;
    }

    public boolean treatNodeShapesAsRectangle() {
        return this.not(2);
    }

    public static GraphLOD.RenderEdges renderEdges(CyNetworkViewSnapshot netView, NetworkTransform transform, GraphLOD lod) {
        Rectangle2D.Float area = transform.getNetworkVisibleAreaNodeCoords();
        SpacialIndex2DEnumerator nodeHits = netView.getSpacialIndex2D().queryOverlap(area.x, area.y, area.x + area.width, area.y + area.height);
        int visibleNodeCount = nodeHits.size();
        int totalNodeCount = netView.getNodeCount();
        int totalEdgeCount = netView.getEdgeCount();
        return lod.renderEdges(visibleNodeCount, totalNodeCount, totalEdgeCount);
    }

    public static RenderDetailFlags create(CyNetworkViewSnapshot netView, NetworkTransform transform, GraphLOD lod, DRenderingEngine.UpdateType updateType) {
        Rectangle2D.Float area = transform.getNetworkVisibleAreaNodeCoords();
        SpacialIndex2DEnumerator nodeHits = netView.getSpacialIndex2D().queryOverlap(area.x, area.y, area.x + area.width, area.y + area.height);
        int visibleNodeCount = nodeHits.size();
        return RenderDetailFlags.create(netView, visibleNodeCount, lod, updateType);
    }

    public static RenderDetailFlags create(CyNetworkViewSnapshot netView, int visibleNodeCount, GraphLOD lod) {
        return RenderDetailFlags.create(netView, visibleNodeCount, lod, DRenderingEngine.UpdateType.ALL_FULL);
    }

    private static RenderDetailFlags create(CyNetworkViewSnapshot netView, int visibleNodeCount, GraphLOD lod, DRenderingEngine.UpdateType updateType) {
        int totalEdgeCount;
        int totalNodeCount = netView.getNodeCount();
        GraphLOD.RenderEdges renderEdges = lod.renderEdges(visibleNodeCount, totalNodeCount, totalEdgeCount = netView.getEdgeCount());
        int renderEdgeCount = renderEdges == GraphLOD.RenderEdges.ALL ? totalEdgeCount : (renderEdges == GraphLOD.RenderEdges.NONE ? 0 : RenderDetailFlags.estimateEdgeCount(totalNodeCount, visibleNodeCount, totalEdgeCount));
        int lodBits = RenderDetailFlags.lodToBits(netView, visibleNodeCount, renderEdgeCount, lod, updateType);
        return new RenderDetailFlags(lodBits, renderEdges, visibleNodeCount, renderEdgeCount);
    }

    private static int estimateEdgeCount(int totalNodeCount, int visibleNodeCount, int totalEdgeCount) {
        if (visibleNodeCount <= 0) {
            return 0;
        }
        int estimate = 2 * (int)((double)totalEdgeCount * ((double)visibleNodeCount / (double)totalNodeCount));
        return Math.min(totalEdgeCount, estimate);
    }

    public static int[] countNodesEdges(DRenderingEngine re) {
        Rectangle2D.Float area = re.getTransform().getNetworkVisibleAreaNodeCoords();
        CyNetworkViewSnapshot netView = re.getViewModelSnapshot();
        NetworkSpacialIndex2D spacialIndex = netView.getSpacialIndex2D();
        NodeSpacialIndex2DEnumerator nodeHits = spacialIndex.queryOverlapNodes(area.x, area.y, area.x + area.width, area.y + area.height, null);
        int nodeCount = nodeHits.size();
        EdgeSpacialIndex2DEnumerator edgeHits = spacialIndex.queryOverlapEdges(area.x, area.y, area.x + area.width, area.y + area.height, null);
        int edgeCount = edgeHits.size();
        return new int[]{nodeCount, edgeCount};
    }

    private static int lodToBits(CyNetworkViewSnapshot netView, int renderNodeCount, int renderEdgeCount, GraphLOD lod, DRenderingEngine.UpdateType updateType) {
        int lodbits = 0;
        boolean highDetail = lod.detail(renderNodeCount, renderEdgeCount);
        if (highDetail) {
            lodbits |= 2;
            if (lod.nodeBorders(renderNodeCount, renderEdgeCount)) {
                lodbits |= 4;
            }
            if (lod.nodeLabels(renderNodeCount, renderEdgeCount)) {
                lodbits |= 8;
            }
            if (lod.edgeArrows(renderNodeCount, renderEdgeCount)) {
                lodbits |= 0x10;
            }
            if (lod.dashedEdges(renderNodeCount, renderEdgeCount)) {
                lodbits |= 0x20;
            }
            if (lod.edgeAnchors(renderNodeCount, renderEdgeCount)) {
                lodbits |= 0x40;
            }
            if (lod.edgeLabels(renderNodeCount, renderEdgeCount)) {
                lodbits |= 0x80;
            }
            if (((lodbits & 8) != 0 || (lodbits & 0x80) != 0) && lod.textAsShape(renderNodeCount, renderEdgeCount)) {
                lodbits |= 0x100;
            }
            if (lod.customGraphics(renderNodeCount, renderEdgeCount)) {
                lodbits |= 0x200;
            }
        }
        if (lod.isEdgeBufferPanEnabled()) {
            lodbits |= 0x400;
        }
        if (lod.isLabelCacheEnabled()) {
            lodbits |= 0x800;
        }
        return lodbits;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lodBits;
        result = 31 * result + this.renderEdges.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RenderDetailFlags) {
            RenderDetailFlags other = (RenderDetailFlags)obj;
            return this.lodBits == other.lodBits && this.renderEdges == other.renderEdges;
        }
        return false;
    }
}

