/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.graph.render.stateful;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.cytoscape.graph.render.stateful.LabelInfo;
import org.cytoscape.graph.render.stateful.LabelInfoProvider;

public class LabelInfoCache
implements LabelInfoProvider {
    private final Cache<Key, LabelInfo> labelCache;

    public LabelInfoCache(int maxSize, boolean recordStats) {
        CacheBuilder builder = CacheBuilder.newBuilder().maximumSize((long)maxSize);
        if (recordStats) {
            builder = builder.recordStats();
        }
        this.labelCache = builder.build();
    }

    @Override
    public LabelInfo getLabelInfo(String text, Font font, double labelWidth, FontRenderContext frc) {
        try {
            return this.getLabelInfoImpl(text, font, labelWidth, frc);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private LabelInfo getLabelInfoImpl(String text, Font font, double labelWidth, FontRenderContext frc) throws ExecutionException {
        return (LabelInfo)this.labelCache.get((Object)new Key(text, font, labelWidth), () -> new LabelInfo(text, font, frc, false, labelWidth));
    }

    @Override
    public String getStats() {
        return String.valueOf(this.labelCache.stats());
    }

    public static class Key {
        private final String text;
        private final Font font;
        private final double labelWidth;

        private Key(String text, Font font, double labelWidth) {
            this.text = text;
            this.font = font;
            this.labelWidth = labelWidth;
        }

        public int hashCode() {
            return Objects.hash(this.font, this.labelWidth, this.text);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return Objects.equals(this.font, other.font) && Double.doubleToLongBits(this.labelWidth) == Double.doubleToLongBits(other.labelWidth) && Objects.equals(this.text, other.text);
        }
    }
}

