/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.graph.render.stateful;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.cytoscape.ding.DVisualLexicon;
import org.cytoscape.ding.internal.util.CustomGraphicsPositionCalculator;
import org.cytoscape.graph.render.stateful.NodeDetails;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.presentation.customgraphics.ImageCustomGraphicLayer;
import org.cytoscape.view.presentation.property.values.ObjectPosition;
import org.cytoscape.view.vizmap.VisualPropertyDependency;

public class CustomGraphicsInfo {
    private final VisualProperty<CyCustomGraphics> visualProperty;
    private CyCustomGraphics<? extends CustomGraphicLayer> customGraphics;
    private ObjectPosition position;
    private Double size;

    public CustomGraphicsInfo(VisualProperty<CyCustomGraphics> visualProperty) {
        this.visualProperty = visualProperty;
    }

    public VisualProperty<CyCustomGraphics> getVisualProperty() {
        return this.visualProperty;
    }

    public CyCustomGraphics<? extends CustomGraphicLayer> getCustomGraphics() {
        return this.customGraphics;
    }

    public void setCustomGraphics(CyCustomGraphics<? extends CustomGraphicLayer> customGraphics) {
        this.customGraphics = customGraphics;
    }

    public ObjectPosition getPosition() {
        return this.position;
    }

    public void setPosition(ObjectPosition position) {
        this.position = position;
    }

    public Double getSize() {
        return this.size;
    }

    public void setSize(Double size) {
        this.size = size;
    }

    public List<CustomGraphicLayer> createLayers(CyNetworkView netView, View<CyNode> nodeView, NodeDetails details, Set<VisualPropertyDependency<?>> dependencies) {
        if (this.customGraphics == null) {
            return Collections.emptyList();
        }
        List originalLayers = this.customGraphics.getLayers(netView, nodeView);
        if (originalLayers == null || originalLayers.isEmpty()) {
            return Collections.emptyList();
        }
        float fitRatio = this.customGraphics.getFitRatio();
        boolean sync = this.syncToNode(dependencies);
        Double cgSize = this.size;
        ObjectPosition cgPos = this.position;
        double nw = details.getWidth(nodeView);
        double nh = details.getHeight(nodeView);
        ArrayList<CustomGraphicLayer> transformedLayers = new ArrayList<CustomGraphicLayer>();
        Iterator iterator = originalLayers.iterator();
        while (iterator.hasNext()) {
            CustomGraphicLayer layer;
            CustomGraphicLayer finalLayer = layer = (CustomGraphicLayer)iterator.next();
            double cgw = 0.0;
            double cgh = 0.0;
            if (sync) {
                float bw = details.getBorderWidth(nodeView);
                cgw = nw - (double)bw;
                cgh = nh - (double)bw;
            } else {
                if (cgSize == null) {
                    VisualProperty<Double> sizeVP = DVisualLexicon.getAssociatedCustomGraphicsSizeVP(this.visualProperty);
                    cgSize = (Double)nodeView.getVisualProperty(sizeVP);
                }
                if (cgSize != null) {
                    cgw = cgh = cgSize.doubleValue();
                }
            }
            if (!(cgw > 0.0) || !(cgh > 0.0)) continue;
            finalLayer = this.syncSize(layer, cgw, cgh, fitRatio);
            if (cgPos == null) {
                cgPos = ObjectPosition.DEFAULT_POSITION;
            }
            finalLayer = this.moveLayer(finalLayer, cgPos, nw, nh);
            transformedLayers.add(finalLayer);
        }
        return transformedLayers;
    }

    private boolean syncToNode(Set<VisualPropertyDependency<?>> dependencies) {
        if (dependencies != null) {
            for (VisualPropertyDependency<?> dep : dependencies) {
                if (!dep.getIdString().equals("nodeCustomGraphicsSizeSync")) continue;
                return dep.isDependencyEnabled();
            }
        }
        return true;
    }

    private CustomGraphicLayer syncSize(CustomGraphicLayer layer, double width, double height, float fitRatio) {
        AffineTransform xform;
        Rectangle2D originalBounds = layer.getBounds2D();
        if (originalBounds == null) {
            return layer;
        }
        if (width == 0.0 || height == 0.0) {
            return layer;
        }
        double cgW = originalBounds.getWidth();
        double cgH = originalBounds.getHeight();
        if (width == cgW && height == cgH) {
            return layer;
        }
        if (layer instanceof ImageCustomGraphicLayer) {
            double scale = Math.min(width / cgW, height / cgH);
            xform = AffineTransform.getScaleInstance(scale * (double)fitRatio, scale * (double)fitRatio);
        } else {
            xform = AffineTransform.getScaleInstance((double)fitRatio * width / cgW, (double)fitRatio * height / cgH);
        }
        return layer.transform(xform);
    }

    private CustomGraphicLayer moveLayer(CustomGraphicLayer layer, ObjectPosition position, double nodeWidth, double nodeHeight) {
        CustomGraphicLayer newLayer = position != null ? CustomGraphicsPositionCalculator.transform(position, nodeWidth, nodeHeight, layer) : layer;
        return newLayer;
    }

    public int hashCode() {
        int prime = 37;
        int result = 5;
        result = prime * result + (this.visualProperty == null ? 0 : this.visualProperty.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomGraphicsInfo other = (CustomGraphicsInfo)obj;
        return !(this.visualProperty == null ? other.visualProperty != null : !this.visualProperty.equals(other.visualProperty));
    }

    public String toString() {
        return "CGInfo [customGraphics=" + this.customGraphics + ", position=" + this.position + ", size=" + this.size + "]";
    }
}

