/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.graph.render.immed.nodeshape;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.cytoscape.graph.render.immed.nodeshape.AbstractNodeShape;

public class OctagonNodeShape
extends AbstractNodeShape {
    private static final float SQRT2 = (float)Math.sqrt(2.0);
    private static final float SQRT2plus2 = 2.0f + SQRT2;
    private final GeneralPath path = new GeneralPath();

    public OctagonNodeShape() {
        super((byte)4);
    }

    @Override
    public Shape getShape(float xMin, float yMin, float xMax, float yMax) {
        float xx = (xMax - xMin) / SQRT2plus2;
        float xz = xx * SQRT2;
        float yx = (yMax - yMin) / SQRT2plus2;
        float yz = yx * SQRT2;
        this.path.reset();
        this.path.moveTo(xMin, yMin + yx);
        this.path.lineTo(xMin, yMin + yx + yz);
        this.path.lineTo(xMin + xx, yMax);
        this.path.lineTo(xMin + xx + xz, yMax);
        this.path.lineTo(xMax, yMin + yx + yz);
        this.path.lineTo(xMax, yMin + yx);
        this.path.lineTo(xMin + xx + xz, yMin);
        this.path.lineTo(xMin + xx, yMin);
        this.path.closePath();
        return this.path;
    }
}

