/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.graph.render.immed;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import org.cytoscape.ding.impl.canvas.GraphicsProvider;
import org.cytoscape.ding.impl.canvas.NetworkTransform;
import org.cytoscape.graph.render.immed.EdgeAnchors;
import org.cytoscape.graph.render.immed.arrow.Arrow;
import org.cytoscape.graph.render.immed.arrow.ArrowheadArrow;
import org.cytoscape.graph.render.immed.arrow.ArrowheadArrowShort;
import org.cytoscape.graph.render.immed.arrow.CrossDeltaArrow;
import org.cytoscape.graph.render.immed.arrow.DeltaArrow;
import org.cytoscape.graph.render.immed.arrow.DeltaArrowShort1;
import org.cytoscape.graph.render.immed.arrow.DeltaArrowShort2;
import org.cytoscape.graph.render.immed.arrow.DiamondArrow;
import org.cytoscape.graph.render.immed.arrow.DiamondArrowShort1;
import org.cytoscape.graph.render.immed.arrow.DiamondArrowShort2;
import org.cytoscape.graph.render.immed.arrow.DiscArrow;
import org.cytoscape.graph.render.immed.arrow.HalfBottomArrow;
import org.cytoscape.graph.render.immed.arrow.HalfCircleArrow;
import org.cytoscape.graph.render.immed.arrow.HalfTopArrow;
import org.cytoscape.graph.render.immed.arrow.NoArrow;
import org.cytoscape.graph.render.immed.arrow.SquareArrow;
import org.cytoscape.graph.render.immed.arrow.TeeArrow;
import org.cytoscape.graph.render.immed.nodeshape.DiamondNodeShape;
import org.cytoscape.graph.render.immed.nodeshape.EllipseNodeShape;
import org.cytoscape.graph.render.immed.nodeshape.HexagonNodeShape;
import org.cytoscape.graph.render.immed.nodeshape.LegacyCustomNodeShape;
import org.cytoscape.graph.render.immed.nodeshape.NodeShape;
import org.cytoscape.graph.render.immed.nodeshape.OctagonNodeShape;
import org.cytoscape.graph.render.immed.nodeshape.ParallelogramNodeShape;
import org.cytoscape.graph.render.immed.nodeshape.RectangleNodeShape;
import org.cytoscape.graph.render.immed.nodeshape.RoundedRectangleNodeShape;
import org.cytoscape.graph.render.immed.nodeshape.TriangleNodeShape;
import org.cytoscape.graph.render.immed.nodeshape.VeeNodeShape;
import org.cytoscape.graph.render.stateful.LabelLineInfo;
import org.cytoscape.graph.render.stateful.RenderDetailFlags;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.Cy2DGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.ImageCustomGraphicLayer;
import org.cytoscape.view.presentation.customgraphics.PaintedShape;
import org.cytoscape.view.presentation.property.ArrowShapeVisualProperty;
import org.cytoscape.view.presentation.property.values.ArrowShape;

public final class GraphGraphics {
    private static final boolean debug = false;
    public static final byte SHAPE_NONE = -1;
    public static final byte SHAPE_RECTANGLE = 0;
    public static final byte SHAPE_DIAMOND = 1;
    public static final byte SHAPE_ELLIPSE = 2;
    public static final byte SHAPE_HEXAGON = 3;
    public static final byte SHAPE_OCTAGON = 4;
    public static final byte SHAPE_PARALLELOGRAM = 5;
    public static final byte SHAPE_ROUNDED_RECTANGLE = 6;
    public static final byte SHAPE_TRIANGLE = 7;
    public static final byte SHAPE_VEE = 8;
    static final byte s_last_shape = 8;
    public static final int CUSTOM_SHAPE_MAX_VERTICES = 100;
    public static final int MAX_EDGE_ANCHORS = 256;
    private static final float DEF_SHAPE_SIZE = 32.0f;
    private static final double CURVE_ELLIPTICAL = 4.0 * (Math.sqrt(2.0) - 1.0) / 3.0;
    private byte m_lastCustomShapeType = (byte)8;
    private RenderDetailFlags renderDetailFlags;
    static final EdgeAnchors m_noAnchors = new EdgeAnchors(){

        @Override
        public final int numAnchors() {
            return 0;
        }

        @Override
        public final void getAnchor(int inx, float[] arr) {
        }
    };
    private static final Map<Float, Stroke> borderStrokes = new HashMap<Float, Stroke>();
    private static final Map<Byte, NodeShape> nodeShapes = new HashMap<Byte, NodeShape>();
    private static final Map<ArrowShape, Arrow> arrows;
    private final AffineTransform m_xformUtil = new AffineTransform();
    private final GeneralPath m_path2d = new GeneralPath();
    private final GeneralPath m_path2dPrime = new GeneralPath();
    private final Line2D.Double m_line2d = new Line2D.Double();
    private final double[] m_ptsBuff = new double[4];
    private final double[] m_edgePtsBuff = new double[1542];
    private final float[] m_floatBuff = new float[2];
    private final FontRenderContext m_fontRenderContextFull = new FontRenderContext(null, true, true);
    private final GraphicsProvider graphicsProvider;
    private Graphics2D m_g2d;
    private Graphics2D m_gMinimal;
    private final AffineTransform m_currNativeXform = new AffineTransform();

    public GraphGraphics(GraphicsProvider graphicsProvider) {
        this.graphicsProvider = graphicsProvider;
        this.m_path2dPrime.setWindingRule(0);
        this.update(null);
    }

    public NetworkTransform getTransform() {
        return this.graphicsProvider.getTransform();
    }

    public final void update(RenderDetailFlags flags) {
        this.update(flags, true);
    }

    public final void update(RenderDetailFlags flags, boolean clear) {
        this.renderDetailFlags = flags;
        if (this.m_gMinimal != null) {
            this.m_gMinimal.dispose();
            this.m_gMinimal = null;
        }
        if (this.m_g2d != null) {
            this.m_g2d.dispose();
        }
        this.m_g2d = this.graphicsProvider.getGraphics(clear);
        this.m_gMinimal = this.graphicsProvider.getGraphics(clear);
        GraphGraphics.setRenderingHints(this.m_g2d);
        GraphGraphics.setRenderingHintsMinimal(this.m_gMinimal);
        this.m_g2d.transform(this.getTransform().getPaintAffineTransform());
        this.m_currNativeXform.setTransform(this.m_g2d.getTransform());
    }

    public static void setRenderingHints(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setStroke(new BasicStroke(0.0f, 1, 1, 10.0f));
    }

    private static void setRenderingHintsMinimal(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
    }

    public final void drawNodeLow(float xMin, float yMin, float xMax, float yMax, Color fillColor) {
        this.m_ptsBuff[0] = xMin;
        this.m_ptsBuff[1] = yMin;
        this.m_ptsBuff[2] = xMax;
        this.m_ptsBuff[3] = yMax;
        this.getTransform().getPaintAffineTransform().transform(this.m_ptsBuff, 0, this.m_ptsBuff, 0, 2);
        int xNot = (int)this.m_ptsBuff[0];
        int yNot = (int)this.m_ptsBuff[1];
        int xOne = (int)this.m_ptsBuff[2];
        int yOne = (int)this.m_ptsBuff[3];
        this.m_gMinimal.setColor(fillColor);
        this.m_gMinimal.fillRect(xNot, yNot, Math.max(1, xOne - xNot), Math.max(1, yOne - yNot));
    }

    public final Shape drawNodeFull(byte nodeShape, float xMin, float yMin, float xMax, float yMax, Paint fillPaint, float borderWidth, Stroke borderStroke, Paint borderPaint) {
        float off = borderWidth / 2.0f;
        Shape sx = GraphGraphics.getShape(nodeShape, xMin + off, yMin + off, xMax - off, yMax - off);
        if (borderWidth > 0.0f) {
            this.m_g2d.setPaint(borderPaint);
            if (borderStroke != null) {
                this.m_g2d.setStroke(borderStroke);
            } else {
                this.m_g2d.setStroke(this.getStroke(borderWidth));
            }
            this.m_g2d.draw(sx);
        }
        this.m_g2d.setPaint(fillPaint);
        this.m_g2d.fill(sx);
        return sx;
    }

    public static void getNodeShape(byte nodeShape, float xMin, float yMin, float xMax, float yMax, GeneralPath path) {
        path.reset();
        path.append(GraphGraphics.getShape(nodeShape, xMin, yMin, xMax, yMax), false);
    }

    public final byte defineCustomNodeShape(float[] coords, int offset, int vertexCount) {
        if (vertexCount > 100) {
            throw new IllegalArgumentException("too many vertices (greater than 100)");
        }
        double[] polyCoords = new double[vertexCount * 2];
        for (int i = 0; i < polyCoords.length; ++i) {
            polyCoords[i] = coords[offset + i];
        }
        double xMin = Double.POSITIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < polyCoords.length) {
            xMin = Math.min(xMin, (double)coords[i]);
            xMax = Math.max(xMax, (double)coords[i++]);
            yMin = Math.min(yMin, (double)coords[i]);
            yMax = Math.max(yMax, (double)coords[i++]);
        }
        double xDist = xMax - xMin;
        if (xDist == 0.0) {
            throw new IllegalArgumentException("polygon does not move in the X direction");
        }
        double yDist = yMax - yMin;
        if (yDist == 0.0) {
            throw new IllegalArgumentException("polygon does not move in the Y direction");
        }
        double xMid = (xMin + xMax) / 2.0;
        double yMid = (yMin + yMax) / 2.0;
        int i2 = 0;
        while (i2 < polyCoords.length) {
            double foo = (polyCoords[i2] - xMid) / xDist;
            polyCoords[i2++] = Math.min(Math.max(-0.5, foo), 0.5);
            foo = (polyCoords[i2] - yMid) / yDist;
            polyCoords[i2++] = Math.min(Math.max(-0.5, foo), 0.5);
        }
        int yInterceptsCenter = 0;
        for (int i3 = 0; i3 < vertexCount; ++i3) {
            double x0 = polyCoords[i3 * 2];
            double y0 = polyCoords[i3 * 2 + 1];
            double x1 = polyCoords[(i3 * 2 + 2) % (vertexCount * 2)];
            double y1 = polyCoords[(i3 * 2 + 3) % (vertexCount * 2)];
            double x2 = polyCoords[(i3 * 2 + 4) % (vertexCount * 2)];
            double y2 = polyCoords[(i3 * 2 + 5) % (vertexCount * 2)];
            double distP0P1 = Math.sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0));
            if ((float)distP0P1 == 0.0f) {
                throw new IllegalArgumentException("a line segment has distance [too close to] zero");
            }
            double distP2fromP0P1 = ((y0 - y1) * x2 + (x1 - x0) * y2 + x0 * y1 - x1 * y0) / distP0P1;
            if ((float)distP2fromP0P1 == 0.0f) {
                throw new IllegalArgumentException("either a line segment has distance [too close to] zero or two consecutive line segments are [too close to] parallel");
            }
            double distCenterFromP0P1 = (x0 * y1 - x1 * y0) / distP0P1;
            if (!((float)distCenterFromP0P1 > 0.0f)) {
                throw new IllegalArgumentException("polygon is going counter-clockwise or is not star-shaped with respect to center");
            }
            if (!(Math.min(y0, y1) < 0.0) || !(Math.max(y0, y1) >= 0.0)) continue;
            ++yInterceptsCenter;
        }
        if (yInterceptsCenter != 2) {
            throw new IllegalArgumentException("the polygon self-intersects (we know this because the winding number of the center is not one)");
        }
        byte nextCustomShapeType = (byte)(this.m_lastCustomShapeType + 1);
        if (nextCustomShapeType < 0) {
            throw new IllegalStateException("too many custom node shapes are already defined");
        }
        this.m_lastCustomShapeType = (byte)(this.m_lastCustomShapeType + 1);
        nodeShapes.put(nextCustomShapeType, new LegacyCustomNodeShape(polyCoords, nextCustomShapeType));
        return nextCustomShapeType;
    }

    public final boolean customNodeShapeExists(byte shape) {
        return shape > 8 && shape <= this.m_lastCustomShapeType;
    }

    public final byte[] getCustomNodeShapes() {
        byte[] returnThis = new byte[this.m_lastCustomShapeType - 8];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = (byte)(9 + i);
        }
        return returnThis;
    }

    public final float[] getCustomNodeShape(byte customShape) {
        if (!this.customNodeShapeExists(customShape)) {
            return null;
        }
        LegacyCustomNodeShape ns = (LegacyCustomNodeShape)nodeShapes.get(customShape);
        return ns.getCoords();
    }

    public final void importCustomNodeShapes(GraphGraphics grafx) {
        if (this.m_lastCustomShapeType != 8) {
            throw new IllegalStateException("a custom node shape is already defined in this GraphGraphics");
        }
        for (Map.Entry<Byte, NodeShape> entry : nodeShapes.entrySet()) {
            nodeShapes.put(entry.getKey(), entry.getValue());
            this.m_lastCustomShapeType = (byte)(this.m_lastCustomShapeType + 1);
        }
    }

    private static Shape getShape(byte nodeShape, float xMin, float yMin, float xMax, float yMax) {
        NodeShape ns = nodeShapes.get(nodeShape);
        return ns == null ? null : ns.getShape(xMin, yMin, xMax, yMax);
    }

    public static Map<Byte, Shape> getNodeShapes() {
        HashMap<Byte, Shape> shapeMap = new HashMap<Byte, Shape>();
        for (NodeShape ns : nodeShapes.values()) {
            Shape shape = ns.getShape(0.0f, 0.0f, 32.0f, 32.0f);
            shapeMap.put(ns.getType(), new GeneralPath(shape));
        }
        return shapeMap;
    }

    public static Map<ArrowShape, Shape> getArrowShapes() {
        HashMap<ArrowShape, Shape> shapeMap = new HashMap<ArrowShape, Shape>();
        for (ArrowShape key : arrows.keySet()) {
            shapeMap.put(key, arrows.get(key).getArrowShape());
        }
        return shapeMap;
    }

    public final void drawEdgeLow(float x0, float y0, float x1, float y1, Color edgeColor) {
        if (x0 == x1 && y0 == y1) {
            return;
        }
        this.m_ptsBuff[0] = x0;
        this.m_ptsBuff[1] = y0;
        this.m_ptsBuff[2] = x1;
        this.m_ptsBuff[3] = y1;
        this.getTransform().getPaintAffineTransform().transform(this.m_ptsBuff, 0, this.m_ptsBuff, 0, 2);
        int xNot = (int)this.m_ptsBuff[0];
        int yNot = (int)this.m_ptsBuff[1];
        int xOne = (int)this.m_ptsBuff[2];
        int yOne = (int)this.m_ptsBuff[3];
        this.m_gMinimal.setColor(edgeColor);
        this.m_gMinimal.drawLine(xNot, yNot, xOne, yOne);
    }

    public final void drawEdgeFull(ArrowShape arrow0Type, float arrow0Size, Paint arrow0Paint, ArrowShape arrow1Type, float arrow1Size, Paint arrow1Paint, float x0, float y0, EdgeAnchors anchors, float x1, float y1, float edgeThickness, Stroke edgeStroke, Paint edgePaint) {
        Shape arrow1;
        Shape arrow0;
        int edgePtsCount;
        boolean simpleSegment;
        double curveFactor = CURVE_ELLIPTICAL;
        boolean bl = simpleSegment = arrow0Type == ArrowShapeVisualProperty.NONE && arrow1Type == ArrowShapeVisualProperty.NONE;
        if (!simpleSegment && edgeStroke instanceof BasicStroke && ((BasicStroke)edgeStroke).getEndCap() != 0) {
            BasicStroke bs = (BasicStroke)edgeStroke;
            edgeStroke = new BasicStroke(bs.getLineWidth(), 0, bs.getLineJoin(), bs.getMiterLimit(), bs.getDashArray(), bs.getDashPhase());
        }
        if (anchors == null) {
            anchors = m_noAnchors;
        }
        if ((edgePtsCount = GraphGraphics.computeCubicPolyEdgePath(this.m_edgePtsBuff, this.m_floatBuff, arrow0Type, arrow0Type == ArrowShapeVisualProperty.NONE ? 0.0f : arrow0Size, arrow1Type, arrow1Type == ArrowShapeVisualProperty.NONE ? 0.0f : arrow1Size, x0, y0, anchors, x1, y1, curveFactor)) < 3) {
            if (edgePtsCount == 2) {
                this.drawSimpleEdgeFull(arrow0Type, arrow0Size, arrow0Paint, arrow1Type, arrow1Size, arrow1Paint, (float)this.m_edgePtsBuff[0], (float)this.m_edgePtsBuff[1], (float)this.m_edgePtsBuff[2], (float)this.m_edgePtsBuff[3], edgeThickness, edgeStroke, edgePaint);
            }
            return;
        }
        this.m_g2d.setStroke(edgeStroke);
        this.m_path2d.reset();
        this.m_path2d.moveTo((float)this.m_edgePtsBuff[2], (float)this.m_edgePtsBuff[3]);
        int inx = 4;
        int count = (edgePtsCount - 1) * 6 - 2;
        while (inx < count) {
            this.m_path2d.curveTo((float)this.m_edgePtsBuff[inx++], (float)this.m_edgePtsBuff[inx++], (float)this.m_edgePtsBuff[inx++], (float)this.m_edgePtsBuff[inx++], (float)this.m_edgePtsBuff[inx++], (float)this.m_edgePtsBuff[inx++]);
        }
        this.m_g2d.setPaint(edgePaint);
        this.m_g2d.draw(this.m_path2d);
        if (simpleSegment) {
            return;
        }
        double dx0 = this.m_edgePtsBuff[0] - this.m_edgePtsBuff[4];
        double dy0 = this.m_edgePtsBuff[1] - this.m_edgePtsBuff[5];
        double len0 = Math.sqrt(dx0 * dx0 + dy0 * dy0);
        double cosTheta0 = dx0 / len0;
        double sinTheta0 = dy0 / len0;
        double dx1 = this.m_edgePtsBuff[(edgePtsCount - 1) * 6 - 2] - this.m_edgePtsBuff[(edgePtsCount - 1) * 6 - 6];
        double dy1 = this.m_edgePtsBuff[(edgePtsCount - 1) * 6 - 1] - this.m_edgePtsBuff[(edgePtsCount - 1) * 6 - 5];
        double len1 = Math.sqrt(dx1 * dx1 + dy1 * dy1);
        double cosTheta1 = dx1 / len1;
        double sinTheta1 = dy1 / len1;
        if (edgeStroke instanceof BasicStroke) {
            Shape arrow1Cap;
            Shape arrow0Cap = this.computeUntransformedArrowCap(arrow0Type, (double)arrow0Size / (double)edgeThickness);
            if (arrow0Cap != null) {
                this.m_xformUtil.setTransform(cosTheta0, sinTheta0, -sinTheta0, cosTheta0, this.m_edgePtsBuff[2], this.m_edgePtsBuff[3]);
                this.m_g2d.transform(this.m_xformUtil);
                this.m_g2d.scale(edgeThickness, edgeThickness);
                this.m_g2d.fill(arrow0Cap);
                this.m_g2d.setTransform(this.m_currNativeXform);
            }
            if ((arrow1Cap = this.computeUntransformedArrowCap(arrow1Type, (double)arrow1Size / (double)edgeThickness)) != null) {
                this.m_xformUtil.setTransform(cosTheta1, sinTheta1, -sinTheta1, cosTheta1, this.m_edgePtsBuff[(edgePtsCount - 1) * 6 - 4], this.m_edgePtsBuff[(edgePtsCount - 1) * 6 - 3]);
                this.m_g2d.transform(this.m_xformUtil);
                this.m_g2d.scale(edgeThickness, edgeThickness);
                this.m_g2d.fill(arrow1Cap);
                this.m_g2d.setTransform(this.m_currNativeXform);
            }
        }
        if ((arrow0 = this.computeUntransformedArrow(arrow0Type)) != null) {
            this.m_xformUtil.setTransform(cosTheta0, sinTheta0, -sinTheta0, cosTheta0, this.m_edgePtsBuff[0], this.m_edgePtsBuff[1]);
            this.m_g2d.transform(this.m_xformUtil);
            this.m_g2d.scale(arrow0Size, arrow0Size);
            this.m_g2d.setPaint(arrow0Paint);
            boolean filled = arrow0Type.isFilled();
            if (filled) {
                this.m_g2d.fill(arrow0);
            } else {
                float strokeWidth = 0.25f;
                this.m_g2d.setStroke(new BasicStroke(0.25f));
                this.m_g2d.draw(arrow0);
            }
            this.m_g2d.setTransform(this.m_currNativeXform);
        }
        if ((arrow1 = this.computeUntransformedArrow(arrow1Type)) != null) {
            this.m_xformUtil.setTransform(cosTheta1, sinTheta1, -sinTheta1, cosTheta1, this.m_edgePtsBuff[(edgePtsCount - 1) * 6 - 2], this.m_edgePtsBuff[(edgePtsCount - 1) * 6 - 1]);
            this.m_g2d.transform(this.m_xformUtil);
            this.m_g2d.scale(arrow1Size, arrow1Size);
            this.m_g2d.setPaint(arrow1Paint);
            boolean filled = arrow1Type.isFilled();
            if (filled) {
                this.m_g2d.fill(arrow1);
            } else {
                this.m_g2d.setStroke(new BasicStroke(0.025f));
                this.m_g2d.draw(arrow1);
            }
            this.m_g2d.setTransform(this.m_currNativeXform);
        }
    }

    private final void edgeFullDebug(ArrowShape arrow0Type, float arrow0Size, ArrowShape arrow1Type, float arrow1Size, Stroke edgeStroke, float edgeThickness, EdgeAnchors anchors) {
        if (!(edgeThickness >= 0.0f)) {
            throw new IllegalArgumentException("edgeThickness < 0");
        }
        if (!arrows.containsKey(arrow0Type)) {
            throw new IllegalArgumentException("arrow0Type is not recognized");
        }
        if (arrow0Type != ArrowShapeVisualProperty.NONE && !(arrow0Size >= edgeThickness)) {
            throw new IllegalArgumentException("arrow size must be at least as large as edge thickness");
        }
        if (!arrows.containsKey(arrow1Type)) {
            throw new IllegalArgumentException("arrow1Type is not recognized");
        }
        if (arrow1Type != ArrowShapeVisualProperty.NONE && !(arrow1Size >= edgeThickness)) {
            throw new IllegalArgumentException("arrow size must be at least as large as edge thickness");
        }
        if (anchors.numAnchors() > 256) {
            throw new IllegalArgumentException("at most MAX_EDGE_ANCHORS (256) edge anchors can be specified");
        }
    }

    private final void drawSimpleEdgeFull(ArrowShape arrow0Type, float arrow0Size, Paint arrow0Paint, ArrowShape arrow1Type, float arrow1Size, Paint arrow1Paint, float x0, float y0, float x1, float y1, float edgeThickness, Stroke edgeStroke, Paint edgePaint) {
        Shape arrow1;
        Shape arrow0;
        int simpleSegment;
        double y1Adj;
        double len = Math.sqrt(((double)x1 - (double)x0) * ((double)x1 - (double)x0) + ((double)y1 - (double)y0) * ((double)y1 - (double)y0));
        if (len == 0.0) {
            return;
        }
        double t0 = GraphGraphics.getT(arrow0Type) * (double)arrow0Size / len;
        double x0Adj = t0 * ((double)x1 - (double)x0) + (double)x0;
        double y0Adj = t0 * ((double)y1 - (double)y0) + (double)y0;
        double t1 = GraphGraphics.getT(arrow1Type) * (double)arrow1Size / len;
        double x1Adj = t1 * ((double)x0 - (double)x1) + (double)x1;
        if (((double)x1 - (double)x0) * (x1Adj - x0Adj) + ((double)y1 - (double)y0) * ((y1Adj = t1 * ((double)y0 - (double)y1) + (double)y1) - y0Adj) > 0.0) {
            simpleSegment = arrow0Type == ArrowShapeVisualProperty.NONE && arrow1Type == ArrowShapeVisualProperty.NONE ? 1 : -1;
            this.m_g2d.setStroke(edgeStroke);
            this.m_line2d.setLine(x0Adj, y0Adj, x1Adj, y1Adj);
            this.m_g2d.setPaint(edgePaint);
            this.m_g2d.draw(this.m_line2d);
            if (simpleSegment > 0) {
                return;
            }
        } else {
            simpleSegment = 0;
        }
        double cosTheta = ((double)x0 - (double)x1) / len;
        double sinTheta = ((double)y0 - (double)y1) / len;
        if (simpleSegment < 0 && edgeStroke instanceof BasicStroke) {
            Shape arrow1Cap;
            Shape arrow0Cap = this.computeUntransformedArrowCap(arrow0Type, (double)arrow0Size / (double)edgeThickness);
            if (arrow0Cap != null) {
                this.m_xformUtil.setTransform(cosTheta, sinTheta, -sinTheta, cosTheta, x0Adj, y0Adj);
                this.m_g2d.transform(this.m_xformUtil);
                this.m_g2d.scale(edgeThickness, edgeThickness);
                this.m_g2d.fill(arrow0Cap);
                this.m_g2d.setTransform(this.m_currNativeXform);
            }
            if ((arrow1Cap = this.computeUntransformedArrowCap(arrow1Type, (double)arrow1Size / (double)edgeThickness)) != null) {
                this.m_xformUtil.setTransform(-cosTheta, -sinTheta, sinTheta, -cosTheta, x1Adj, y1Adj);
                this.m_g2d.transform(this.m_xformUtil);
                this.m_g2d.scale(edgeThickness, edgeThickness);
                this.m_g2d.fill(arrow1Cap);
                this.m_g2d.setTransform(this.m_currNativeXform);
            }
        }
        if ((arrow0 = this.computeUntransformedArrow(arrow0Type)) != null) {
            this.m_xformUtil.setTransform(cosTheta, sinTheta, -sinTheta, cosTheta, x0, y0);
            this.m_g2d.transform(this.m_xformUtil);
            this.m_g2d.scale(arrow0Size, arrow0Size);
            this.m_g2d.setPaint(arrow0Paint);
            boolean filled = arrow0Type.isFilled();
            if (filled) {
                this.m_g2d.fill(arrow0);
            } else {
                this.m_g2d.setStroke(new BasicStroke(0.25f));
                if (arrow0Type == ArrowShapeVisualProperty.OPEN_CIRCLE) {
                    this.m_g2d.setStroke(new BasicStroke(0.1f));
                }
                this.m_g2d.draw(arrow0);
            }
            this.m_g2d.setTransform(this.m_currNativeXform);
        }
        if ((arrow1 = this.computeUntransformedArrow(arrow1Type)) != null) {
            this.m_xformUtil.setTransform(-cosTheta, -sinTheta, sinTheta, -cosTheta, x1, y1);
            this.m_g2d.transform(this.m_xformUtil);
            this.m_g2d.scale(arrow1Size, arrow1Size);
            this.m_g2d.setPaint(arrow1Paint);
            boolean filled = arrow1Type.isFilled();
            if (filled) {
                this.m_g2d.fill(arrow1);
            } else {
                this.m_g2d.setStroke(new BasicStroke(0.25f));
                if (arrow1Type == ArrowShapeVisualProperty.OPEN_CIRCLE) {
                    this.m_g2d.setStroke(new BasicStroke(0.1f));
                }
                this.m_g2d.draw(arrow1);
            }
            this.m_g2d.setTransform(this.m_currNativeXform);
        }
    }

    public static boolean getEdgePath(ArrowShape arrow0Type, float arrow0Size, ArrowShape arrow1Type, float arrow1Size, float x0, float y0, EdgeAnchors anchors, float x1, float y1, GeneralPath path) {
        ArrowShape arrow1;
        ArrowShape arrow0;
        float[] floatBuff;
        double[] edgePtsBuff;
        int edgePtsCount;
        double curveFactor = CURVE_ELLIPTICAL;
        if (anchors == null) {
            anchors = m_noAnchors;
        }
        if ((edgePtsCount = GraphGraphics.computeCubicPolyEdgePath(edgePtsBuff = new double[1542], floatBuff = new float[2], arrow0 = arrow0Type, arrow0 == ArrowShapeVisualProperty.NONE ? 0.0f : arrow0Size, arrow1 = arrow1Type, arrow1 == ArrowShapeVisualProperty.NONE ? 0.0f : arrow1Size, x0, y0, anchors, x1, y1, curveFactor)) < 3) {
            if (edgePtsCount == 2) {
                path.reset();
                path.moveTo((float)edgePtsBuff[0], (float)edgePtsBuff[1]);
                path.lineTo((float)edgePtsBuff[2], (float)edgePtsBuff[3]);
                return true;
            }
            return false;
        }
        path.reset();
        path.moveTo((float)edgePtsBuff[0], (float)edgePtsBuff[1]);
        path.lineTo((float)edgePtsBuff[2], (float)edgePtsBuff[3]);
        int inx = 4;
        int count = (edgePtsCount - 1) * 6 - 2;
        while (inx < count) {
            path.curveTo((float)edgePtsBuff[inx++], (float)edgePtsBuff[inx++], (float)edgePtsBuff[inx++], (float)edgePtsBuff[inx++], (float)edgePtsBuff[inx++], (float)edgePtsBuff[inx++]);
        }
        path.lineTo((float)edgePtsBuff[count], (float)edgePtsBuff[count + 1]);
        return true;
    }

    private final Shape computeUntransformedArrow(ArrowShape arrowType) {
        Arrow a = arrows.get(arrowType);
        return a == null ? null : a.getArrowShape();
    }

    private final Shape computeUntransformedArrowCap(ArrowShape arrowType, double ratio) {
        Arrow a = arrows.get(arrowType);
        return a == null ? null : a.getCapShape(ratio);
    }

    private static final double getT(ArrowShape arrowType) {
        Arrow a = arrows.get(arrowType);
        return a == null ? 0.125 : a.getTOffset();
    }

    private static int computeCubicPolyEdgePath(double[] edgePtsBuff, float[] floatBuff, ArrowShape arrow0Type, float arrow0Size, ArrowShape arrow1Type, float arrow1Size, float x0, float y0, EdgeAnchors anchors, float x1, float y1, double curveFactor) {
        int numAnchors = anchors.numAnchors();
        edgePtsBuff[0] = x0;
        edgePtsBuff[1] = y0;
        int edgePtsCount = 1;
        int anchorInx = 0;
        while (anchorInx < numAnchors) {
            anchors.getAnchor(anchorInx++, floatBuff);
            if (floatBuff[0] == x0 && floatBuff[1] == y0) continue;
            edgePtsBuff[2] = floatBuff[0];
            edgePtsBuff[3] = floatBuff[1];
            edgePtsCount = 2;
            break;
        }
        while (anchorInx < numAnchors) {
            anchors.getAnchor(anchorInx++, floatBuff);
            edgePtsBuff[edgePtsCount * 2] = floatBuff[0];
            edgePtsBuff[edgePtsCount * 2 + 1] = floatBuff[1];
            ++edgePtsCount;
        }
        edgePtsBuff[edgePtsCount * 2] = x1;
        edgePtsBuff[edgePtsCount * 2 + 1] = y1;
        ++edgePtsCount;
        while (edgePtsCount > 1 && edgePtsBuff[edgePtsCount * 2 - 2] == edgePtsBuff[edgePtsCount * 2 - 4] && edgePtsBuff[edgePtsCount * 2 - 1] == edgePtsBuff[edgePtsCount * 2 - 3]) {
            --edgePtsCount;
        }
        if (edgePtsCount < 3) {
            return edgePtsCount;
        }
        int edgePtsCountToReturn = edgePtsCount--;
        edgePtsBuff[edgePtsCount * 6 - 2] = edgePtsBuff[edgePtsCount * 2];
        edgePtsBuff[edgePtsCount * 6 - 1] = edgePtsBuff[edgePtsCount * 2 + 1];
        double dx = edgePtsBuff[edgePtsCount * 2 - 2] - edgePtsBuff[edgePtsCount * 2];
        double dy = edgePtsBuff[edgePtsCount * 2 - 1] - edgePtsBuff[edgePtsCount * 2 + 1];
        double len = Math.sqrt(dx * dx + dy * dy);
        edgePtsBuff[edgePtsCount * 6 - 4] = edgePtsBuff[edgePtsCount * 6 - 2] + (dx /= len) * (double)arrow1Size * GraphGraphics.getT(arrow1Type);
        edgePtsBuff[edgePtsCount * 6 - 3] = edgePtsBuff[edgePtsCount * 6 - 1] + (dy /= len) * (double)arrow1Size * GraphGraphics.getT(arrow1Type);
        double candX1 = edgePtsBuff[edgePtsCount * 6 - 4] + dx * 2.0 * (double)arrow1Size;
        double candX2 = edgePtsBuff[edgePtsCount * 6 - 4] + curveFactor * (edgePtsBuff[edgePtsCount * 2 - 2] - edgePtsBuff[edgePtsCount * 6 - 4]);
        edgePtsBuff[edgePtsCount * 6 - 6] = Math.abs(candX1 - edgePtsBuff[edgePtsCount * 2]) > Math.abs(candX2 - edgePtsBuff[edgePtsCount * 2]) ? candX1 : candX2;
        double candY1 = edgePtsBuff[edgePtsCount * 6 - 3] + dy * 2.0 * (double)arrow1Size;
        double candY2 = edgePtsBuff[edgePtsCount * 6 - 3] + curveFactor * (edgePtsBuff[edgePtsCount * 2 - 1] - edgePtsBuff[edgePtsCount * 6 - 3]);
        edgePtsBuff[edgePtsCount * 6 - 5] = Math.abs(candY1 - edgePtsBuff[edgePtsCount * 2 + 1]) > Math.abs(candY2 - edgePtsBuff[edgePtsCount * 2 + 1]) ? candY1 : candY2;
        while (edgePtsCount > 2) {
            double midX = (edgePtsBuff[--edgePtsCount * 2 - 2] + edgePtsBuff[edgePtsCount * 2]) / 2.0;
            double midY = (edgePtsBuff[edgePtsCount * 2 - 1] + edgePtsBuff[edgePtsCount * 2 + 1]) / 2.0;
            edgePtsBuff[edgePtsCount * 6 - 2] = midX + (edgePtsBuff[edgePtsCount * 2] - midX) * curveFactor;
            edgePtsBuff[edgePtsCount * 6 - 1] = midY + (edgePtsBuff[edgePtsCount * 2 + 1] - midY) * curveFactor;
            edgePtsBuff[edgePtsCount * 6 - 4] = midX;
            edgePtsBuff[edgePtsCount * 6 - 3] = midY;
            edgePtsBuff[edgePtsCount * 6 - 6] = midX + (edgePtsBuff[edgePtsCount * 2 - 2] - midX) * curveFactor;
            edgePtsBuff[edgePtsCount * 6 - 5] = midY + (edgePtsBuff[edgePtsCount * 2 - 1] - midY) * curveFactor;
        }
        dx = edgePtsBuff[2] - edgePtsBuff[0];
        dy = edgePtsBuff[3] - edgePtsBuff[1];
        len = Math.sqrt(dx * dx + dy * dy);
        double segStartX = edgePtsBuff[0] + (dx /= len) * (double)arrow0Size * GraphGraphics.getT(arrow0Type);
        double segStartY = edgePtsBuff[1] + (dy /= len) * (double)arrow0Size * GraphGraphics.getT(arrow0Type);
        double candX12 = segStartX + dx * 2.0 * (double)arrow0Size;
        double candX22 = segStartX + curveFactor * (edgePtsBuff[2] - segStartX);
        edgePtsBuff[4] = Math.abs(candX12 - edgePtsBuff[0]) > Math.abs(candX22 - edgePtsBuff[0]) ? candX12 : candX22;
        double candY12 = segStartY + dy * 2.0 * (double)arrow0Size;
        double candY22 = segStartY + curveFactor * (edgePtsBuff[3] - segStartY);
        edgePtsBuff[5] = Math.abs(candY12 - edgePtsBuff[1]) > Math.abs(candY22 - edgePtsBuff[1]) ? candY12 : candY22;
        edgePtsBuff[2] = segStartX;
        edgePtsBuff[3] = segStartY;
        return edgePtsCountToReturn;
    }

    public static final boolean computeEdgeIntersection(byte nodeShape, float xMin, float yMin, float xMax, float yMax, float offset, float ptX, float ptY, float[] returnVal) {
        NodeShape ns = nodeShapes.get(nodeShape);
        return ns == null ? false : ns.computeEdgeIntersection(xMin, yMin, xMax, yMax, ptX, ptY, returnVal);
    }

    public final FontRenderContext getFontRenderContextLow() {
        return this.m_gMinimal.getFontRenderContext();
    }

    public final void drawTextFull(LabelLineInfo labelLineInfo, float xCenter, float yCenter, double xAnchor, double yAnchor, float theta, Paint paint, Paint backgroundPaint, byte backgroundShape, boolean drawTextAsShape) {
        if (theta != 0.0f) {
            this.m_g2d.rotate(theta, xAnchor, yAnchor);
        }
        this.m_g2d.translate(xCenter, yCenter);
        this.m_g2d.setPaint(paint);
        if (drawTextAsShape) {
            GlyphVector glyphV = labelLineInfo.getGlyphVector();
            Rectangle2D glyphBounds = glyphV.getLogicalBounds();
            this.m_g2d.translate(-glyphBounds.getCenterX(), -glyphBounds.getCenterY());
            this.drawLabelBackground(glyphBounds, backgroundPaint, backgroundShape);
            this.m_g2d.fill(labelLineInfo.getShape());
        } else {
            String text = labelLineInfo.getText();
            Font font = labelLineInfo.getFont();
            Rectangle2D textBounds = font.getStringBounds(text, this.getFontRenderContextFull());
            this.m_g2d.translate(-textBounds.getCenterX(), -textBounds.getCenterY());
            this.drawLabelBackground(textBounds, backgroundPaint, backgroundShape);
            this.m_g2d.setFont(font);
            this.m_g2d.drawString(text, 0.0f, 0.0f);
        }
        this.m_g2d.setTransform(this.m_currNativeXform);
    }

    private void drawLabelBackground(Rectangle2D bounds, Paint paint, byte shape) {
        if (shape >= 0) {
            Graphics2D g_back = (Graphics2D)this.m_g2d.create();
            float padding = 0.0f;
            Shape bgs = GraphGraphics.getShape(shape, (float)bounds.getMinX() - padding, (float)bounds.getMinY() - padding, (float)bounds.getMaxX() + padding, (float)bounds.getMaxY() + padding);
            g_back.setPaint(paint);
            g_back.fill(bgs);
            g_back.dispose();
        }
    }

    public final FontRenderContext getFontRenderContextFull() {
        return this.m_fontRenderContextFull;
    }

    public final void drawCustomGraphicImage(Shape shape, float xOffset, float yOffset, TexturePaint paint) {
        this.m_g2d.translate(xOffset, yOffset);
        if (paint instanceof TexturePaint) {
            BufferedImage bImg = paint.getImage();
            Rectangle bounds = shape.getBounds2D().getBounds();
            this.m_g2d.drawImage(bImg, bounds.x, bounds.y, bounds.width, bounds.height, null);
        }
        this.m_g2d.setTransform(this.m_currNativeXform);
    }

    public final void drawCustomGraphicFull(CyNetworkView netView, View<CyNode> node, Shape nodeShape, CustomGraphicLayer cg, float xOffset, float yOffset) {
        this.m_g2d.translate(xOffset, yOffset);
        if (cg instanceof PaintedShape) {
            PaintedShape ps = (PaintedShape)cg;
            Shape shape = ps.getShape();
            if (ps.getStroke() != null) {
                Paint strokePaint = ps.getStrokePaint();
                if (strokePaint == null) {
                    strokePaint = Color.BLACK;
                }
                this.m_g2d.setPaint(strokePaint);
                this.m_g2d.setStroke(ps.getStroke());
                this.m_g2d.draw(shape);
            }
            this.m_g2d.setPaint(ps.getPaint());
            this.m_g2d.fill(shape);
        } else if (cg instanceof Cy2DGraphicLayer) {
            Cy2DGraphicLayer layer = (Cy2DGraphicLayer)cg;
            layer.draw(this.m_g2d, nodeShape, netView, node);
        } else if (cg instanceof ImageCustomGraphicLayer) {
            Rectangle bounds = cg.getBounds2D().getBounds();
            BufferedImage img = ((ImageCustomGraphicLayer)cg).getPaint((Rectangle2D)bounds).getImage();
            this.m_g2d.drawImage(img, bounds.x, bounds.y, bounds.width, bounds.height, null);
        } else {
            Rectangle2D bounds = nodeShape.getBounds2D();
            this.m_g2d.setPaint(cg.getPaint(bounds));
            this.m_g2d.fill(nodeShape);
        }
        this.m_g2d.setTransform(this.m_currNativeXform);
    }

    private final Stroke getStroke(float borderWidth) {
        Stroke s = borderStrokes.get(Float.valueOf(borderWidth));
        if (s == null) {
            s = new BasicStroke(borderWidth);
            borderStrokes.put(Float.valueOf(borderWidth), s);
        }
        return s;
    }

    private void checkOrder(float min, float max, String id) {
        if (!(min < max)) {
            throw new IllegalArgumentException(id + "Min not less than " + id + "Max");
        }
    }

    static {
        nodeShapes.put((byte)0, new RectangleNodeShape());
        nodeShapes.put((byte)2, new EllipseNodeShape());
        nodeShapes.put((byte)6, new RoundedRectangleNodeShape());
        nodeShapes.put((byte)1, new DiamondNodeShape());
        nodeShapes.put((byte)3, new HexagonNodeShape());
        nodeShapes.put((byte)4, new OctagonNodeShape());
        nodeShapes.put((byte)5, new ParallelogramNodeShape());
        nodeShapes.put((byte)7, new TriangleNodeShape());
        nodeShapes.put((byte)8, new VeeNodeShape());
        arrows = new HashMap<ArrowShape, Arrow>();
        arrows.put(ArrowShapeVisualProperty.NONE, new NoArrow());
        arrows.put(ArrowShapeVisualProperty.DELTA, new DeltaArrow());
        arrows.put(ArrowShapeVisualProperty.CIRCLE, new DiscArrow());
        arrows.put(ArrowShapeVisualProperty.DIAMOND, new DiamondArrow());
        arrows.put(ArrowShapeVisualProperty.T, new TeeArrow());
        arrows.put(ArrowShapeVisualProperty.ARROW, new ArrowheadArrow());
        arrows.put(ArrowShapeVisualProperty.HALF_TOP, new HalfTopArrow());
        arrows.put(ArrowShapeVisualProperty.HALF_BOTTOM, new HalfBottomArrow());
        arrows.put(ArrowShapeVisualProperty.DELTA_SHORT_1, new DeltaArrowShort1());
        arrows.put(ArrowShapeVisualProperty.DELTA_SHORT_2, new DeltaArrowShort2());
        arrows.put(ArrowShapeVisualProperty.ARROW_SHORT, new ArrowheadArrowShort());
        arrows.put(ArrowShapeVisualProperty.DIAMOND_SHORT_1, new DiamondArrowShort1());
        arrows.put(ArrowShapeVisualProperty.DIAMOND_SHORT_2, new DiamondArrowShort2());
        arrows.put(ArrowShapeVisualProperty.OPEN_CIRCLE, new DiscArrow());
        arrows.put(ArrowShapeVisualProperty.OPEN_DELTA, new DeltaArrow());
        arrows.put(ArrowShapeVisualProperty.OPEN_DIAMOND, new DiamondArrow());
        arrows.put(ArrowShapeVisualProperty.HALF_CIRCLE, new HalfCircleArrow(true));
        arrows.put(ArrowShapeVisualProperty.OPEN_HALF_CIRCLE, new HalfCircleArrow(false));
        arrows.put(ArrowShapeVisualProperty.SQUARE, new SquareArrow());
        arrows.put(ArrowShapeVisualProperty.OPEN_SQUARE, new SquareArrow());
        arrows.put(ArrowShapeVisualProperty.CROSS_DELTA, new CrossDeltaArrow());
        arrows.put(ArrowShapeVisualProperty.CROSS_OPEN_DELTA, new CrossDeltaArrow());
    }
}

