/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.internal.util;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGUniverse;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import javax.swing.Icon;

public class SVGIcon
implements Icon {
    private final int width;
    private final int height;
    private final SVGDiagram diagram;

    public SVGIcon(String svg, int width, int height) {
        if (svg == null || svg.isBlank()) {
            throw new IllegalArgumentException("'svg' must not be null or empty");
        }
        this.width = width;
        this.height = height;
        SVGUniverse universe = new SVGUniverse();
        StringReader is = new StringReader(svg);
        URI uri = universe.loadSVG((Reader)is, "about");
        this.diagram = universe.getDiagram(uri);
        this.diagram.setIgnoringClipHeuristic(true);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int w = this.width;
        int h = this.height;
        double iw = this.diagram.getWidth();
        double ih = this.diagram.getHeight();
        double nw = iw;
        double nh = ih;
        if (w == 0 || h == 0 || iw == 0.0 || ih == 0.0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (iw > (double)w) {
            nw = w;
            nh = nw * ih / iw;
        }
        if (nh > (double)h) {
            nh = h;
            nw = nh * iw / ih;
        }
        g2.translate((double)x + ((double)w - nw) / 2.0, (double)y);
        g2.scale(nw / iw, nh / ih);
        try {
            this.diagram.render(g2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        g2.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

